/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.message.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.message.model.BizTypeEnum;
import com.kingdee.bos.qing.message.model.MessageReadFlagEnum;
import com.kingdee.bos.qing.message.model.MessageTypeEnum;
import com.kingdee.bos.qing.message.model.po.MessageReceiverRelPO;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MessageReceiverRelDaoImpl {
    private IDBExcuter dbExcuter;

    public MessageReceiverRelDaoImpl(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public List<String> insertList(List<MessageReceiverRelPO> messageReceiverRelPOList) throws AbstractQingIntegratedException, SQLException {
        if (CollectionUtils.isEmpty(messageReceiverRelPOList)) {
            return null;
        }
        ArrayList<String> idList = new ArrayList<String>(16);
        int count = messageReceiverRelPOList.size();
        ArrayList<Object[]> paramsContentList = new ArrayList<Object[]>(count);
        for (int i = 0; i < count; ++i) {
            MessageReceiverRelPO messageReceiverRelPO = messageReceiverRelPOList.get(i);
            Object[] paramsContents = new Object[5];
            String fid = messageReceiverRelPO.getMessageReceiverRelId();
            if (fid == null) {
                fid = this.dbExcuter.genStringId("T_QING_MESSAGE_RECEIVER_REL");
            }
            paramsContents[0] = fid;
            paramsContents[1] = messageReceiverRelPO.getMessageId();
            paramsContents[2] = messageReceiverRelPO.getReceiverId();
            paramsContents[3] = messageReceiverRelPO.getIsRead();
            paramsContents[4] = messageReceiverRelPO.getReadDate();
            paramsContentList.add(paramsContents);
            idList.add(fid);
        }
        this.dbExcuter.executeBatch("INSERT INTO T_QING_MESSAGE_RECEIVER_REL(FID,FMESSAGEID,FRECEVIERID,FISREAD,FREADDATE) values (?,?,?,?,?)", paramsContentList);
        return idList;
    }

    public void readMessage(String messageReceiverRelId, MessageReadFlagEnum readFlagEnum) throws AbstractQingIntegratedException, SQLException {
        if (StringUtils.isEmpty((CharSequence)messageReceiverRelId)) {
            return;
        }
        this.dbExcuter.execute("UPDATE T_QING_MESSAGE_RECEIVER_REL SET FISREAD=?,FREADDATE=? WHERE FID=?", new Object[]{readFlagEnum.getIsRead(), new Date(), messageReceiverRelId});
    }

    public void readMessageList(List<String> messageIds, String receiverId) throws AbstractQingIntegratedException, SQLException {
        if (CollectionUtils.isEmpty(messageIds) || StringUtils.isEmpty((CharSequence)receiverId)) {
            return;
        }
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder sql = new StringBuilder("update ").append("T_QING_MESSAGE_RECEIVER_REL").append(" SET FISREAD=?,FREADDATE=? WHERE FRECEVIERID in (");
        params.add(MessageReadFlagEnum.READ.getIsRead());
        params.add(new Date());
        for (String messageId : messageIds) {
            sql.append("?,");
            params.add(messageId);
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(") AND FRECEVIERID=? AND FISREAD='0' ");
        params.add(receiverId);
        this.dbExcuter.execute(sql.toString(), params.toArray());
    }

    public void clearUnReadMessage(String receiverId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("UPDATE T_QING_MESSAGE_RECEIVER_REL SET FISREAD='1' WHERE FRECEVIERID=? AND FISREAD='0'", new Object[]{receiverId});
    }

    public void deleteMessageReceiverRel(String messageReceiverRelId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_MESSAGE_RECEIVER_REL WHERE FID=?", new Object[]{messageReceiverRelId});
    }

    public void deleteMessageByMessageId(String messageId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_MESSAGE_RECEIVER_REL WHERE FMESSAGEID=?", new Object[]{messageId});
    }

    public MessageReceiverRelPO getByMessageIdAndReceiverId(String messageReceiverRelId, String userId) throws AbstractQingIntegratedException, SQLException {
        return (MessageReceiverRelPO)this.dbExcuter.query("SELECT FID,FMESSAGEID,FRECEVIERID,FISREAD,FREADDATE FROM T_QING_MESSAGE_RECEIVER_REL WHERE FMESSAGEID=? AND FRECEVIERID=?", new Object[]{messageReceiverRelId, userId}, (ResultHandler)new ResultHandler<MessageReceiverRelPO>(){

            public MessageReceiverRelPO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    MessageReceiverRelPO messageReceiverRelPO = new MessageReceiverRelPO();
                    messageReceiverRelPO.setMessageReceiverRelId(rs.getString("FID"));
                    messageReceiverRelPO.setMessageId(rs.getString("FMESSAGEID"));
                    messageReceiverRelPO.setIsRead(rs.getString("FISREAD"));
                    messageReceiverRelPO.setReceiverId(rs.getString("FRECEVIERID"));
                    messageReceiverRelPO.setReadDate(rs.getDate("FREADDATE"));
                    return messageReceiverRelPO;
                }
                return null;
            }
        });
    }

    public MessageReceiverRelPO getById(String messageReceiverRelId, String userId) throws AbstractQingIntegratedException, SQLException {
        return (MessageReceiverRelPO)this.dbExcuter.query("SELECT FID,FMESSAGEID,FRECEVIERID,FISREAD,FREADDATE FROM T_QING_MESSAGE_RECEIVER_REL WHERE FID=? AND FRECEVIERID=?", new Object[]{messageReceiverRelId, userId}, (ResultHandler)new ResultHandler<MessageReceiverRelPO>(){

            public MessageReceiverRelPO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    MessageReceiverRelPO messageReceiverRelPO = new MessageReceiverRelPO();
                    messageReceiverRelPO.setMessageReceiverRelId(rs.getString("FID"));
                    messageReceiverRelPO.setMessageId(rs.getString("FMESSAGEID"));
                    messageReceiverRelPO.setIsRead(rs.getString("FISREAD"));
                    messageReceiverRelPO.setReceiverId(rs.getString("FRECEVIERID"));
                    messageReceiverRelPO.setReadDate(rs.getDate("FREADDATE"));
                    return messageReceiverRelPO;
                }
                return null;
            }
        });
    }

    public List<MessageReceiverRelPO> getByMessageId(String messageId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FID,FMESSAGEID,FRECEVIERID,FISREAD,FREADDATE FROM T_QING_MESSAGE_RECEIVER_REL WHERE FMESSAGEID=?", new Object[]{messageId}, (ResultHandler)new ResultHandler<List<MessageReceiverRelPO>>(){
            List<MessageReceiverRelPO> resultList = new ArrayList<MessageReceiverRelPO>(16);

            public List<MessageReceiverRelPO> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    MessageReceiverRelPO messageReceiverRelPO = new MessageReceiverRelPO();
                    messageReceiverRelPO.setMessageReceiverRelId(rs.getString("FID"));
                    messageReceiverRelPO.setMessageId(rs.getString("FMESSAGEID"));
                    messageReceiverRelPO.setIsRead(rs.getString("FISREAD"));
                    messageReceiverRelPO.setReceiverId(rs.getString("FRECEVIERID"));
                    messageReceiverRelPO.setReadDate(rs.getDate("FREADDATE"));
                    this.resultList.add(messageReceiverRelPO);
                }
                return this.resultList;
            }
        });
    }

    public void deleteByMessageIds(List<String> deleteMessageIdList) throws AbstractQingIntegratedException, SQLException {
        int count = deleteMessageIdList.size();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(count);
        for (int i = 0; i < count; ++i) {
            String messageId = deleteMessageIdList.get(i);
            Object[] params = new Object[]{messageId};
            paramsList.add(params);
        }
        this.dbExcuter.executeBatch("DELETE FROM T_QING_MESSAGE_RECEIVER_REL WHERE FMESSAGEID=?", paramsList);
    }

    public void deleteByIds(List<String> idList) throws AbstractQingIntegratedException, SQLException {
        int count = idList.size();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(count);
        for (int i = 0; i < count; ++i) {
            String messageId = idList.get(i);
            Object[] params = new Object[]{messageId};
            paramsList.add(params);
        }
        this.dbExcuter.executeBatch("DELETE FROM T_QING_MESSAGE_RECEIVER_REL WHERE FID=?", paramsList);
    }

    public void deleteInvalidEffectivedate() throws AbstractQingIntegratedException, SQLException {
        StringBuilder sql = new StringBuilder("DELETE FROM T_QING_MESSAGE_RECEIVER_REL A WHERE NOT EXISTS (SELECT 1 FROM T_QING_MESSAGE_RECEIVER_REL B WHERE A.FID=B.FMESSAGEID) AND A.FMESSAGETYPE=?");
        ArrayList<String> params = new ArrayList<String>();
        params.add(MessageTypeEnum.BIZ_NEWS.getMessageType());
        this.dbExcuter.execute(sql.toString(), params.toArray());
    }

    public List<String> queryAuthAndQuartz(String userId) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT QMR.FID,QMR.FMESSAGEID FROM(");
        sql.append("SELECT FID,FMESSAGEID FROM T_QING_MESSAGE_RECEIVER_REL  WHERE FRECEVIERID=?");
        sql.append(") QMR ");
        sql.append("LEFT JOIN T_QING_MESSAGE QM ON QM.FID=QMR.FMESSAGEID");
        sql.append(" WHERE QM.FBIZTYPE IN (?,?,?)");
        sql.append(" ORDER BY QM.FSENDDATE DESC");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(userId);
        paramList.add(BizTypeEnum.AUTHORIZED_NEWS.getBizType());
        paramList.add(BizTypeEnum.QUARTZ_NEWS.getBizType());
        paramList.add(BizTypeEnum.LAPP_SYNC_ROLE.getBizType());
        return (List)this.dbExcuter.query(sql.toString(), paramList.toArray(), (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> idList = new ArrayList<String>(10);
                while (rs.next()) {
                    idList.add(rs.getString("FID"));
                }
                return idList;
            }
        });
    }

    public List<String> queryReceiverIdsByBizid(String bizId) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT QMR.FRECEVIERID FROM T_QING_MESSAGE_RECEIVER_REL QMR ");
        sql.append("LEFT JOIN T_QING_MESSAGE QM ON QM.FID=QMR.FMESSAGEID");
        sql.append(" WHERE QM.FBIZID= ?");
        sql.append(" ORDER BY QM.FSENDDATE DESC");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(bizId);
        return (List)this.dbExcuter.query(sql.toString(), paramList.toArray(), (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> idList = new ArrayList<String>(10);
                while (rs.next()) {
                    idList.add(rs.getString("FRECEVIERID"));
                }
                return idList;
            }
        });
    }

    public void messageToUnreadById(String messageReceiverRelId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("UPDATE T_QING_MESSAGE_RECEIVER_REL SET FISREAD=?,FREADDATE=? WHERE FID=?", new Object[]{MessageReadFlagEnum.UNREAD.getIsRead(), new Date(), messageReceiverRelId});
    }
}

