/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.message.domain;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.common.secret.SecretUtil;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.message.dao.MessageDao;
import com.kingdee.bos.qing.message.dao.MessageReceiverRelDaoImpl;
import com.kingdee.bos.qing.message.domain.IMessageDomain;
import com.kingdee.bos.qing.message.domain.MessageDomainFactory;
import com.kingdee.bos.qing.message.exception.MessageDecryptErrorException;
import com.kingdee.bos.qing.message.exception.MessageDeleteNoAuthException;
import com.kingdee.bos.qing.message.exception.MessageException;
import com.kingdee.bos.qing.message.exception.MessageParamErrorException;
import com.kingdee.bos.qing.message.model.BizTypeEnum;
import com.kingdee.bos.qing.message.model.MessageLevelTypeEnum;
import com.kingdee.bos.qing.message.model.MessageReadFlagEnum;
import com.kingdee.bos.qing.message.model.MessageTypeEnum;
import com.kingdee.bos.qing.message.model.po.MessagePO;
import com.kingdee.bos.qing.message.model.po.MessageReceiverRelPO;
import com.kingdee.bos.qing.message.model.vo.AbstractMessageDetailVO;
import com.kingdee.bos.qing.message.model.vo.BaseMessageDeailVO;
import com.kingdee.bos.qing.message.model.vo.MessageModelVO;
import com.kingdee.bos.qing.message.model.vo.SaveMessageVo;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MessageDomain {
    private QingContext qingContext;
    private IDBExcuter dbExcuter;
    protected ITransactionManagement tx;
    private static final String DELETE_FLAG = "1";
    private static final String CACHE_SYNC_KEY = "qing_message_sync_";
    private static final String CACHE_DELETE_BY_UER_KEY = "qing_message_delete_by_user_";
    private static final String START_SYNC_TIME_KEY = "qing_message_start_sync_time_";
    private static final String MESSAGE_FINISH_SYNC_LOCK_KEY = "qing_message_finish_sync_lock_";
    public static final long EXPIRES_TIME = 300000L;
    private static Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private static final int SAVE_TOTAL_COUNT = 300;
    private MessageDao messageDao;
    private MessageReceiverRelDaoImpl messageReceiverRelDao;

    public MessageDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter) {
        this.qingContext = qingContext;
        this.dbExcuter = dbExcuter;
        this.tx = tx;
    }

    private MessageDao getMessageDao() {
        if (this.messageDao == null) {
            this.messageDao = new MessageDao(this.dbExcuter);
        }
        return this.messageDao;
    }

    protected MessageReceiverRelDaoImpl getMessageReceiverRelDao() {
        if (this.messageReceiverRelDao == null) {
            this.messageReceiverRelDao = new MessageReceiverRelDaoImpl(this.dbExcuter);
        }
        return this.messageReceiverRelDao;
    }

    public String saveMessageNoTx(SaveMessageVo saveMessageVo) throws AbstractQingIntegratedException, SQLException, MessageParamErrorException {
        String messageId = this.addMessage(saveMessageVo);
        return messageId;
    }

    public String saveMessageWithTx(SaveMessageVo saveMessageVo) throws AbstractQingIntegratedException, SQLException, MessageParamErrorException {
        try {
            String messageId;
            this.tx.beginRequired();
            String string = messageId = this.addMessage(saveMessageVo);
            return string;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    private String addMessage(SaveMessageVo saveMessageVo) throws MessageParamErrorException, AbstractQingIntegratedException, SQLException {
        String messageId = null;
        String userId = this.qingContext.getUserId();
        Calendar currentDate = Calendar.getInstance();
        MessagePO messagePO = new MessagePO();
        messagePO.setSenderId(userId);
        messagePO.setMessageType(saveMessageVo.getMessageType().getMessageType());
        messagePO.setMessageLevel(saveMessageVo.getMessageLevel().getMessageLevel());
        messagePO.setMessageContent(saveMessageVo.getMessageContent());
        messagePO.setMessageTitle(saveMessageVo.getMessageTitle());
        messagePO.setBizType(saveMessageVo.getBizType().getBizType());
        messagePO.setBizId(saveMessageVo.getBizId());
        messagePO.setSendDate(currentDate.getTime());
        List<String> receiverIdList = saveMessageVo.getReceiverIdList();
        if (CollectionUtils.isEmpty(receiverIdList)) {
            throw new MessageParamErrorException("this param is null with receiverIdList");
        }
        messageId = this.getMessageDao().saveMessage(messagePO);
        ArrayList<MessageReceiverRelPO> messageReceiverRelPOList = new ArrayList<MessageReceiverRelPO>(receiverIdList.size());
        for (String receiverId : receiverIdList) {
            MessageReceiverRelPO messageReceiverRelPO = new MessageReceiverRelPO();
            messageReceiverRelPO.setMessageId(messageId);
            messageReceiverRelPO.setReceiverId(receiverId);
            messageReceiverRelPO.setIsRead(MessageReadFlagEnum.UNREAD.getIsRead());
            messageReceiverRelPO.setReadDate(currentDate.getTime());
            messageReceiverRelPOList.add(messageReceiverRelPO);
        }
        this.getMessageReceiverRelDao().insertList(messageReceiverRelPOList);
        if (BizTypeEnum.QUARTZ_NEWS.getBizType().equals(messagePO.getBizType()) || BizTypeEnum.AUTHORIZED_NEWS.getBizType().equals(messagePO.getBizType())) {
            this.deleteMessageByRule();
        }
        return messageId;
    }

    public void updateToHasReadByReceiverIdAndBizType(String userId, List<String> messageIdList) throws AbstractQingIntegratedException, SQLException, MessageException {
        try {
            this.tx.beginRequired();
            this.getMessageDao().updateToHasReadByReceiverIdAndBizType(userId, messageIdList);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new MessageException(e);
        }
        finally {
            this.tx.end();
        }
    }

    public MessageReceiverRelPO deleteMessage(String messageReceiverRelId, String userId) throws AbstractQingIntegratedException, SQLException, MessageDeleteNoAuthException {
        MessageReceiverRelPO messageReceiverRelPO = this.getMessageReceiverRelDao().getById(messageReceiverRelId, userId);
        if (messageReceiverRelPO == null) {
            throw new MessageDeleteNoAuthException("no auth delete this message");
        }
        try {
            MessagePO messagePO;
            this.tx.beginRequired();
            this.getMessageReceiverRelDao().deleteMessageReceiverRel(messageReceiverRelId);
            List<MessageReceiverRelPO> messageReceiverRelPOList = this.getMessageReceiverRelDao().getByMessageId(messageReceiverRelPO.getMessageId());
            if (CollectionUtils.isEmpty(messageReceiverRelPOList) && (messagePO = this.getMessageDao().getByMessageId(messageReceiverRelPO.getMessageId())) != null && MessageTypeEnum.BIZ_NEWS.getMessageType().equals(messagePO.getMessageType())) {
                this.getMessageDao().deleteById(messageReceiverRelPO.getMessageId());
            }
            MessageReceiverRelPO messageReceiverRelPO2 = messageReceiverRelPO;
            return messageReceiverRelPO2;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public void readMessage(String messageId, String messageReceiverRelId, String userId, MessageReadFlagEnum readFlagEnum) throws AbstractQingIntegratedException, SQLException {
        MessagePO messagePO = this.getMessageDao().getByMessageId(messageId);
        try {
            this.tx.beginRequired();
            if (MessageTypeEnum.BIZ_NEWS.getMessageType().equals(messagePO.getMessageType())) {
                this.getMessageReceiverRelDao().readMessage(messageReceiverRelId, readFlagEnum);
            } else {
                MessageReceiverRelPO messageReceiverRelPO = this.getMessageReceiverRelDao().getByMessageIdAndReceiverId(messageId, userId);
                if (messageReceiverRelPO == null) {
                    ArrayList<MessageReceiverRelPO> insertList = new ArrayList<MessageReceiverRelPO>();
                    MessageReceiverRelPO insertMessageReceiverRelPO = new MessageReceiverRelPO();
                    insertMessageReceiverRelPO.setIsRead(readFlagEnum.getIsRead());
                    insertMessageReceiverRelPO.setMessageId(messageId);
                    insertMessageReceiverRelPO.setReceiverId(userId);
                    insertMessageReceiverRelPO.setReadDate(new Date());
                    insertList.add(insertMessageReceiverRelPO);
                    this.getMessageReceiverRelDao().insertList(insertList);
                } else {
                    this.getMessageReceiverRelDao().readMessage(messageReceiverRelPO.getMessageReceiverRelId(), readFlagEnum);
                }
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public void clearAllMessage(String userId) throws AbstractQingIntegratedException, SQLException {
        List<MessagePO> unreadSystemMessageList = this.getMessageDao().queryUnReadSystemMessageList(userId);
        ArrayList<MessageReceiverRelPO> insertList = new ArrayList<MessageReceiverRelPO>();
        if (CollectionUtils.isNotEmpty(unreadSystemMessageList)) {
            Calendar currentDate = Calendar.getInstance();
            for (MessagePO messagePO : unreadSystemMessageList) {
                MessageReceiverRelPO messageReceiverRelPO = new MessageReceiverRelPO();
                messageReceiverRelPO.setMessageId(messagePO.getMessageId());
                messageReceiverRelPO.setReceiverId(userId);
                messageReceiverRelPO.setReadDate(currentDate.getTime());
                messageReceiverRelPO.setIsRead(MessageReadFlagEnum.READ.getIsRead());
                insertList.add(messageReceiverRelPO);
            }
        }
        try {
            this.tx.beginRequired();
            this.getMessageReceiverRelDao().clearUnReadMessage(userId);
            if (CollectionUtils.isNotEmpty(insertList)) {
                this.getMessageReceiverRelDao().insertList(insertList);
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public AbstractMessageDetailVO queryMessageDetailById(String messageId, String messageReceiverRelId, String userId) throws AbstractQingIntegratedException, SQLException {
        MessagePO messagePO = this.getMessageDao().getByMessageId(messageId);
        this.readMessage(messageId, messageReceiverRelId, userId, MessageReadFlagEnum.READ);
        IMessageDomain messageDomain = MessageDomainFactory.createMessageDomain(this.qingContext, this.dbExcuter, this.tx, messagePO.getBizType());
        return messageDomain.queryMessageDetailById(messagePO, userId);
    }

    public Date queryMinSendDate(String userId) throws AbstractQingIntegratedException, SQLException {
        return this.getMessageDao().queryMinSendDate(userId);
    }

    public List<BaseMessageDeailVO> queryUnReadMessageDetailList(String userId, String messageLevel) throws AbstractQingIntegratedException, SQLException {
        List<BaseMessageDeailVO> unReadMessageList = this.getMessageDao().queryUnReadMessageDetailList(userId, messageLevel);
        Calendar currentDate = Calendar.getInstance();
        ArrayList<BaseMessageDeailVO> resultList = new ArrayList<BaseMessageDeailVO>();
        if (CollectionUtils.isNotEmpty(unReadMessageList)) {
            ArrayList<MessageReceiverRelPO> insertMessageReceiverRelList = new ArrayList<MessageReceiverRelPO>();
            for (BaseMessageDeailVO messageDeailVo : unReadMessageList) {
                Date effectiveDate = messageDeailVo.getEffectiveDate();
                if (effectiveDate != null && effectiveDate.getTime() < System.currentTimeMillis()) continue;
                if (!MessageTypeEnum.BIZ_NEWS.getMessageType().equals(messageDeailVo.getMessageType())) {
                    MessageReceiverRelPO insertMessageReceiverRelPO = new MessageReceiverRelPO();
                    String messageReceiverId = this.dbExcuter.genStringId("T_QING_MESSAGE_RECEIVER_REL");
                    insertMessageReceiverRelPO.setMessageReceiverRelId(messageReceiverId);
                    insertMessageReceiverRelPO.setIsRead(MessageReadFlagEnum.UNREAD.getIsRead());
                    insertMessageReceiverRelPO.setMessageId(messageDeailVo.getMessageId());
                    insertMessageReceiverRelPO.setReceiverId(userId);
                    insertMessageReceiverRelPO.setReadDate(currentDate.getTime());
                    insertMessageReceiverRelList.add(insertMessageReceiverRelPO);
                    messageDeailVo.setMessageReceiverRelId(messageReceiverId);
                }
                resultList.add(messageDeailVo);
            }
            try {
                this.tx.beginRequired();
                this.getMessageReceiverRelDao().insertList(insertMessageReceiverRelList);
            }
            catch (AbstractQingIntegratedException e) {
                this.tx.markRollback();
                throw e;
            }
            catch (SQLException e) {
                this.tx.markRollback();
                throw e;
            }
            finally {
                this.tx.end();
            }
        }
        return resultList;
    }

    public List<BaseMessageDeailVO> queryMessageListByDateRange(String userId, Date startDate, Date endDate, String messageType) throws AbstractQingIntegratedException, SQLException {
        return this.getMessageDao().queryListByDateRangeAndMsgType(userId, startDate, endDate, messageType);
    }

    public int queryUnReadMessageCount(String userId, String messageLevel) throws AbstractQingIntegratedException, SQLException {
        return this.getMessageDao().queryUnReadMessageCount(userId, messageLevel);
    }

    public void syncMessageData(String accountId, String messageModelListStr) throws MessageDecryptErrorException, AbstractQingIntegratedException, SQLException {
        if (StringUtils.isEmpty((CharSequence)messageModelListStr)) {
            this.finishSync(CACHE_SYNC_KEY + accountId);
            return;
        }
        try {
            this.setStartSyncTime(accountId);
            String messageModelDecryptStr = SecretUtil.getDectryptString((String)messageModelListStr);
            List messageModelList = (List)gson.fromJson(messageModelDecryptStr, new TypeToken<List<MessageModelVO>>(){}.getType());
            if (CollectionUtils.isNotEmpty((Collection)messageModelList)) {
                this.syncMessageData(messageModelList);
            }
            this.finishSync(CACHE_SYNC_KEY + accountId);
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException throwables) {
            throw throwables;
        }
        catch (Throwable throwable) {
            LogUtil.error((String)throwable.getMessage(), (Throwable)throwable);
            throw new MessageDecryptErrorException("dectrypt error");
        }
    }

    private void setStartSyncTime(String accountId) {
        QingSessionUtil.getGlobalQingSessionImpl().set(START_SYNC_TIME_KEY + accountId, Long.toString(System.currentTimeMillis()));
    }

    private void syncMessageData(List<MessageModelVO> messageList) throws AbstractQingIntegratedException, SQLException {
        ArrayList<MessagePO> updateMessageList = new ArrayList<MessagePO>();
        ArrayList<MessagePO> insertMessageList = new ArrayList<MessagePO>();
        this.collectionMessageList(messageList, updateMessageList, insertMessageList);
        try {
            this.tx.beginRequired();
            this.getMessageDao().updateBatch(updateMessageList);
            this.getMessageDao().insertList(insertMessageList);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    private void collectionMessageList(List<MessageModelVO> messageList, List<MessagePO> updateMessageList, List<MessagePO> insertMessageList) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> sourceIdList = new ArrayList<String>(10);
        for (MessageModelVO messageModel : messageList) {
            sourceIdList.add(messageModel.getMessageId());
        }
        List<MessagePO> existMessageList = this.getMessageDao().queryByBizIds(sourceIdList);
        HashMap<String, MessagePO> existMessageMap = new HashMap<String, MessagePO>(10);
        for (MessagePO messagePO : existMessageList) {
            existMessageMap.put(messagePO.getBizId(), messagePO);
        }
        int time = 0;
        for (MessageModelVO messageModel : messageList) {
            MessagePO existMessagePo = (MessagePO)existMessageMap.get(messageModel.getMessageId());
            if (existMessagePo == null) {
                MessagePO insertMessagePO = this.createMessagePO(messageModel, null, time);
                insertMessageList.add(insertMessagePO);
                ++time;
                continue;
            }
            MessagePO updateMessagePO = this.createMessagePO(messageModel, existMessagePo, time);
            updateMessageList.add(updateMessagePO);
        }
        existMessageMap.clear();
    }

    private MessagePO createMessagePO(MessageModelVO messageModel, MessagePO existMessagePo, int time) {
        MessagePO messagePO = new MessagePO();
        if (existMessagePo == null) {
            messagePO.setMessageId(this.dbExcuter.genStringId("T_QING_MESSAGE"));
            Calendar calendar = Calendar.getInstance();
            calendar.add(14, time);
            messagePO.setSendDate(calendar.getTime());
        } else {
            messagePO.setMessageId(existMessagePo.getMessageId());
            messagePO.setSendDate(existMessagePo.getSendDate());
        }
        messagePO.setMessageTitle(messageModel.getMessageTitle());
        if (MessageLevelTypeEnum.NORMAL_LEVEL.getMessageLevel().equals(messageModel.getMessageLevel())) {
            messagePO.setMessageType(MessageTypeEnum.PUBLISH_NEWS.getMessageType());
        } else {
            messagePO.setMessageType(MessageTypeEnum.SYSTEM_NEWS.getMessageType());
        }
        messagePO.setMessageContent(messageModel.getMessageContent());
        messagePO.setMessageLevel(messageModel.getMessageLevel());
        messagePO.setBizId(messageModel.getMessageId());
        messagePO.setBizType(messageModel.getBizType());
        messagePO.setSenderId(this.qingContext.getUserId());
        Long effectiveDate = messageModel.getEffectiveDate();
        messagePO.setEffectiveDate(effectiveDate == null ? null : new Date(effectiveDate));
        return messagePO;
    }

    private void finishSync(String key) {
        Calendar currentDate = Calendar.getInstance();
        currentDate.set(11, 0);
        currentDate.set(12, 0);
        currentDate.set(13, 0);
        currentDate.add(6, 1);
        QingSessionUtil.getGlobalQingSessionImpl().set(key, Long.toString(currentDate.getTimeInMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsFinishSyncToday(String accountId, Date date) throws ParseException, QingLockRequireException, InterruptedException {
        String visitedTime = QingSessionUtil.getGlobalQingSessionImpl().get(START_SYNC_TIME_KEY + accountId);
        if (StringUtils.isNotEmpty((CharSequence)visitedTime) && System.currentTimeMillis() <= Long.parseLong(visitedTime) + 300000L) {
            return true;
        }
        ILock datacenterLock = LockFactory.createLock((String)(MESSAGE_FINISH_SYNC_LOCK_KEY + this.qingContext.getAccountId()));
        try {
            boolean isLock = datacenterLock.tryLock();
            if (!isLock) {
                boolean bl = true;
                return bl;
            }
            String dateStr = QingSessionUtil.getGlobalQingSessionImpl().get(CACHE_SYNC_KEY + accountId);
            if (StringUtils.isEmpty((CharSequence)dateStr)) {
                boolean bl = false;
                return bl;
            }
            Long currentSyncTime = Long.parseLong(dateStr);
            if (currentSyncTime < date.getTime()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            datacenterLock.unlock();
        }
    }

    public void deleteDiscardMessage() throws AbstractQingIntegratedException, SQLException {
        try {
            this.tx.beginRequired();
            List<String> invalidMessageIds = this.getMessageDao().selectInvalidEffectivedate();
            if (CollectionUtils.isNotEmpty(invalidMessageIds)) {
                this.getMessageReceiverRelDao().deleteByMessageIds(invalidMessageIds);
                this.getMessageDao().deleteByIds(invalidMessageIds);
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public void deleteMessageByRule() throws AbstractQingIntegratedException, SQLException {
        String userId = this.qingContext.getUserId();
        String dateStr = QingSessionUtil.getGlobalQingSessionImpl().get(CACHE_DELETE_BY_UER_KEY + userId);
        if (StringUtils.isNotEmpty((CharSequence)dateStr) && Long.parseLong(dateStr) > System.currentTimeMillis()) {
            return;
        }
        List<String> messageReceiverRelIdList = this.getMessageReceiverRelDao().queryAuthAndQuartz(userId);
        if (messageReceiverRelIdList.size() <= 300) {
            return;
        }
        List<String> deleteIdList = messageReceiverRelIdList.subList(300, messageReceiverRelIdList.size());
        try {
            this.tx.beginRequired();
            this.getMessageReceiverRelDao().deleteByIds(deleteIdList);
            this.finishSync(CACHE_DELETE_BY_UER_KEY + userId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public List<String> queryReceiverIdsByBizid(String bizId) throws AbstractQingIntegratedException, SQLException {
        return this.getMessageReceiverRelDao().queryReceiverIdsByBizid(bizId);
    }

    public void messageToUnread(String messageReceiverRelId) throws AbstractQingIntegratedException, SQLException {
        try {
            this.tx.beginRequired();
            this.getMessageReceiverRelDao().messageToUnreadById(messageReceiverRelId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public Map<String, List<String>> queryBizIdsByUserId(Set<String> receiverUserIdList) throws AbstractQingIntegratedException, SQLException {
        return this.getMessageDao().queryBizIdsByUserId(receiverUserIdList);
    }

    public void saveMessageListNoTx(List<SaveMessageVo> saveMessageVoList) throws AbstractQingIntegratedException, SQLException {
        String userId = this.qingContext.getUserId();
        Calendar currentDate = Calendar.getInstance();
        ArrayList<MessagePO> insertMessagePoList = new ArrayList<MessagePO>(10);
        ArrayList<MessageReceiverRelPO> insertMessageReceiverRelList = new ArrayList<MessageReceiverRelPO>(10);
        for (SaveMessageVo saveMessageVo : saveMessageVoList) {
            MessagePO messagePO = new MessagePO();
            messagePO.setMessageId(saveMessageVo.getMessageId());
            messagePO.setSenderId(userId);
            messagePO.setMessageType(saveMessageVo.getMessageType().getMessageType());
            messagePO.setMessageLevel(saveMessageVo.getMessageLevel().getMessageLevel());
            messagePO.setMessageContent(saveMessageVo.getMessageContent());
            messagePO.setMessageTitle(saveMessageVo.getMessageTitle());
            messagePO.setBizType(saveMessageVo.getBizType().getBizType());
            messagePO.setBizId(saveMessageVo.getBizId());
            messagePO.setSendDate(currentDate.getTime());
            List<String> receiverIdList = saveMessageVo.getReceiverIdList();
            ArrayList<MessageReceiverRelPO> messageReceiverRelPOList = new ArrayList<MessageReceiverRelPO>(receiverIdList.size());
            for (String receiverId : receiverIdList) {
                MessageReceiverRelPO messageReceiverRelPO = new MessageReceiverRelPO();
                messageReceiverRelPO.setMessageId(saveMessageVo.getMessageId());
                messageReceiverRelPO.setReceiverId(receiverId);
                messageReceiverRelPO.setIsRead(MessageReadFlagEnum.UNREAD.getIsRead());
                messageReceiverRelPO.setReadDate(currentDate.getTime());
                messageReceiverRelPOList.add(messageReceiverRelPO);
            }
            insertMessageReceiverRelList.addAll(messageReceiverRelPOList);
            insertMessagePoList.add(messagePO);
        }
        this.getMessageDao().insertList(insertMessagePoList);
        this.getMessageReceiverRelDao().insertList(insertMessageReceiverRelList);
        this.deleteMessageByRule();
    }
}

