/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.dao.PublishOperPermissionsDao;
import com.kingdee.bos.qing.publish.dao.PublishPermissionDao;
import com.kingdee.bos.qing.publish.domain.IPublishSourceDomain;
import com.kingdee.bos.qing.publish.domain.PublishSourceDomainFactory;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishNoOperAuthException;
import com.kingdee.bos.qing.publish.exception.PublishNoPermissionException;
import com.kingdee.bos.qing.publish.exception.PublishNotFoundException;
import com.kingdee.bos.qing.publish.exception.PublishSourcePublishNotExistException;
import com.kingdee.bos.qing.publish.model.OperCodeEnum;
import com.kingdee.bos.qing.publish.model.OperTypeEnum;
import com.kingdee.bos.qing.publish.model.PermissionInfo;
import com.kingdee.bos.qing.publish.model.PublishOperPermissionsPO;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishVO;
import com.kingdee.bos.qing.publish.model.ValueTextPair;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class CommonPublishDomain {
    public static final String SCHEMAID = "schemaId";
    public static final String SCHEMATYPE = "schemaType";
    private static final String PUBLISH_SOURCE_TYPE = "publishSourceType";
    protected ITransactionManagement tx;
    protected IDBExcuter dbExcuter;
    protected QingContext qingContext;
    private PublishInfoDao publishInfoDao;
    private PublishPermissionDao publishPermissionDao;
    private PublishOperPermissionsDao publishOperPermissionsDao;

    public CommonPublishDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter) {
        this.qingContext = qingContext;
        this.dbExcuter = dbExcuter;
        this.tx = tx;
    }

    protected PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    protected PublishPermissionDao getPublishPermissionDao() {
        if (this.publishPermissionDao == null) {
            this.publishPermissionDao = new PublishPermissionDao(this.dbExcuter);
        }
        return this.publishPermissionDao;
    }

    protected PublishOperPermissionsDao getPublishOperPermissionsDao() {
        if (this.publishOperPermissionsDao == null) {
            this.publishOperPermissionsDao = new PublishOperPermissionsDao(this.dbExcuter);
        }
        return this.publishOperPermissionsDao;
    }

    private Map<String, Boolean> checkPublishRight(PublishPO publishInfo) throws SQLException, AbstractQingIntegratedException {
        HashMap<String, Boolean> checkRtnMap = new HashMap<String, Boolean>(2);
        boolean isAnonymous = false;
        boolean hasRight = false;
        String userId = this.qingContext.getUserId();
        if (userId.equals(publishInfo.getCreatorId())) {
            hasRight = IntegratedHelper.isNormalUser(this.qingContext, this.dbExcuter, userId);
        } else if (publishInfo.isPreset() && IntegratedHelper.isCurrentUserInQingAdminRole(this.qingContext, this.dbExcuter)) {
            hasRight = true;
        } else {
            List<PermissionInfo> permissionInfos = this.getPublishPermissionDao().loadPublishPermissionInfo(publishInfo.getId());
            Set<String> userRoles = IntegratedHelper.getUserRoleIds(this.qingContext, this.dbExcuter, userId);
            for (PermissionInfo permissionInfo : permissionInfos) {
                if (permissionInfo.getType() == 2) {
                    isAnonymous = true;
                    hasRight = true;
                    break;
                }
                if (permissionInfo.getType() == 0 && permissionInfo.getViewerId().equals(userId)) {
                    hasRight = IntegratedHelper.isNormalUser(this.qingContext, this.dbExcuter, userId);
                    break;
                }
                if (!(permissionInfo.getType() == 3 && userId != null && !"-1".equals(userId) || permissionInfo.getType() == 0 && permissionInfo.getViewerId().equals(userId)) && (permissionInfo.getType() != 1 || !userRoles.contains(permissionInfo.getViewerId()))) continue;
                hasRight = true;
                break;
            }
        }
        checkRtnMap.put("hasRight", hasRight);
        checkRtnMap.put("isAnonymous", isAnonymous);
        return checkRtnMap;
    }

    public PublishPO loadPublishInfo(String publishId) throws AbstractQingIntegratedException, SQLException {
        return this.getPublishInfoDao().getPublishInfoByInfoId(publishId);
    }

    public List<PublishPO> loadPublishInfos(List<String> publishIds) throws AbstractQingIntegratedException, SQLException {
        return this.getPublishInfoDao().getPublishInfoByInfoIds(publishIds, null);
    }

    public PublishPO checkPublishExist(String infoID) throws AbstractQingIntegratedException, SQLException, PublishNotFoundException {
        PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(infoID);
        if (publishPO == null) {
            throw new PublishNotFoundException();
        }
        return publishPO;
    }

    public final Map<String, String> getRuntimePublishInfo(String publishId, boolean isCheckPermission) throws AbstractQingIntegratedException, PublishException {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            PublishPO publishPO = this.loadPublishInfo(publishId);
            if (publishPO == null) {
                throw new PublishNotFoundException();
            }
            boolean isAnonymousView = true;
            if (isCheckPermission) {
                isAnonymousView = this.checkRightAndReturnIsAnonymous(publishPO);
            }
            result.put(SCHEMAID, publishPO.getSchemaId());
            result.put("publishName", publishPO.getName());
            result.put("isAnonymousView", "" + isAnonymousView);
            result.put(PUBLISH_SOURCE_TYPE, publishPO.getPublishSourceType().name());
            result.put("publishTargetType", publishPO.getPublishTargetType() + "");
            result.put("haveToCarryData", publishPO.isCarryData() + "");
            result.put("isPreset", "" + publishPO.isPreset());
            result.put("tagId", "" + publishPO.getTagId());
            return result;
        }
        catch (SQLException ex) {
            throw new PublishException(ex);
        }
    }

    public final Map<String, String> getPublishInfoForEditSchema(String publishId) throws AbstractQingIntegratedException, PublishException {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            PublishPO publishPO = this.loadPublishInfo(publishId);
            if (publishPO == null) {
                throw new PublishNotFoundException();
            }
            if (!this.qingContext.getUserId().equals(publishPO.getCreatorId())) {
                throw new PublishNotFoundException();
            }
            boolean isAnonymousView = this.checkRightAndReturnIsAnonymous(publishPO);
            result.put(SCHEMAID, publishPO.getSchemaId());
            result.put("isAnonymousView", "" + isAnonymousView);
            result.put(PUBLISH_SOURCE_TYPE, publishPO.getPublishSourceType().name());
            result.put("publishTargetType", publishPO.getPublishTargetType() + "");
            result.put("haveToCarryData", publishPO.isCarryData() + "");
            result.put("isPreset", "" + publishPO.isPreset());
            IPublishSourceDomain publishSourceDomain = PublishSourceDomainFactory.createPublishSourceDomain(this.qingContext, this.dbExcuter, this.tx, publishPO.getPublishSourceType());
            publishSourceDomain.addPublicSchemaInfo(result);
            return result;
        }
        catch (SQLException ex) {
            throw new PublishException(ex);
        }
    }

    public final boolean checkRightAndReturnIsAnonymous(PublishPO publishInfo) throws SQLException, AbstractQingIntegratedException, PublishNoPermissionException {
        Map<String, Boolean> checkRtnMap = this.checkPublishRight(publishInfo);
        if (!checkRtnMap.get("hasRight").booleanValue()) {
            String userName = IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, publishInfo.getCreatorId());
            throw new PublishNoPermissionException(userName);
        }
        return checkRtnMap.get("isAnonymous");
    }

    public final boolean checkPublishAuthRight(PublishPO publishInfo) throws SQLException, AbstractQingIntegratedException {
        Map<String, Boolean> checkRtnMap = this.checkPublishRight(publishInfo);
        return checkRtnMap.get("hasRight");
    }

    public final boolean checkExtReportPublishAuthRight(String reportId) throws AbstractQingIntegratedException, SQLException {
        boolean hasRight = false;
        String userId = this.qingContext.getUserId();
        hasRight = this.existPublishInfo(userId, PublishSourceEnum.extreport, reportId);
        if (hasRight && IntegratedHelper.isNormalUser(this.qingContext, this.dbExcuter, userId)) {
            return hasRight;
        }
        hasRight = this.existPublishInfo(IntegratedHelper.getPresetUserId(), PublishSourceEnum.extreport, reportId);
        if (hasRight && IntegratedHelper.isCurrentUserInQingAdminRole(this.qingContext, this.dbExcuter)) {
            return hasRight;
        }
        ArrayList<String> noLimitPerm = new ArrayList<String>(2);
        noLimitPerm.add(String.valueOf(2));
        noLimitPerm.add(String.valueOf(3));
        hasRight = this.getPublishInfoDao().checkPublishPerm(PublishSourceEnum.extreport, reportId, noLimitPerm, null);
        if (hasRight && IntegratedHelper.isNormalUser(this.qingContext, this.dbExcuter, userId)) {
            return hasRight;
        }
        ArrayList<String> userAndRolePerm = new ArrayList<String>(2);
        userAndRolePerm.add(String.valueOf(0));
        userAndRolePerm.add(String.valueOf(1));
        ArrayList<String> viewerIds = new ArrayList<String>();
        viewerIds.add(userId);
        viewerIds.addAll(IntegratedHelper.getUserRoleIds(this.qingContext, this.dbExcuter, userId));
        hasRight = this.getPublishInfoDao().checkPublishPerm(PublishSourceEnum.extreport, reportId, userAndRolePerm, viewerIds);
        if (hasRight && IntegratedHelper.isNormalUser(this.qingContext, this.dbExcuter, userId)) {
            return hasRight;
        }
        return hasRight;
    }

    public List<PublishPO> loadPublishedAndAuthedExtReportPublishIdMaps() throws AbstractQingIntegratedException, SQLException {
        String currentUserId = this.qingContext.getUserId();
        HashSet<String> creatorIds = new HashSet<String>(2);
        creatorIds.add(currentUserId);
        Set<String> userRoles = IntegratedHelper.getUserRoleIds(this.qingContext, this.dbExcuter, currentUserId);
        return this.getPublishInfoDao().loadTagIdPublishIdMapsBySourceTypeAndAuth(PublishSourceEnum.extreport, currentUserId, userRoles, creatorIds);
    }

    public List<PublishPO> loadPublishInfos(String tagId, String userId) throws SQLException, AbstractQingIntegratedException {
        return this.getPublishInfoDao().loadPublishInfos(tagId, userId);
    }

    public List<PublishPO> loadAllPublishInfosWithoutPushAndLightApp(String tagId, String userId) throws SQLException, AbstractQingIntegratedException {
        return this.getPublishInfoDao().loadAllPublishInfosWithoutPushAndLightApp(tagId, userId);
    }

    public void setPublishPermissionInfo(PublishVO vo) throws AbstractQingIntegratedException, PublishException {
        try {
            List<PermissionInfo> permissionInfos = this.getPublishPermissionDao().loadPublishPermissionInfo(vo.getId());
            List<List<String>> availablePermissionId = this.getAvailablePermissionId(permissionInfos);
            this.setRoleAndUser(permissionInfos, vo, availablePermissionId);
        }
        catch (SQLException e) {
            throw new PublishException(e);
        }
    }

    public void setPublishPermissionInfo(List<? extends PublishVO> publishVOs) throws AbstractQingIntegratedException, PublishException {
        try {
            ArrayList<String> ids = new ArrayList<String>();
            if (publishVOs != null && !publishVOs.isEmpty()) {
                for (int i = 0; i < publishVOs.size(); ++i) {
                    ids.add(publishVOs.get(i).getId());
                }
            }
            Map<String, List<PermissionInfo>> map = this.getPublishPermissionDao().loadPublishPermissionInfo(ids);
            ArrayList<PermissionInfo> permissionInfos = new ArrayList<PermissionInfo>();
            for (Map.Entry<String, List<PermissionInfo>> entry : map.entrySet()) {
                permissionInfos.addAll((Collection<PermissionInfo>)entry.getValue());
            }
            List<List<String>> availablePermissionId = this.getAvailablePermissionId(permissionInfos);
            if (publishVOs != null && !publishVOs.isEmpty()) {
                for (int i = 0; i < publishVOs.size(); ++i) {
                    PublishVO vo = publishVOs.get(i);
                    List<PermissionInfo> permissionInfo = map.get(vo.getId());
                    this.setRoleAndUser(permissionInfo, vo, availablePermissionId);
                }
            }
            this.setPublishOperPermissionInfo(publishVOs);
        }
        catch (SQLException e) {
            throw new PublishException(e);
        }
    }

    public void setPublishOperPermissionInfo(List<? extends PublishVO> publishVOs) throws AbstractQingIntegratedException, PublishException {
        try {
            if (CollectionUtils.isEmpty(publishVOs)) {
                return;
            }
            ArrayList<String> ids = new ArrayList<String>(16);
            for (int i = 0; i < publishVOs.size(); ++i) {
                ids.add(publishVOs.get(i).getId());
            }
            Map<String, Map<String, Integer>> operMap = this.getPublishOperPermissionsDao().loadPublishOperPermissionInfo(ids);
            for (int i = 0; i < publishVOs.size(); ++i) {
                PublishVO vo = publishVOs.get(i);
                vo.setNoOperValueMap(operMap.get(vo.getId()));
            }
        }
        catch (SQLException e) {
            throw new PublishException(e);
        }
    }

    private List<List<String>> getAvailablePermissionId(List<PermissionInfo> permissionInfo) throws IntegratedRuntimeException {
        ArrayList<List<String>> availablePermission = new ArrayList<List<String>>(10);
        List<List<String>> roleAndUserId = CommonPublishDomain.getRoleAndUserId(permissionInfo);
        HashSet userIds = new HashSet(roleAndUserId.get(0));
        HashSet roleIds = new HashSet(roleAndUserId.get(1));
        List<String> newUserIds = IntegratedHelper.getValidUserIds(this.qingContext, this.dbExcuter, new ArrayList<String>(userIds));
        List<String> newRoleIds = IntegratedHelper.getValidRoleIds(this.qingContext, this.dbExcuter, new ArrayList<String>(roleIds));
        availablePermission.add(newUserIds);
        availablePermission.add(newRoleIds);
        return availablePermission;
    }

    private static List<List<String>> getRoleAndUserId(List<PermissionInfo> permissionInfos) {
        ArrayList<String> userIds = new ArrayList<String>(10);
        ArrayList<String> roleIds = new ArrayList<String>(10);
        for (PermissionInfo permissionInfo : permissionInfos) {
            int permType = permissionInfo.getType();
            if (permType == 0) {
                String userId = permissionInfo.getViewerId();
                userIds.add(userId);
                continue;
            }
            if (permType != 1) continue;
            String roleId = permissionInfo.getViewerId();
            roleIds.add(roleId);
        }
        ArrayList<List<String>> roleAndUser = new ArrayList<List<String>>();
        roleAndUser.add(userIds);
        roleAndUser.add(roleIds);
        return roleAndUser;
    }

    public List<PermissionInfo> createPermissionInfoByRoles(String publishId, List<String> authorizedRoleViewerIds) throws IntegratedRuntimeException {
        ArrayList<PermissionInfo> permInfos = new ArrayList<PermissionInfo>();
        if (authorizedRoleViewerIds != null) {
            for (int i = 0; i < authorizedRoleViewerIds.size(); ++i) {
                String roleViewerId = authorizedRoleViewerIds.get(i);
                String roleName = IntegratedHelper.getRoleName(this.qingContext, this.dbExcuter, roleViewerId);
                if (roleName == null) continue;
                PermissionInfo rolePermissionInfo = new PermissionInfo();
                String roleUuid = UUID.randomUUID().toString();
                rolePermissionInfo.setCreateTime(new Date());
                rolePermissionInfo.setId(roleUuid);
                rolePermissionInfo.setPublishId(publishId);
                rolePermissionInfo.setType(1);
                rolePermissionInfo.setViewerId(roleViewerId);
                permInfos.add(rolePermissionInfo);
            }
        }
        return permInfos;
    }

    public List<PermissionInfo> createPermissionInfoByUsers(String publishId, List<String> authorizedUserViewerIds) throws IntegratedRuntimeException {
        ArrayList<PermissionInfo> permInfos = new ArrayList<PermissionInfo>();
        if (authorizedUserViewerIds != null) {
            for (int j = 0; j < authorizedUserViewerIds.size(); ++j) {
                String userViewerId = authorizedUserViewerIds.get(j);
                String userName = IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, userViewerId);
                if (userName == null) continue;
                PermissionInfo userPermissionInfo = new PermissionInfo();
                String userUuid = UUID.randomUUID().toString();
                userPermissionInfo.setCreateTime(new Date());
                userPermissionInfo.setId(userUuid);
                userPermissionInfo.setPublishId(publishId);
                userPermissionInfo.setType(0);
                userPermissionInfo.setViewerId(userViewerId);
                permInfos.add(userPermissionInfo);
            }
        }
        return permInfos;
    }

    private void setRoleAndUser(List<PermissionInfo> permissionInfos, PublishVO vo, List<List<String>> availablePermissionId) throws IntegratedRuntimeException {
        int i;
        if (permissionInfos == null) {
            return;
        }
        ArrayList<ValueTextPair> users = new ArrayList<ValueTextPair>();
        ArrayList<ValueTextPair> roles = new ArrayList<ValueTextPair>();
        List<List<String>> roleAndUserId = CommonPublishDomain.getRoleAndUserId(permissionInfos);
        List<String> userIds = roleAndUserId.get(0);
        List<String> roleIds = roleAndUserId.get(1);
        List<String> newUserIds = availablePermissionId.get(0);
        List<String> newRoleIds = availablePermissionId.get(1);
        if (userIds != null && userIds.size() > 0) {
            for (i = 0; i < userIds.size(); ++i) {
                if (!newUserIds.contains(userIds.get(i))) continue;
                ValueTextPair pairUser = new ValueTextPair();
                String userId = userIds.get(i);
                pairUser.setValue(userId);
                if (vo.isPreset() || users.size() == 0) {
                    String userName = IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, userId);
                    pairUser.setText(userName);
                }
                users.add(pairUser);
            }
        }
        if (roleIds != null && roleIds.size() > 0) {
            for (i = 0; i < roleIds.size(); ++i) {
                if (!newRoleIds.contains(roleIds.get(i))) continue;
                ValueTextPair pairRole = new ValueTextPair();
                String roleId = roleIds.get(i);
                pairRole.setValue(roleId);
                if (vo.isPreset() || roles.size() == 0) {
                    String roleName = IntegratedHelper.getRoleName(this.qingContext, this.dbExcuter, roleId);
                    pairRole.setText(roleName);
                }
                roles.add(pairRole);
            }
        }
        vo.setUsers(users);
        vo.setRoles(roles);
    }

    public PublishSourceEnum confirmSourceTypeByPublishInfo(PublishPO publishPO) throws AbstractQingIntegratedException, SQLException {
        return PublishSourceDomainFactory.confirmSourceTypeByPublishInfo(this.qingContext, this.tx, this.dbExcuter, publishPO);
    }

    public Map<String, Integer> loadPublishOperList(String publishId, String dsbPublishId, boolean isContainSelf, boolean isTimedPush) throws AbstractQingIntegratedException, SQLException {
        HashMap<String, Integer> noOperAuthValueMap = new HashMap<String, Integer>(16);
        if (!(publishId != null && PublishUtil.isPublish(publishId) || dsbPublishId != null)) {
            return noOperAuthValueMap;
        }
        PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(publishId);
        if (publishPO == null && dsbPublishId == null) {
            return noOperAuthValueMap;
        }
        ArrayList<PublishOperPermissionsPO> allParentNoOperAuthValueUnion = new ArrayList<PublishOperPermissionsPO>(16);
        if (publishPO != null) {
            List<PublishOperPermissionsPO> publishOperPermissionsPOS = this.getPublishOperPermissionsDao().loadAllParentNoOperAuthValueUnion(publishPO, isContainSelf);
            if (isTimedPush) {
                this.delPublishAndTimedPushPermission(publishOperPermissionsPOS);
            }
            allParentNoOperAuthValueUnion.addAll(publishOperPermissionsPOS);
            if (isContainSelf && isTimedPush) {
                allParentNoOperAuthValueUnion.addAll(this.getPublishOperPermissionsDao().loadTimedPushPermissionInfo(publishId));
            }
        }
        if (dsbPublishId != null) {
            allParentNoOperAuthValueUnion.addAll(isTimedPush ? this.getPublishOperPermissionsDao().loadTimedPushPermissionInfo(dsbPublishId) : this.getPublishOperPermissionsDao().loadPubOperByPubId(dsbPublishId));
        }
        for (PublishOperPermissionsPO publishOperPermissionsPO : allParentNoOperAuthValueUnion) {
            if (noOperAuthValueMap.get(publishOperPermissionsPO.getType()) == null) {
                noOperAuthValueMap.put(publishOperPermissionsPO.getType(), 0);
            }
            int noOperAuthValue = (Integer)noOperAuthValueMap.get(publishOperPermissionsPO.getType());
            noOperAuthValueMap.put(publishOperPermissionsPO.getType(), noOperAuthValue | publishOperPermissionsPO.getNoOperAuthValue());
        }
        return noOperAuthValueMap;
    }

    public void delPublishAndTimedPushPermission(List<PublishOperPermissionsPO> publishOperPermissionsPOS) {
        if (publishOperPermissionsPOS.size() > 0) {
            for (int i = 0; i < publishOperPermissionsPOS.size(); ++i) {
                PublishOperPermissionsPO publishOperPermissionsPO = publishOperPermissionsPOS.get(i);
                if (!OperTypeEnum.LONGER.getOperTypeVal().equals(publishOperPermissionsPO.getType()) && !OperTypeEnum.SQUARE_LONGER.getOperTypeVal().equals(publishOperPermissionsPO.getType())) continue;
                Integer noOperAuthValue = publishOperPermissionsPO.getNoOperAuthValue();
                if (OperCodeEnum.isExistsInNoOperaAuth(noOperAuthValue, OperCodeEnum.analysis_publish)) {
                    noOperAuthValue = noOperAuthValue - OperCodeEnum.getExistsOperaAuthValue(OperCodeEnum.analysis_publish);
                }
                if (OperCodeEnum.isExistsInNoOperaAuth(noOperAuthValue, OperCodeEnum.analysis_timepush)) {
                    noOperAuthValue = noOperAuthValue - OperCodeEnum.getExistsOperaAuthValue(OperCodeEnum.analysis_timepush);
                }
                if (noOperAuthValue == 0) {
                    publishOperPermissionsPOS.remove(i);
                    continue;
                }
                publishOperPermissionsPO.setNoOperAuthValue(noOperAuthValue);
            }
        }
    }

    public Map<String, Integer> loadSelfOperByPublishId(String publishId, boolean timedPush) throws AbstractQingIntegratedException, SQLException {
        List<PublishOperPermissionsPO> selfPublishOperPOList = timedPush ? this.getPublishOperPermissionsDao().loadTimedPushPermissionInfo(publishId) : this.getPublishOperPermissionsDao().loadPubOperByPubId(publishId);
        HashMap<String, Integer> noOperAuthValueMapByType = new HashMap<String, Integer>(3);
        for (PublishOperPermissionsPO publishOperPermissionsPO : selfPublishOperPOList) {
            if (noOperAuthValueMapByType.get(publishOperPermissionsPO.getType()) == null) {
                noOperAuthValueMapByType.put(publishOperPermissionsPO.getType(), 0);
            }
            int noOperAuthValue = (Integer)noOperAuthValueMapByType.get(publishOperPermissionsPO.getType());
            noOperAuthValueMapByType.put(publishOperPermissionsPO.getType(), noOperAuthValue | publishOperPermissionsPO.getNoOperAuthValue());
        }
        return noOperAuthValueMapByType;
    }

    public void judgePublishOperAuth(String publishId, String dsbPublishId, OperCodeEnum operCodeEnum) throws AbstractQingIntegratedException, SQLException, PublishSourcePublishNotExistException, PublishNoOperAuthException {
        this.judgePublishOperAuth(publishId, dsbPublishId, operCodeEnum, true);
    }

    public void judgePublishOperAuth(String publishId, String dsbPublishId, OperCodeEnum operCodeEnum, boolean isContainSelf) throws AbstractQingIntegratedException, SQLException, PublishSourcePublishNotExistException, PublishNoOperAuthException {
        Map<String, Integer> noOperAuthMap = this.loadPublishOperList(publishId, dsbPublishId, isContainSelf, false);
        int noOperAuthValue = 0;
        for (Map.Entry<String, Integer> noOperAuthEntry : noOperAuthMap.entrySet()) {
            noOperAuthValue |= noOperAuthEntry.getValue().intValue();
        }
        if (OperCodeEnum.isExistsInNoOperaAuth(noOperAuthValue, operCodeEnum)) {
            throw new PublishNoOperAuthException();
        }
    }

    public PublishVO loadParentPublishVO(String publishId, boolean isEdit) throws AbstractQingIntegratedException, SQLException {
        PublishVO parentPublishVo = new PublishVO();
        if (StringUtils.isEmpty((CharSequence)publishId)) {
            return parentPublishVo;
        }
        PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(publishId);
        if (publishPO == null) {
            return parentPublishVo;
        }
        if (!isEdit) {
            parentPublishVo.setName(publishPO.getName());
            parentPublishVo.setCreatorName(IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, publishPO.getCreatorId()));
            return parentPublishVo;
        }
        String parentPublishIdFullPath = publishPO.getParentPublishIdFullPath();
        if (StringUtils.isEmpty((CharSequence)parentPublishIdFullPath)) {
            return parentPublishVo;
        }
        String[] parentPublishIds = parentPublishIdFullPath.split(",");
        String parentPublishId = parentPublishIds[parentPublishIds.length - 1];
        PublishPO parentPublishPO = this.getPublishInfoDao().getPublishInfoByInfoId(parentPublishId);
        if (parentPublishPO != null) {
            parentPublishVo.setName(parentPublishPO.getName());
            parentPublishVo.setCreatorName(IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, parentPublishPO.getCreatorId()));
        }
        return parentPublishVo;
    }

    public Map<String, Integer> loadUserCancelPermission(String publishId) throws AbstractQingIntegratedException, SQLException {
        return this.getPublishInfoDao().loadUserCancelPermission(publishId);
    }

    public boolean existPublishInfo(String userId, PublishSourceEnum source, String tagId) throws AbstractQingIntegratedException, SQLException {
        return this.getPublishInfoDao().existPublishInfo(userId, source, tagId);
    }
}

