/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.publishmenu.IPublishMenuStrategy;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourceVO;
import com.kingdee.bos.qing.message.domain.AbstractMessageDomain;
import com.kingdee.bos.qing.message.model.po.MessagePO;
import com.kingdee.bos.qing.message.model.vo.AbstractMessageDetailVO;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.model.PublishAuthMessageVO;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PublishAuthorizedMessageDomain
extends AbstractMessageDomain {
    private PublishInfoDao publishInfoDao;

    public PublishAuthorizedMessageDomain(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        super(qingContext, dbExcuter, tx);
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    @Override
    public AbstractMessageDetailVO queryMessageDetailById(MessagePO messagePO, String userId) throws AbstractQingIntegratedException, SQLException {
        IPublishMenuStrategy publishMenuStrategy;
        List<FileResourceVO> fileResourceVOList = this.getPublishInfoDao().findResourceFileByIds(Collections.singletonList(messagePO.getBizId()));
        ArrayList<FileResourceVO> fileResourceVOS = new ArrayList<FileResourceVO>();
        for (FileResourceVO fileResourceVO : fileResourceVOList) {
            if (!StringUtils.isNotEmpty((CharSequence)fileResourceVO.getFromId())) continue;
            fileResourceVOS.add(fileResourceVO);
        }
        if (CollectionUtils.isNotEmpty(fileResourceVOS) && null != (publishMenuStrategy = (IPublishMenuStrategy)CustomStrategyRegistrar.getStrategy(IPublishMenuStrategy.class))) {
            try {
                publishMenuStrategy.buildMenuPath(fileResourceVOS, ((FileResourceVO)fileResourceVOS.get(0)).getUserId(), this.context, this.tx, this.dbExcuter);
            }
            catch (Exception e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
        PublishAuthMessageVO publishAuthMessageVO = new PublishAuthMessageVO();
        publishAuthMessageVO.setFileResourceVO(fileResourceVOS);
        this.setBaseMessageVo(publishAuthMessageVO, messagePO, userId);
        return publishAuthMessageVO;
    }
}

