/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.analysiscenter.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.model.PublishInfoWithPersonName;
import com.kingdee.bos.qing.publish.target.analysiscenter.dao.AnalysisCenterDAO;
import com.kingdee.bos.qing.publish.target.analysiscenter.exception.AnalysisCenterException;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.AbstractQingCenterVO;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterGroupVO;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterMenuVO;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnalysisCenterRuntimeDomain
extends AbstractPublishManageDomain {
    private AnalysisCenterDAO analysisCenterDAO;

    public AnalysisCenterRuntimeDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    private AnalysisCenterDAO getAnalysisCenterDAO() {
        if (this.analysisCenterDAO == null) {
            this.analysisCenterDAO = new AnalysisCenterDAO(this.qingContext, this.dbExcuter);
        }
        return this.analysisCenterDAO;
    }

    public List<AbstractQingCenterVO> loadAnalysisCenterGroupPubished() throws AbstractQingIntegratedException, AnalysisCenterException {
        try {
            Set<String> userRoles = IntegratedHelper.getUserRoleIds(this.qingContext, this.dbExcuter);
            List<QingCenterGroupVO> centerGroups = this.getAnalysisCenterDAO().loadPublishedInfos(userRoles);
            List<AbstractQingCenterVO> centerGroupList = this.analysisPublishPathWithOrder(centerGroups);
            return centerGroupList;
        }
        catch (SQLException e) {
            throw new AnalysisCenterException(e);
        }
    }

    private AbstractQingCenterVO findTheSameGroupVo(List<AbstractQingCenterVO> groupVoList, QingCenterGroupVO currentGroupVo) {
        AbstractQingCenterVO resultGroupVo = null;
        for (AbstractQingCenterVO groupVo : groupVoList) {
            if (!this.checkGroupVoIsSame(groupVo, currentGroupVo)) continue;
            resultGroupVo = groupVo;
            return resultGroupVo;
        }
        return resultGroupVo;
    }

    private boolean checkGroupVoIsSame(AbstractQingCenterVO targetGroupVo, AbstractQingCenterVO currentGroupVo) {
        if (StringUtils.isNotBlank((CharSequence)targetGroupVo.getId()) && targetGroupVo.getId().equals(currentGroupVo.getId()) && StringUtils.isNotBlank((CharSequence)targetGroupVo.getName()) && targetGroupVo.getName().equals(currentGroupVo.getName())) {
            if (StringUtils.isNotBlank((CharSequence)targetGroupVo.getParentId()) && targetGroupVo.getParentId().equals(currentGroupVo.getParentId())) {
                return true;
            }
            if (StringUtils.isBlank((CharSequence)targetGroupVo.getParentId()) && StringUtils.isBlank((CharSequence)currentGroupVo.getParentId())) {
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> loadAnalysisCenterGroupForDsb(String sType) throws AbstractQingIntegratedException, AnalysisCenterException {
        try {
            Set<String> userRoles = IntegratedHelper.getUserRoleIds(this.qingContext, this.dbExcuter);
            List<AbstractQingCenterVO> arrCenterGroup = this.getAnalysisCenterDAO().loadPublishedInfosForDsb(userRoles, sType);
            return this.loadPublishInfo(arrCenterGroup);
        }
        catch (SQLException e) {
            throw new AnalysisCenterException(e);
        }
    }

    public Map<String, Object> loadAnalysisCenterExtreportGroup() throws AbstractQingIntegratedException, AnalysisCenterException {
        try {
            Set<String> userRoles = IntegratedHelper.getUserRoleIds(this.qingContext, this.dbExcuter);
            List<AbstractQingCenterVO> arrCenterGroup = this.getAnalysisCenterDAO().loadPublishedInfosForDsb(userRoles, "extreport");
            return this.loadPublishInfo(arrCenterGroup);
        }
        catch (SQLException e) {
            throw new AnalysisCenterException(e);
        }
    }

    public List<AbstractQingCenterVO> loadAnalysisCenterGroupExtReport() throws AbstractQingIntegratedException, AnalysisCenterException {
        try {
            Set<String> userRoles = IntegratedHelper.getUserRoleIds(this.qingContext, this.dbExcuter);
            List<AbstractQingCenterVO> arrCenterGroup = this.getAnalysisCenterDAO().loadPublishedInfosForExtReport(userRoles);
            ArrayList<QingCenterGroupVO> arrGroup = new ArrayList<QingCenterGroupVO>(arrCenterGroup.size());
            for (AbstractQingCenterVO groupVO : arrCenterGroup) {
                arrGroup.add((QingCenterGroupVO)groupVO);
            }
            List<AbstractQingCenterVO> centerGroupList = this.analysisPublishPathWithOrder(arrGroup);
            ArrayList<QingCenterMenuVO> arrCenterMenuList = new ArrayList<QingCenterMenuVO>(10);
            this.collectAllPublishInfos(centerGroupList, arrCenterMenuList);
            return centerGroupList;
        }
        catch (SQLException e) {
            throw new AnalysisCenterException(e);
        }
    }

    private Map<String, Object> loadPublishInfo(List<AbstractQingCenterVO> arrCenterGroup) throws AbstractQingIntegratedException, SQLException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String presetUserId = IntegratedHelper.getPresetUserId();
        if (arrCenterGroup != null) {
            ArrayList<QingCenterGroupVO> arrGroup = new ArrayList<QingCenterGroupVO>(arrCenterGroup.size());
            for (AbstractQingCenterVO groupVO : arrCenterGroup) {
                arrGroup.add((QingCenterGroupVO)groupVO);
            }
            List<AbstractQingCenterVO> centerGroupList = this.analysisPublishPathWithOrder(arrGroup);
            ArrayList<QingCenterMenuVO> arrCenterMenuList = new ArrayList<QingCenterMenuVO>(10);
            this.collectAllPublishInfos(centerGroupList, arrCenterMenuList);
            ArrayList<PublishInfoWithPersonName> publishInfoWithPersonNameList = new ArrayList<PublishInfoWithPersonName>(arrCenterMenuList.size());
            for (QingCenterMenuVO qingCenterMenuVO : arrCenterMenuList) {
                PublishInfoWithPersonName publishInfoWithPersonName = new PublishInfoWithPersonName();
                String userId = qingCenterMenuVO.getUserId();
                qingCenterMenuVO.setPreset(presetUserId.equals(userId));
                String publishPersonName = IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, userId);
                qingCenterMenuVO.setUserId(null);
                publishInfoWithPersonName.setQingCenterMenuVO(qingCenterMenuVO);
                publishInfoWithPersonName.setPublishPersonName(publishPersonName);
                publishInfoWithPersonNameList.add(publishInfoWithPersonName);
            }
            this.sortPublishInfoWithPersonNameListByCreateTime(publishInfoWithPersonNameList);
            result.put("qingCenterGroup", centerGroupList);
            result.put("publish", publishInfoWithPersonNameList);
        }
        return result;
    }

    private void sortPublishInfoWithPersonNameListByCreateTime(List<PublishInfoWithPersonName> publishInfoWithPersonNameList) {
        Collections.sort(publishInfoWithPersonNameList, new Comparator<PublishInfoWithPersonName>(){

            @Override
            public int compare(PublishInfoWithPersonName o1, PublishInfoWithPersonName o2) {
                Long publishTime1 = o1.getQingCenterMenuVO().getPublishTime();
                Long publishTime2 = o2.getQingCenterMenuVO().getPublishTime();
                if (publishTime1 == null && publishTime2 == null) {
                    return 0;
                }
                if (publishTime1 == null) {
                    return 1;
                }
                if (publishTime2 == null) {
                    return -1;
                }
                return publishTime2.compareTo(publishTime1);
            }
        });
    }

    private void collectAllPublishInfos(List<AbstractQingCenterVO> centerGroupList, List<QingCenterMenuVO> arrCenterMenuList) {
        if (centerGroupList != null && centerGroupList.size() > 0) {
            Iterator<AbstractQingCenterVO> iterator = centerGroupList.iterator();
            while (iterator.hasNext()) {
                AbstractQingCenterVO centerVo = iterator.next();
                if (centerVo instanceof QingCenterMenuVO) {
                    arrCenterMenuList.add((QingCenterMenuVO)centerVo);
                    iterator.remove();
                    continue;
                }
                this.collectAllPublishInfos(((QingCenterGroupVO)centerVo).getChildren(), arrCenterMenuList);
            }
        }
    }

    public void saveAnalysisCenterGroupPubishedOrder(List<String> arrCenterGroupId) throws AbstractQingIntegratedException, AnalysisCenterException {
        try {
            this.tx.beginRequired();
            this.getAnalysisCenterDAO().deleteCenterGroupPublishOrder();
            this.getAnalysisCenterDAO().saveCenterGroupPublishOrder(arrCenterGroupId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new AnalysisCenterException(e);
        }
        finally {
            this.tx.end();
        }
    }

    private List<AbstractQingCenterVO> analysisPublishPathWithOrder(List<QingCenterGroupVO> centerGroups) throws AbstractQingIntegratedException, SQLException {
        ArrayList<AbstractQingCenterVO> uniqueGroups = new ArrayList<AbstractQingCenterVO>(10);
        for (int i = 0; i < centerGroups.size(); ++i) {
            QingCenterGroupVO parentGroup = centerGroups.get(i);
            if (StringUtils.isBlank((CharSequence)parentGroup.getLevelId2())) {
                QingCenterGroupVO oSameGroup = (QingCenterGroupVO)this.findTheSameGroupVo(uniqueGroups, parentGroup);
                if (oSameGroup != null) {
                    List<AbstractQingCenterVO> sameGroupChildrens;
                    if (parentGroup.getChildren() != null && parentGroup.getChildren().size() > 0) {
                        if (oSameGroup.getChildren() == null) {
                            ArrayList<AbstractQingCenterVO> childrenGroups = new ArrayList<AbstractQingCenterVO>();
                            childrenGroups.addAll(parentGroup.getChildren());
                            oSameGroup.setChildren(childrenGroups);
                        } else {
                            oSameGroup.getChildren().addAll(parentGroup.getChildren());
                        }
                    }
                    String parentRelationId = parentGroup.getRelationId();
                    String sameGroupRelationId = oSameGroup.getRelationId();
                    boolean isModifyRelationId = false;
                    if (sameGroupRelationId == null && parentRelationId != null) {
                        oSameGroup.setRelationId(parentGroup.getRelationId());
                        isModifyRelationId = true;
                    } else if (parentRelationId != null && !parentRelationId.equals(sameGroupRelationId)) {
                        isModifyRelationId = true;
                    }
                    if (isModifyRelationId && (sameGroupChildrens = oSameGroup.getChildren()) != null && sameGroupChildrens.size() > 0) {
                        int size = sameGroupChildrens.size();
                        for (int j = 0; j < size; ++j) {
                            AbstractQingCenterVO qingCenterVO = sameGroupChildrens.get(j);
                            if (!(qingCenterVO instanceof QingCenterMenuVO)) continue;
                            qingCenterVO.setParentId(oSameGroup.getRelationId());
                        }
                    }
                    parentGroup = oSameGroup;
                } else {
                    uniqueGroups.add(parentGroup);
                }
            }
            for (int j = 0; j < centerGroups.size(); ++j) {
                QingCenterGroupVO childGroup = centerGroups.get(j);
                String centerId1 = childGroup.getLevelId1();
                String centerId2 = childGroup.getLevelId2();
                String centerId3 = childGroup.getLevelId3();
                String centerId4 = childGroup.getLevelId4();
                boolean flag = false;
                if (StringUtils.isNotBlank((CharSequence)centerId4) && centerId1.equals(parentGroup.getLevelId1()) && centerId2.equals(parentGroup.getLevelId2()) && centerId3.equals(parentGroup.getLevelId3()) && StringUtils.isBlank((CharSequence)parentGroup.getLevelId4())) {
                    flag = true;
                } else if (StringUtils.isNotBlank((CharSequence)centerId3) && centerId1.equals(parentGroup.getLevelId1()) && centerId2.equals(parentGroup.getLevelId2()) && StringUtils.isBlank((CharSequence)parentGroup.getLevelId3()) && StringUtils.isBlank((CharSequence)parentGroup.getLevelId4()) && StringUtils.isBlank((CharSequence)centerId4)) {
                    flag = true;
                } else if (StringUtils.isNotBlank((CharSequence)centerId2) && centerId1.equals(parentGroup.getLevelId1()) && StringUtils.isBlank((CharSequence)parentGroup.getLevelId2()) && StringUtils.isBlank((CharSequence)parentGroup.getLevelId3()) && StringUtils.isBlank((CharSequence)parentGroup.getLevelId4()) && StringUtils.isBlank((CharSequence)centerId3) && StringUtils.isBlank((CharSequence)centerId4)) {
                    flag = true;
                }
                if (!flag) continue;
                if (parentGroup.getChildren() != null && parentGroup.getChildren().size() > 0) {
                    this.mergeGroup(parentGroup, childGroup);
                    continue;
                }
                ArrayList<AbstractQingCenterVO> childrenGroups = new ArrayList<AbstractQingCenterVO>();
                childrenGroups.add(childGroup);
                parentGroup.setChildren(childrenGroups);
            }
        }
        Map<String, Integer> orderMap = this.getAnalysisCenterDAO().loadCenterGroupPublishOrder();
        this.orderCenterGroups(uniqueGroups, orderMap);
        return uniqueGroups;
    }

    private void orderCenterGroups(List<AbstractQingCenterVO> uniqueGroups, final Map<String, Integer> orderMap) {
        Collections.sort(uniqueGroups, new Comparator<AbstractQingCenterVO>(){

            @Override
            public int compare(AbstractQingCenterVO oCenterVO1, AbstractQingCenterVO oCenterVO2) {
                if (oCenterVO1 == null && oCenterVO2 == null) {
                    return 0;
                }
                if (oCenterVO1 == null) {
                    return 1;
                }
                if (oCenterVO2 == null) {
                    return -1;
                }
                if (oCenterVO1 instanceof QingCenterGroupVO && oCenterVO2 instanceof QingCenterMenuVO) {
                    return -1;
                }
                if (oCenterVO1 instanceof QingCenterMenuVO && oCenterVO2 instanceof QingCenterGroupVO) {
                    return 1;
                }
                if (oCenterVO1 instanceof QingCenterGroupVO && oCenterVO2 instanceof QingCenterGroupVO || oCenterVO1 instanceof QingCenterMenuVO && oCenterVO2 instanceof QingCenterMenuVO) {
                    Integer oCenterVO1Order = (Integer)orderMap.get(oCenterVO1.getOrderPath());
                    Integer oCenterVO2Order = (Integer)orderMap.get(oCenterVO2.getOrderPath());
                    if (oCenterVO1Order == null && oCenterVO2Order == null) {
                        if (oCenterVO1.isPreset() && !oCenterVO2.isPreset()) {
                            return -1;
                        }
                        if (!oCenterVO1.isPreset() && oCenterVO2.isPreset()) {
                            return 1;
                        }
                        return 0;
                    }
                    if (oCenterVO1Order == null) {
                        return 1;
                    }
                    if (oCenterVO2Order == null) {
                        return -1;
                    }
                    return -oCenterVO1Order.compareTo(oCenterVO2Order);
                }
                return 0;
            }
        });
        for (AbstractQingCenterVO child : uniqueGroups) {
            QingCenterGroupVO childGroup;
            if (!(child instanceof QingCenterGroupVO) || (childGroup = (QingCenterGroupVO)child).getChildren() == null || childGroup.getChildren().size() <= 0) continue;
            this.orderCenterGroups(childGroup.getChildren(), orderMap);
        }
    }

    private QingCenterGroupVO mergeGroup(QingCenterGroupVO oParentGroup, QingCenterGroupVO oCurrentGroup) {
        List<AbstractQingCenterVO> childrens = oParentGroup.getChildren();
        ArrayList<AbstractQingCenterVO> arrChildren = new ArrayList<AbstractQingCenterVO>();
        for (AbstractQingCenterVO child : childrens) {
            if (!(child instanceof QingCenterGroupVO)) continue;
            arrChildren.add((QingCenterGroupVO)child);
            if (child.getRelationId() != null) continue;
            child.setRelationId(oCurrentGroup.getRelationId());
        }
        QingCenterGroupVO oSameGroupVO = (QingCenterGroupVO)this.findTheSameGroupVo(arrChildren, oCurrentGroup);
        if (oSameGroupVO != null) {
            List<AbstractQingCenterVO> currentChildrenList = oCurrentGroup.getChildren();
            if (oSameGroupVO.getChildren() != null) {
                if (currentChildrenList != null && currentChildrenList.size() > 0) {
                    int len = currentChildrenList.size();
                    for (int k = 0; k < len; ++k) {
                        AbstractQingCenterVO centerVo = currentChildrenList.get(k);
                        if (centerVo instanceof QingCenterGroupVO) {
                            this.mergeGroup(oSameGroupVO, (QingCenterGroupVO)centerVo);
                            continue;
                        }
                        boolean needAddMenu = true;
                        for (AbstractQingCenterVO oSameMenu : oSameGroupVO.getChildren()) {
                            if (!oSameMenu.getId().equals(centerVo.getId())) continue;
                            needAddMenu = false;
                        }
                        if (!needAddMenu) continue;
                        centerVo.setParentId(oSameGroupVO.getRelationId());
                        oSameGroupVO.getChildren().add(centerVo);
                    }
                }
            } else if (currentChildrenList != null && currentChildrenList.size() > 0) {
                ArrayList<AbstractQingCenterVO> arrChildVO = new ArrayList<AbstractQingCenterVO>();
                arrChildVO.addAll(currentChildrenList);
                oSameGroupVO.setChildren(arrChildVO);
                int len = currentChildrenList.size();
                for (int k = 0; k < len; ++k) {
                    AbstractQingCenterVO centerVo = currentChildrenList.get(k);
                    if (!(centerVo instanceof QingCenterMenuVO)) continue;
                    centerVo.setParentId(oSameGroupVO.getRelationId());
                }
            }
        } else if (oParentGroup.getChildren() == null) {
            ArrayList<AbstractQingCenterVO> arrChildVO = new ArrayList<AbstractQingCenterVO>();
            arrChildVO.add(oCurrentGroup);
            oParentGroup.setChildren(arrChildVO);
        } else {
            oParentGroup.getChildren().add(oCurrentGroup);
        }
        return oParentGroup;
    }
}

