/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.card.dao;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishVO;
import com.kingdee.bos.qing.publish.target.card.model.CardGroupPO;
import com.kingdee.bos.qing.publish.target.card.model.CardGroupVO;
import com.kingdee.bos.qing.publish.target.card.model.CardPO;
import com.kingdee.bos.qing.publish.target.card.model.CardVO;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.MapUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class PublishCardDao {
    private IDBExcuter dbExcuter;

    public PublishCardDao(QingContext qingContext, IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void saveCardPublishInfo(CardPO po) throws SQLException, AbstractQingIntegratedException {
        String sql = "INSERT INTO T_QING_PUBLISH_CARDINFO (FID, FPUBLISHID, FIMAGEPATH, FCARDDESC) VALUES (?,?,?,?)";
        Object[] params = new Object[4];
        int i = 0;
        params[i++] = UUID.randomUUID().toString();
        params[i++] = po.getId();
        params[i++] = po.getImagePath();
        params[i++] = po.getCardDesc();
        this.dbExcuter.execute(sql, params);
    }

    public void updateCardInfo(CardPO po) throws SQLException, AbstractQingIntegratedException {
        String sql = "UPDATE T_QING_PUBLISH_CARDINFO SET FIMAGEPATH=?, FCARDDESC=? WHERE FPUBLISHID= ?";
        Object[] params = new Object[]{po.getImagePath(), po.getCardDesc(), po.getId()};
        this.dbExcuter.execute(sql, params);
    }

    public void updateCardDesc(String desc, String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_PUBLISH_CARDINFO SET FCARDDESC=? WHERE FPUBLISHID= ?";
        Object[] params = new Object[]{desc, publishId};
        this.dbExcuter.execute(sql, params);
    }

    public void deletePublishInfo(String publishId) throws SQLException, AbstractQingIntegratedException {
        String sql = "DELETE FROM T_QING_PUBLISH_CARDINFO WHERE FPUBLISHID=?";
        Object[] params = new Object[]{publishId};
        this.dbExcuter.execute(sql, params);
    }

    public CardVO loadPublishCardBaseInfo(String publishId) throws SQLException, AbstractQingIntegratedException {
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("SELECT P.FID, P.FNAME, P.FSCHEMAID, C.FID AS CARDID, C.FCARDDESC, C.FIMAGEPATH").append(" FROM T_QING_PUBLISH_CARDINFO C").append(" LEFT JOIN T_QING_PUBLISH P ON C.FPUBLISHID = P.FID").append(" WHERE C.FPUBLISHID=?");
        Object[] params = new Object[]{publishId};
        CardVO cardVO = (CardVO)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new ResultHandler<CardVO>(){

            public CardVO handle(ResultSet rs) throws SQLException {
                CardVO cardVO = null;
                if (rs.next()) {
                    cardVO = new CardVO();
                    cardVO.setId(rs.getString("FID"));
                    cardVO.setName(rs.getString("FNAME"));
                    cardVO.setCardDesc(rs.getString("FCARDDESC"));
                    cardVO.setImagePath(rs.getString("FIMAGEPATH"));
                    cardVO.setCardInfoId(rs.getString("CARDID"));
                    cardVO.setSchemaId(rs.getString("FSCHEMAID"));
                }
                return cardVO;
            }
        });
        return cardVO;
    }

    public CardVO loadPublishCardInfo(String userId, String publishId, final QingContext qingContext) throws SQLException, AbstractQingIntegratedException {
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("SELECT P.FID, P.FTYPE, P.FSOURCE, P.FNAME, P.FPATH, P.FCARRYDATA, P.FCREATETIME, P.FUPDATETIME, CG.FNAME AS PATHTEXT, C.FID AS CARDID, C.FCARDDESC, C.FIMAGEPATH,").append(" P.FSCHEMAID, P.FANALYSIS, P.FTAGID, THEME.FNAME AS THEMENAME, P.FCREATORID").append(" FROM T_QING_PUBLISH P").append(" LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID").append(" LEFT JOIN T_QING_PUBLISH_CARDINFO C ON C.FPUBLISHID = P.FID").append(" LEFT JOIN T_QING_PUBLISH_GROUP CG ON CG.FID = P.FPATH").append(" WHERE P.FTYPE=? AND P.FCREATORID=? AND P.FID= ?").append(" ORDER BY P.FCREATETIME");
        Object[] params = new Object[]{5, userId, publishId};
        return (CardVO)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new ResultHandler<CardVO>(){

            public CardVO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return PublishCardDao.this.readCardVoFromDB(null, null, rs, qingContext);
                }
                return null;
            }
        });
    }

    public List<CardGroupVO> loadOtherSharedCardGroup(Set<String> ownerId, String userId, Set<String> roleIds, boolean showDSBCard) throws AbstractQingIntegratedException, SQLException {
        String sqlInQuestion = "null";
        if (roleIds != null && roleIds.size() > 0) {
            StringBuilder sqlInQuestionBuilder = new StringBuilder();
            sqlInQuestionBuilder.append("?");
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestionBuilder.append(",?");
            }
            sqlInQuestion = sqlInQuestionBuilder.toString();
        }
        String ownerIdSqlInQuestion = "null";
        if (ownerId != null && ownerId.size() > 0) {
            StringBuilder ownerIdSqlInQuestionBuilder = new StringBuilder();
            ownerIdSqlInQuestionBuilder.append("?");
            for (int i = 1; i < ownerId.size(); ++i) {
                ownerIdSqlInQuestionBuilder.append(",?");
            }
            ownerIdSqlInQuestion = ownerIdSqlInQuestionBuilder.toString();
        }
        String excludeDSBCard = "";
        if (!showDSBCard) {
            excludeDSBCard = " (PUB.FSOURCE = 'subject' or PUB.FSOURCE = 'bill') AND ";
        }
        String sql = "SELECT  CG.FID,  CG.FNAME FROM T_QING_PUBLISH PUB  LEFT JOIN T_QING_PUBLISH_CARDINFO CARDINFO ON CARDINFO.FPUBLISHID = PUB.FID LEFT JOIN T_QING_THEME THEME ON THEME.FID = PUB.FTAGID LEFT JOIN T_QING_PUBLISH_GROUP CG ON CG.FID = PUB.FPATH WHERE" + excludeDSBCard + " PUB.FID IN ( SELECT PUB.FID FROM T_QING_PERMPUBLISH PERM  LEFT JOIN T_QING_PUBLISH PUB ON PERM.FPUBLISHID=PUB.FID  WHERE PERM.FVIEWERID=? AND PERM.FTYPE='0' AND PUB.FTYPE='5' AND PUB.FCREATORID IN (" + ownerIdSqlInQuestion + " )) OR PUB.FID IN ( SELECT PUB.FID FROM T_QING_PERMPUBLISH PERM  LEFT JOIN T_QING_PUBLISH PUB ON PERM.FPUBLISHID=PUB.FID  WHERE PERM.FVIEWERID IN (" + sqlInQuestion + ") AND PERM.FTYPE='1' AND PUB.FTYPE='5'  AND PUB.FCREATORID IN (" + ownerIdSqlInQuestion + ")) ORDER BY PUB.FCREATETIME DESC ";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        if (CollectionUtils.isNotEmpty(ownerId)) {
            queryValue.addAll(ownerId);
        }
        if (CollectionUtils.isNotEmpty(roleIds)) {
            queryValue.addAll(roleIds);
        }
        if (CollectionUtils.isNotEmpty(ownerId)) {
            queryValue.addAll(ownerId);
        }
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<List<CardGroupVO>>(){

            public List<CardGroupVO> handle(ResultSet rs) throws SQLException {
                ArrayList<CardGroupVO> groups = new ArrayList<CardGroupVO>();
                while (rs.next()) {
                    CardGroupVO po = new CardGroupVO();
                    po.setId(rs.getString("FID"));
                    po.setName(rs.getString("FNAME"));
                    groups.add(po);
                }
                return groups;
            }
        });
    }

    public Set<String> loadOtherOnesCardOwnersId(String userId, Set<String> roleIds, boolean isCurrentUserInQingAdminRole, boolean showDSBCard) throws AbstractQingIntegratedException, SQLException {
        String sqlInQuestion = "null";
        if (roleIds != null && roleIds.size() > 0) {
            StringBuilder sqlInQuestionBuilder = new StringBuilder();
            sqlInQuestionBuilder.append("?");
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestionBuilder.append(",?");
            }
            sqlInQuestion = sqlInQuestionBuilder.toString();
        }
        ArrayList<String> queryValue = new ArrayList<String>(10);
        String excludeUsersString = "";
        if (isCurrentUserInQingAdminRole) {
            excludeUsersString = " PUB.FCREATORID <> ? AND PUB.FCREATORID <> ?";
            queryValue.add(userId);
            queryValue.add(userId);
            queryValue.add(IntegratedHelper.getPresetUserId());
            if (roleIds != null) {
                queryValue.addAll(roleIds);
            }
            queryValue.add(userId);
            queryValue.add(IntegratedHelper.getPresetUserId());
        } else {
            excludeUsersString = " PUB.FCREATORID <> ?";
            queryValue.add(userId);
            queryValue.add(userId);
            if (roleIds != null) {
                queryValue.addAll(roleIds);
            }
            queryValue.add(userId);
        }
        String excludeDSBCard = "";
        if (!showDSBCard) {
            excludeDSBCard = " AND (PUB.FSOURCE = 'subject' or PUB.FSOURCE = 'bill') ";
        }
        StringBuilder sqlSB = new StringBuilder();
        sqlSB.append("SELECT PUB.FCREATORID FROM T_QING_PERMPUBLISH PERM ");
        sqlSB.append(" LEFT JOIN T_QING_PUBLISH PUB ON PERM.FPUBLISHID=PUB.FID ");
        sqlSB.append(" WHERE PERM.FVIEWERID=? AND PERM.FTYPE='0' AND PUB.FTYPE='5' AND ");
        sqlSB.append(excludeUsersString);
        sqlSB.append(excludeDSBCard);
        sqlSB.append(" UNION ");
        sqlSB.append(" SELECT PUB.FCREATORID FROM T_QING_PERMPUBLISH PERM ");
        sqlSB.append(" LEFT JOIN T_QING_PUBLISH PUB ON PERM.FPUBLISHID=PUB.FID ");
        sqlSB.append(" WHERE PERM.FVIEWERID IN(");
        sqlSB.append(sqlInQuestion);
        sqlSB.append(") AND PERM.FTYPE='1' AND PUB.FTYPE='5' AND ");
        sqlSB.append(excludeUsersString);
        sqlSB.append(excludeDSBCard);
        String sql = sqlSB.toString();
        return (Set)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                HashSet<String> ownersId = new HashSet<String>(16);
                while (rs.next()) {
                    ownersId.add(rs.getString("FCREATORID"));
                }
                return ownersId;
            }
        });
    }

    public List<CardVO> loadOtherShareCardBaseInfo(final String ownerId, String userId, Set<String> roleIds, final QingContext qingContext) throws AbstractQingIntegratedException, SQLException {
        String sqlInQuestion = "null";
        if (roleIds != null && roleIds.size() > 0) {
            StringBuilder sqlInQuestionBuilder = new StringBuilder();
            sqlInQuestionBuilder.append("?");
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestionBuilder.append(",?");
            }
            sqlInQuestion = sqlInQuestionBuilder.toString();
        }
        String sql = "SELECT  PUB.FID,  PUB.FNAME,  PUB.FSCHEMAID,  PUB.FCARRYDATA,  PUB.FTYPE,  PUB.FSOURCE,  PUB.FTAGID,  PUB.FCREATETIME,  PUB.FUPDATETIME,  THEME.FNAME AS THEMENAME,  CARDINFO.FID AS CARDID,  CARDINFO.FCARDDESC,  CARDINFO.FIMAGEPATH  FROM T_QING_PUBLISH PUB  LEFT JOIN T_QING_PUBLISH_CARDINFO CARDINFO ON CARDINFO.FPUBLISHID = PUB.FID LEFT JOIN T_QING_THEME THEME ON THEME.FID = PUB.FTAGID WHERE PUB.FID IN ( SELECT PUB.FID FROM T_QING_PERMPUBLISH PERM  LEFT JOIN T_QING_PUBLISH PUB ON PERM.FPUBLISHID=PUB.FID  WHERE PERM.FVIEWERID=? AND PERM.FTYPE='0' AND PUB.FTYPE='5' AND PUB.FCREATORID = ? ) OR PUB.FID IN ( SELECT PUB.FID FROM T_QING_PERMPUBLISH PERM  LEFT JOIN T_QING_PUBLISH PUB ON PERM.FPUBLISHID=PUB.FID  WHERE PERM.FVIEWERID IN(" + sqlInQuestion + ") AND PERM.FTYPE='1' AND PUB.FTYPE='5'  AND PUB.FCREATORID = ?) ORDER BY PUB.FCREATETIME DESC ";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        queryValue.add(ownerId);
        if (roleIds != null && !CollectionUtils.isEmpty(roleIds)) {
            queryValue.addAll(roleIds);
        }
        queryValue.add(ownerId);
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<List<CardVO>>(){

            public List<CardVO> handle(ResultSet rs) throws SQLException {
                ArrayList<CardVO> cardVOs = new ArrayList<CardVO>(10);
                while (rs.next()) {
                    CardVO cardVO = new CardVO();
                    cardVO.setId(rs.getString("FID"));
                    cardVO.setName(rs.getString("FNAME"));
                    cardVO.setCardDesc(rs.getString("FCARDDESC"));
                    cardVO.setImagePath(rs.getString("FIMAGEPATH"));
                    cardVO.setCardInfoId(rs.getString("CARDID"));
                    cardVO.setSchemaId(rs.getString("FSCHEMAID"));
                    cardVO.setCreateTime(rs.getTimestamp("FCREATETIME").getTime());
                    cardVO.setUpdateTime(rs.getTimestamp("FUPDATETIME").getTime());
                    cardVO.setPath(ownerId);
                    String publishSourceType = rs.getString("FSOURCE");
                    if (PublishSourceEnum.bill.name().equals(publishSourceType) || PublishSourceEnum.report.name().equals(publishSourceType)) {
                        try {
                            cardVO.setPublishSourceName(IntegratedHelper.queryFormDisplayName(rs.getString("FTAGID"), publishSourceType, qingContext, PublishCardDao.this.dbExcuter));
                        }
                        catch (IntegratedRuntimeException e) {
                            throw new SQLException(e);
                        }
                    } else {
                        cardVO.setPublishSourceName(rs.getString("THEMENAME"));
                    }
                    cardVO.setPublishSourceType(publishSourceType);
                    cardVO.setCarryData(rs.getBoolean("FCARRYDATA"));
                    cardVOs.add(cardVO);
                }
                return cardVOs;
            }
        });
    }

    public List<CardVO> loadAllSelectorPublishInfos(Set<String> ownerId, String userId, Set<String> roleIds, Boolean isCurrentUserInQingAdminRole, final QingContext qingContext) throws AbstractQingIntegratedException, SQLException {
        final String presetUserId = IntegratedHelper.getPresetUserId();
        String sqlInQuestion = "null";
        if (roleIds != null && roleIds.size() > 0) {
            StringBuilder sqlInQuestionBuilder = new StringBuilder();
            sqlInQuestionBuilder.append("?");
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestionBuilder.append(",?");
            }
            sqlInQuestion = sqlInQuestionBuilder.toString();
        }
        String ownerIdSqlInQuestion = "null";
        if (ownerId != null && ownerId.size() > 0) {
            StringBuilder ownerIdSqlInQuestionBuilder = new StringBuilder();
            ownerIdSqlInQuestionBuilder.append("?");
            for (int i = 1; i < ownerId.size(); ++i) {
                ownerIdSqlInQuestionBuilder.append(",?");
            }
            ownerIdSqlInQuestion = ownerIdSqlInQuestionBuilder.toString();
        }
        StringBuilder sqlInQuestionBuilder = new StringBuilder();
        sqlInQuestionBuilder.append("?");
        if (isCurrentUserInQingAdminRole.booleanValue()) {
            sqlInQuestionBuilder.append(",?");
        }
        String sql = "SELECT  PUB.FID,  PUB.FNAME,  PUB.FPATH,  CG.FNAME as PATHTEXT,  PUB.FSCHEMAID,  PUB.FCARRYDATA,  PUB.FTYPE,  PUB.FSOURCE,  PUB.FTAGID,  PUB.FCREATORID,  PUB.FCREATETIME,  PUB.FUPDATETIME,  THEME.FNAME AS THEMENAME,  CARDINFO.FID AS CARDID,  CARDINFO.FCARDDESC,  CARDINFO.FIMAGEPATH  FROM T_QING_PUBLISH PUB  LEFT JOIN T_QING_PUBLISH_CARDINFO CARDINFO ON CARDINFO.FPUBLISHID = PUB.FID LEFT JOIN T_QING_THEME THEME ON THEME.FID = PUB.FTAGID LEFT JOIN T_QING_PUBLISH_GROUP CG ON CG.FID = PUB.FPATH WHERE  PUB.FID IN ( SELECT PUB.FID FROM T_QING_PERMPUBLISH PERM    LEFT JOIN T_QING_PUBLISH PUB ON PERM.FPUBLISHID=PUB.FID    WHERE PERM.FVIEWERID=? AND PERM.FTYPE='0' AND PUB.FTYPE='5' AND PUB.FCREATORID IN (" + ownerIdSqlInQuestion + " ))  OR PUB.FID IN ( SELECT PUB.FID FROM T_QING_PERMPUBLISH PERM    LEFT JOIN T_QING_PUBLISH PUB ON PERM.FPUBLISHID=PUB.FID    WHERE PERM.FVIEWERID IN (" + sqlInQuestion + ") AND PERM.FTYPE='1' AND PUB.FTYPE='5'    AND PUB.FCREATORID IN (" + ownerIdSqlInQuestion + ")) OR (PUB.FCREATORID in (" + sqlInQuestionBuilder + ") AND PUB.FTYPE = '5') ORDER BY PUB.FCREATETIME DESC ";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        if (CollectionUtils.isNotEmpty(ownerId)) {
            queryValue.addAll(ownerId);
        }
        if (CollectionUtils.isNotEmpty(roleIds)) {
            queryValue.addAll(roleIds);
        }
        if (CollectionUtils.isNotEmpty(ownerId)) {
            queryValue.addAll(ownerId);
        }
        queryValue.add(userId);
        if (isCurrentUserInQingAdminRole.booleanValue()) {
            queryValue.add(presetUserId);
        }
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<List<CardVO>>(){

            public List<CardVO> handle(ResultSet rs) throws SQLException {
                ArrayList<CardVO> cardVOs = new ArrayList<CardVO>(10);
                while (rs.next()) {
                    CardVO cardVO = new CardVO();
                    cardVO.setId(rs.getString("FID"));
                    cardVO.setName(rs.getString("FNAME"));
                    cardVO.setPath(rs.getString("FPATH"));
                    cardVO.setPathText(rs.getString("PATHTEXT"));
                    cardVO.setCardDesc(rs.getString("FCARDDESC"));
                    cardVO.setImagePath(rs.getString("FIMAGEPATH"));
                    cardVO.setCardInfoId(rs.getString("CARDID"));
                    cardVO.setSchemaId(rs.getString("FSCHEMAID"));
                    cardVO.setCreatorId(rs.getString("FCREATORID"));
                    cardVO.setCreateTime(rs.getTimestamp("FCREATETIME").getTime());
                    cardVO.setUpdateTime(rs.getTimestamp("FUPDATETIME").getTime());
                    String publishSourceType = rs.getString("FSOURCE");
                    if (PublishSourceEnum.bill.name().equals(publishSourceType) || PublishSourceEnum.report.name().equals(publishSourceType)) {
                        try {
                            cardVO.setPublishSourceName(IntegratedHelper.queryFormDisplayName(rs.getString("FTAGID"), publishSourceType, qingContext, PublishCardDao.this.dbExcuter));
                        }
                        catch (IntegratedRuntimeException e) {
                            throw new SQLException(e);
                        }
                    } else {
                        cardVO.setPublishSourceName(rs.getString("THEMENAME"));
                    }
                    cardVO.setPublishSourceType(publishSourceType);
                    cardVO.setCarryData(rs.getBoolean("FCARRYDATA"));
                    cardVO.setPreset(presetUserId.equals(rs.getString("FCREATORID")));
                    cardVOs.add(cardVO);
                }
                return cardVOs;
            }
        });
    }

    private CardVO readCardVoFromDB(CardVO vo, List<CardVO> listVO, ResultSet rs, QingContext qingContext) throws SQLException {
        String fid = rs.getString("FID");
        if (vo == null || !fid.equals(vo.getId())) {
            vo = new CardVO();
            vo.setId(fid);
            vo.setPublishTargetType(rs.getInt("FTYPE"));
            vo.setName(rs.getString("FNAME"));
            vo.setPath(rs.getString("FPATH"));
            vo.setPathText(rs.getString("PATHTEXT"));
            vo.setSchemaId(rs.getString("FSCHEMAID"));
            vo.setCanAnalysis(rs.getBoolean("FANALYSIS"));
            vo.setCarryData(rs.getBoolean("FCARRYDATA"));
            vo.setCreateTime(rs.getTimestamp("FCREATETIME").getTime());
            vo.setUpdateTime(rs.getTimestamp("FUPDATETIME").getTime());
            String publishSourceType = rs.getString("FSOURCE");
            if (PublishSourceEnum.bill.name().equals(publishSourceType) || PublishSourceEnum.report.name().equals(publishSourceType)) {
                try {
                    vo.setPublishSourceName(IntegratedHelper.queryFormDisplayName(rs.getString("FTAGID"), publishSourceType, qingContext, this.dbExcuter));
                }
                catch (IntegratedRuntimeException e) {
                    throw new SQLException(e);
                }
            } else {
                vo.setPublishSourceName(rs.getString("THEMENAME"));
            }
            vo.setPublishSourceType(publishSourceType);
            vo.setTagId(rs.getString("FTAGID"));
            vo.setCardInfoId(rs.getString("CARDID"));
            vo.setCardDesc(rs.getString("FCARDDESC"));
            vo.setImagePath(rs.getString("FIMAGEPATH"));
            vo.setCreatorId(rs.getString("FCREATORID"));
            vo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FCREATORID")));
            if (listVO != null) {
                listVO.add(vo);
            }
        }
        return vo;
    }

    public List<CardVO> loadPublishInfos(String userId, String path, final QingContext qingContext) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("SELECT P.FID, P.FTYPE, P.FSOURCE, P.FNAME, P.FPATH, CG.FNAME AS PATHTEXT, C.FID AS CARDID, C.FCARDDESC, C.FIMAGEPATH, P.FCREATETIME, P.FUPDATETIME, ").append(" P.FSCHEMAID, P.FANALYSIS, P.FTAGID, P.FCARRYDATA, THEME.FNAME AS THEMENAME, P.FCREATORID").append(" FROM T_QING_PUBLISH P").append(" LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID").append(" LEFT JOIN T_QING_PUBLISH_CARDINFO C ON C.FPUBLISHID = P.FID").append(" LEFT JOIN T_QING_PUBLISH_GROUP CG ON CG.FID = P.FPATH").append(" WHERE P.FTYPE=? AND P.FCREATORID=? AND P.FPATH= ?").append(" ORDER BY P.FCREATETIME DESC");
        Object[] params = new Object[]{5, userId, path};
        List listVO = (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new ResultHandler<List<CardVO>>(){

            public List<CardVO> handle(ResultSet rs) throws SQLException {
                ArrayList<CardVO> listVO = new ArrayList<CardVO>();
                CardVO vo = null;
                while (rs.next()) {
                    for (CardVO existVO : listVO) {
                        if (!rs.getString("FID").equals(existVO.getId())) continue;
                        vo = existVO;
                        break;
                    }
                    PublishCardDao.this.readCardVoFromDB(vo, listVO, rs, qingContext);
                }
                return listVO;
            }
        });
        return listVO;
    }

    public List<CardVO> loadAllPublishInfos(String userId, final QingContext qingContext, boolean isPresetPublish) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> queryValue = new ArrayList<String>(10);
        queryValue.add(userId);
        String sqlInQuestionBuilder = "?";
        final String presetUserId = IntegratedHelper.getPresetUserId();
        boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole(qingContext, this.dbExcuter);
        if (isCurrentUserInQingAdminRole && isPresetPublish) {
            queryValue.add(presetUserId);
            sqlInQuestionBuilder = sqlInQuestionBuilder + ",?";
        }
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("SELECT P.FID, P.FTYPE, P.FSOURCE, P.FNAME, P.FPATH, PUBG.FNAME AS PATHTEXT, C.FID AS CARDID, C.FCARDDESC, C.FIMAGEPATH, ").append(" P.FCREATETIME, P.FUPDATETIME, P.FSCHEMAID, P.FANALYSIS, P.FTAGID, P.FCARRYDATA, THEME.FNAME AS THEMENAME, TQTG.FNAME AS THEMEGROUPNAME, P.FCREATORID").append(" FROM (SELECT P1.FID, P1.FTYPE, P1.FSOURCE, P1.FNAME, P1.FPATH, P1.FCREATETIME,").append(" P1.FUPDATETIME, P1.FSCHEMAID, P1.FANALYSIS, P1.FTAGID, P1.FCARRYDATA, P1.FCREATORID").append(" FROM T_QING_PUBLISH P1 WHERE P1.FTYPE='5' AND P1.FCREATORID in (").append(sqlInQuestionBuilder).append(" )) P ").append(" LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID").append(" LEFT JOIN T_QING_THEME_GROUP TQTG ON TQTG.FID = THEME.FTHEMEGROUPID").append(" LEFT JOIN T_QING_PUBLISH_CARDINFO C ON C.FPUBLISHID = P.FID").append(" LEFT JOIN T_QING_PUBLISH_GROUP PUBG ON PUBG.FID = P.FPATH").append(" ORDER BY P.FCREATETIME DESC");
        List listVO = (List)this.dbExcuter.query(sqlSelect.toString(), queryValue.toArray(), (ResultHandler)new ResultHandler<List<CardVO>>(){

            public List<CardVO> handle(ResultSet rs) throws SQLException {
                ArrayList<CardVO> listVO = new ArrayList<CardVO>(40);
                HashMap publishSourceGroupIdMap = new HashMap(16);
                while (rs.next()) {
                    CardVO cardVO = new CardVO();
                    cardVO.setId(rs.getString("FID"));
                    cardVO.setPublishTargetType(rs.getInt("FTYPE"));
                    cardVO.setName(rs.getString("FNAME"));
                    cardVO.setPath(rs.getString("FPATH"));
                    cardVO.setTagId(rs.getString("FTAGID"));
                    cardVO.setPathText(rs.getString("PATHTEXT"));
                    cardVO.setCardDesc(rs.getString("FCARDDESC"));
                    cardVO.setImagePath(rs.getString("FIMAGEPATH"));
                    cardVO.setCardInfoId(rs.getString("CARDID"));
                    cardVO.setSchemaId(rs.getString("FSCHEMAID"));
                    cardVO.setCreatorId(rs.getString("FCREATORID"));
                    cardVO.setCreateTime(rs.getTimestamp("FCREATETIME").getTime());
                    cardVO.setUpdateTime(rs.getTimestamp("FUPDATETIME").getTime());
                    String publishSourceType = rs.getString("FSOURCE");
                    if (PublishSourceEnum.bill.name().equals(publishSourceType) || PublishSourceEnum.report.name().equals(publishSourceType) || PublishSourceEnum.control.name().equals(publishSourceType)) {
                        try {
                            cardVO.setPublishSourceName(IntegratedHelper.queryFormDisplayName(rs.getString("FTAGID"), publishSourceType, qingContext, PublishCardDao.this.dbExcuter));
                            HashMap<String, String> hashMap = new HashMap<String, String>(4);
                            hashMap.put("fTagId", rs.getString("FTAGID"));
                            hashMap.put("publishSourceType", publishSourceType);
                            publishSourceGroupIdMap.put(cardVO.getId(), hashMap);
                        }
                        catch (IntegratedRuntimeException integratedRuntimeException) {
                            throw new SQLException(integratedRuntimeException);
                        }
                    } else {
                        cardVO.setPublishSourceName(rs.getString("THEMENAME"));
                        cardVO.setPublishSourceGroupName(rs.getString("THEMEGROUPNAME"));
                    }
                    cardVO.setPublishSourceType(publishSourceType);
                    cardVO.setCarryData(rs.getBoolean("FCARRYDATA"));
                    cardVO.setPreset(presetUserId.equals(rs.getString("FCREATORID")));
                    listVO.add(cardVO);
                }
                Map<String, String> publishSourceGroupNameMap = IntegratedHelper.queryFormFullPath(publishSourceGroupIdMap.values(), qingContext);
                for (PublishVO publishVO : listVO) {
                    String fTagId;
                    Map publishSourceGroupId = (Map)publishSourceGroupIdMap.get(publishVO.getId());
                    if (MapUtils.isEmpty((Map)publishSourceGroupId) || (fTagId = (String)publishSourceGroupId.get("fTagId")) == null) continue;
                    publishVO.setPublishSourceGroupName(publishSourceGroupNameMap.get(fTagId));
                }
                return listVO;
            }
        });
        return listVO;
    }

    public List<CardVO> loadAllPresetPublishInfos(final QingContext qingContext) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("SELECT P.FID, P.FTYPE, P.FSOURCE, P.FNAME, P.FPATH, PUBG.FNAME AS PATHTEXT, C.FID AS CARDID, C.FCARDDESC, C.FIMAGEPATH, ").append(" P.FCREATETIME, P.FUPDATETIME, P.FSCHEMAID, P.FANALYSIS, P.FTAGID, P.FCARRYDATA, THEME.FNAME AS THEMENAME, P.FCREATORID").append(" FROM (SELECT P1.FID, P1.FTYPE, P1.FSOURCE, P1.FNAME, P1.FPATH, P1.FCREATETIME,").append(" P1.FUPDATETIME, P1.FSCHEMAID, P1.FANALYSIS, P1.FTAGID, P1.FCARRYDATA, P1.FCREATORID").append(" FROM T_QING_PUBLISH P1 WHERE P1.FTYPE=? AND P1.FCREATORID=? ) P ").append(" LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID").append(" LEFT JOIN T_QING_PUBLISH_CARDINFO C ON C.FPUBLISHID = P.FID").append(" LEFT JOIN T_QING_PUBLISH_GROUP PUBG ON PUBG.FID = P.FPATH").append(" ORDER BY P.FCREATETIME DESC");
        Object[] params = new Object[]{5, IntegratedHelper.getPresetUserId()};
        List listVO = (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new ResultHandler<List<CardVO>>(){

            public List<CardVO> handle(ResultSet rs) throws SQLException {
                ArrayList<CardVO> listVO = new ArrayList<CardVO>();
                CardVO vo = null;
                while (rs.next()) {
                    if (rs.getString("FID").equals("id")) continue;
                    for (CardVO existVO : listVO) {
                        if (!rs.getString("FID").equals(existVO.getId())) continue;
                        vo = existVO;
                        break;
                    }
                    PublishCardDao.this.readCardVoFromDB(vo, listVO, rs, qingContext);
                }
                return listVO;
            }
        });
        return listVO;
    }

    public List<CardVO> loadPresetPublishInfos(String path, final QingContext qingContext) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("SELECT P.FID, P.FTYPE, P.FSOURCE, P.FNAME, P.FPATH, CG.FNAME AS PATHTEXT, C.FID AS CARDID, C.FCARDDESC, C.FIMAGEPATH,").append(" P.FSCHEMAID, P.FANALYSIS, P.FTAGID, P.FCARRYDATA, THEME.FNAME AS THEMENAME, P.FCREATORID").append(" FROM T_QING_PUBLISH P").append(" LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID").append(" LEFT JOIN T_QING_PUBLISH_CARDINFO C ON C.FPUBLISHID = P.FID").append(" LEFT JOIN T_QING_PUBLISH_GROUP CG ON CG.FID = P.FPATH").append(" WHERE P.FTYPE=? AND P.FCREATORID=? AND P.FPATH= ?").append(" ORDER BY P.FNAME DESC");
        Object[] params = new Object[]{5, IntegratedHelper.getPresetUserId(), path};
        List listVO = (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new ResultHandler<List<CardVO>>(){

            public List<CardVO> handle(ResultSet rs) throws SQLException {
                ArrayList<CardVO> listVO = new ArrayList<CardVO>();
                CardVO vo = null;
                while (rs.next()) {
                    for (CardVO existVO : listVO) {
                        if (!rs.getString("FID").equals(existVO.getId())) continue;
                        vo = existVO;
                        break;
                    }
                    PublishCardDao.this.readCardVoFromDB(vo, listVO, rs, qingContext);
                }
                return listVO;
            }
        });
        return listVO;
    }

    public List<CardGroupVO> loadGroups(String userId) throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT FID, FNAME FROM T_QING_Publish_Group where FUSERID=? ORDER BY FCREATETIME";
        Object[] params = new Object[]{userId};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<CardGroupVO>>(){

            public List<CardGroupVO> handle(ResultSet rs) throws SQLException {
                ArrayList<CardGroupVO> groups = new ArrayList<CardGroupVO>();
                while (rs.next()) {
                    CardGroupVO po = new CardGroupVO();
                    po.setId(rs.getString("FID"));
                    po.setName(rs.getString("FNAME"));
                    groups.add(po);
                }
                return groups;
            }
        });
    }

    public List<CardGroupVO> loadGroups(String userId, boolean showDSBCard) throws SQLException, AbstractQingIntegratedException {
        String sqlQuestion = "";
        if (!showDSBCard) {
            sqlQuestion = "AND (P.FSOURCE = 'subject' or P.FSOURCE = 'bill') ";
        }
        String sql = "SELECT TP.FID, TP.FNAME FROM T_QING_PUBLISH P LEFT JOIN T_QING_PUBLISH_GROUP TP ON TP.FID = P.FPATH " + sqlQuestion + " WHERE TP.FUSERID=? ORDER BY TP.FCREATETIME";
        Object[] params = new Object[]{userId};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<CardGroupVO>>(){

            public List<CardGroupVO> handle(ResultSet rs) throws SQLException {
                ArrayList<CardGroupVO> groups = new ArrayList<CardGroupVO>();
                while (rs.next()) {
                    CardGroupVO po = new CardGroupVO();
                    po.setId(rs.getString("FID"));
                    po.setName(rs.getString("FNAME"));
                    groups.add(po);
                }
                return groups;
            }
        });
    }

    public List<CardGroupVO> loadPresetGroups() throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT FID, FNAME FROM T_QING_Publish_Group where FUSERID=? ORDER BY FNAME";
        Object[] params = new Object[]{IntegratedHelper.getPresetUserId()};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<CardGroupVO>>(){

            public List<CardGroupVO> handle(ResultSet rs) throws SQLException {
                ArrayList<CardGroupVO> groups = new ArrayList<CardGroupVO>();
                while (rs.next()) {
                    CardGroupVO po = new CardGroupVO();
                    po.setId(rs.getString("FID"));
                    po.setName(rs.getString("FNAME"));
                    po.setPreset(true);
                    groups.add(po);
                }
                return groups;
            }
        });
    }

    public List<CardGroupVO> loadPresetGroups(boolean showDSBCard) throws SQLException, AbstractQingIntegratedException {
        String sqlQuestion = "";
        if (!showDSBCard) {
            sqlQuestion = "AND (P.FSOURCE = 'subject' or P.FSOURCE = 'bill') ";
        }
        String sql = "SELECT DISTINCT TP.FID, TP.FNAME FROM T_QING_PUBLISH P LEFT JOIN T_QING_PUBLISH_GROUP TP ON TP.FID = P.FPATH " + sqlQuestion + " WHERE TP.FUSERID=? ORDER BY TP.FNAME";
        Object[] params = new Object[]{IntegratedHelper.getPresetUserId()};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<CardGroupVO>>(){

            public List<CardGroupVO> handle(ResultSet rs) throws SQLException {
                ArrayList<CardGroupVO> groups = new ArrayList<CardGroupVO>();
                while (rs.next()) {
                    CardGroupVO po = new CardGroupVO();
                    po.setId(rs.getString("FID"));
                    po.setName(rs.getString("FNAME"));
                    po.setPreset(true);
                    groups.add(po);
                }
                return groups;
            }
        });
    }

    public void saveGroup(CardGroupPO po) throws SQLException, AbstractQingIntegratedException {
        String sql = "INSERT INTO T_QING_PUBLISH_GROUP (FID, FNAME, FUSERID, FCREATETIME, FUPDATETIME) VALUES (?,?,?,?,?)";
        Object[] params = new Object[]{po.getfId(), po.getName(), po.getUserId(), new Timestamp(new Date().getTime()), new Timestamp(new Date().getTime())};
        this.dbExcuter.execute(sql, params);
    }

    public boolean isGroupNameExist(String userId, String cardGroupId, String cardGroupName) throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT FID, FNAME FROM T_QING_Publish_Group where FUSERID=? AND FNAME=? ";
        Object[] params = null;
        if (cardGroupId != null && !"".equals(cardGroupId.trim())) {
            sql = sql + " and FID != ?";
            params = new Object[]{userId, cardGroupName, cardGroupId};
        } else {
            params = new Object[]{userId, cardGroupName};
        }
        return (Boolean)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public void updateGroup(CardGroupPO po) throws SQLException, AbstractQingIntegratedException {
        String sql = "UPDATE T_QING_Publish_Group set FNAME=?, FUPDATETIME=? WHERE FID=? and FUSERID=?";
        Object[] params = new Object[]{po.getName(), new Timestamp(new Date().getTime()), po.getfId(), po.getUserId()};
        this.dbExcuter.execute(sql, params);
    }

    public void deleteGroup(String userId, String id) throws SQLException, AbstractQingIntegratedException {
        String sql = "DELETE FROM T_QING_PUBLISH_GROUP WHERE FID=? AND FUSERID=?";
        Object[] params = new Object[]{id, userId};
        this.dbExcuter.execute(sql, params);
    }

    public boolean isGroupEmpty(String userId, String cardGroupId) throws AbstractQingIntegratedException, SQLException {
        String sql = "select P.FID FROM T_QING_PUBLISH P WHERE P.FTYPE=? AND P.FCREATORID=? AND P.FPATH= ? ";
        Object[] params = new Object[]{5, userId, cardGroupId};
        return (Boolean)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public CardGroupPO loadGroupByIdForExport(String fId) throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT FID, FNAME,FUSERID FROM T_QING_Publish_Group where FID=?";
        Object[] params = new Object[]{fId};
        return (CardGroupPO)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<CardGroupPO>(){

            public CardGroupPO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    CardGroupPO po = new CardGroupPO();
                    po.setfId(rs.getString("FID"));
                    po.setName(rs.getString("FNAME"));
                    po.setUserId(rs.getString("FUSERID"));
                    return po;
                }
                return null;
            }
        });
    }

    public CardGroupPO loadGroupByName(final String userId, String groupName) throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT FID, FNAME FROM T_QING_Publish_Group where FUSERID=? and FNAME=?";
        Object[] params = new Object[]{userId, groupName};
        return (CardGroupPO)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<CardGroupPO>(){

            public CardGroupPO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    CardGroupPO po = new CardGroupPO();
                    po.setfId(rs.getString("FID"));
                    po.setName(rs.getString("FNAME"));
                    po.setUserId(userId);
                    return po;
                }
                return null;
            }
        });
    }

    public String loadPublishId(String cardGroupName, String cardName, String userId, int type) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT PUB.FID FROM T_QING_PUBLISH PUB  LEFT JOIN T_QING_PUBLISH_GROUP CARDGROUP ON PUB.FPATH = CARDGROUP.FID  WHERE CARDGROUP.FNAME=? AND PUB.FNAME = ? AND CARDGROUP.FUSERID=? AND PUB.FTYPE=?";
        Object[] params = new Object[]{cardGroupName, cardName, userId, type};
        return (String)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("FID");
                }
                return null;
            }
        });
    }

    public List<CardVO> loadAllPermCardBaseInfoByCardName(final String cardName, String userId, Set<String> roleIds) throws AbstractQingIntegratedException, SQLException {
        String sqlInQuestion = "null";
        if (roleIds != null && roleIds.size() > 0) {
            StringBuilder sqlInQuestionBuilder = new StringBuilder();
            sqlInQuestionBuilder.append("?");
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestionBuilder.append(",?");
            }
            sqlInQuestion = sqlInQuestionBuilder.toString();
        }
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("SELECT ").append(" PUB.FID, ").append(" PUB.FNAME, ").append(" CARDINFO.FID AS CARDID, ").append(" CARDINFO.FCARDDESC, ").append(" CARDINFO.FIMAGEPATH ").append(" FROM T_QING_PUBLISH PUB ").append(" LEFT JOIN T_QING_PUBLISH_CARDINFO CARDINFO ON CARDINFO.FPUBLISHID = PUB.FID").append(" WHERE PUB.FID IN").append(" ( SELECT PUB.FID").append(" FROM T_QING_PUBLISH PUB").append(" LEFT JOIN T_QING_PERMPUBLISH PERM ON PERM.FPUBLISHID = PUB.FID").append(" WHERE ((PERM.FVIEWERID=? AND PERM.FTYPE='0') OR PUB.FCREATORID = ?) AND PUB.FTYPE='5')").append(" OR PUB.FID IN ").append(" (SELECT PUB.FID").append(" FROM T_QING_PUBLISH PUB").append(" LEFT JOIN T_QING_PERMPUBLISH PERM ON PERM.FPUBLISHID = PUB.FID").append(" WHERE ((PERM.FVIEWERID IN(").append(sqlInQuestion).append(") AND PERM.FTYPE='1') OR PUB.FCREATORID = ?) AND PUB.FTYPE='5')");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        queryValue.add(userId);
        if (CollectionUtils.isNotEmpty(roleIds)) {
            queryValue.addAll(roleIds);
        }
        queryValue.add(userId);
        return (List)this.dbExcuter.query(sqlSelect.toString(), queryValue.toArray(), (ResultHandler)new ResultHandler<List<CardVO>>(){

            public List<CardVO> handle(ResultSet rs) throws SQLException {
                ArrayList<CardVO> cardVOs = new ArrayList<CardVO>();
                while (rs.next()) {
                    String name = rs.getString("FNAME");
                    if (name == null || !name.contains(cardName)) continue;
                    CardVO cardVO = null;
                    cardVO = new CardVO();
                    cardVO.setId(rs.getString("FID"));
                    cardVO.setName(name);
                    cardVO.setCardDesc(rs.getString("FCARDDESC"));
                    cardVO.setImagePath(rs.getString("FIMAGEPATH"));
                    cardVO.setCardInfoId(rs.getString("CARDID"));
                    cardVOs.add(cardVO);
                }
                return cardVOs;
            }
        });
    }

    public void cleanEmptyGroupByUserId(String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUBLISH_GROUP WHERE FID IN(SELECT FID FROM T_QING_PUBLISH_GROUP WHERE FUSERID=? AND FID NOT IN(SELECT FPATH FROM T_QING_PUBLISH WHERE FCREATORID=? AND FTYPE='5'))";
        Object[] params = new Object[]{userId, userId};
        this.dbExcuter.execute(sql, params);
    }
}

