/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.brief;

import com.kingdee.bos.qing.common.format.Formater;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.PartValue;
import com.kingdee.bos.qing.core.model.meta.DataType;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

abstract class AbstractExecutor {
    private II18nContext _i18nCtx;
    private Map<String, Formater> _mapFormater;

    AbstractExecutor() {
    }

    public final void setI18nContext(II18nContext i18nCtx) {
        this._i18nCtx = i18nCtx;
    }

    protected final II18nContext getI18nContext() {
        return this._i18nCtx;
    }

    protected final String getMLS(String key, String defaultValue) {
        return Messages.getLangMessage(this._i18nCtx, key, defaultValue);
    }

    private Formater getFormater(String formatString) {
        Formater formater;
        if (this._mapFormater == null) {
            this._mapFormater = new HashMap<String, Formater>();
        }
        if ((formater = this._mapFormater.get(formatString)) == null) {
            formater = new Formater();
            formater.setFormatString(formatString);
            formater.setI18nContext(this._i18nCtx);
            this._mapFormater.put(formatString, formater);
        }
        return formater;
    }

    protected final String formatDimension(Object value, AnalyticalField field) {
        if (value == null) {
            return "";
        }
        if (DataType.STRING == field.getDataType()) {
            return value.toString();
        }
        String formatString = field.getUsableFormat(this._i18nCtx);
        if (formatString == null || formatString.length() == 0) {
            return value.toString();
        }
        Formater formater = this.getFormater(formatString);
        if (value instanceof Calendar) {
            int formatingPart = PartValue.constraintFormating(field.getPartValue());
            return formater.format((Calendar)value, formatingPart);
        }
        return formater.format(value);
    }

    protected final String formatMeasure(Object value, AnalyticalField field) {
        Comparable<BigDecimal> formatTarget;
        if (value == null) {
            return "";
        }
        if (!(value instanceof BigDecimal)) {
            return value.toString();
        }
        BigDecimal number = (BigDecimal)value;
        String formatString = field.getUsableFormat(this._i18nCtx);
        if (field.isFormatingAsDate()) {
            formatTarget = Aggregator.bigDecimalToCalendar(number);
        } else {
            formatTarget = number;
            if (formatString == null || formatString.length() == 0) {
                int scale = number.scale();
                formatString = "#,##0" + (scale == 0 ? "" : (scale == 1 ? ".0" : ".00"));
            }
        }
        Formater formater = this.getFormater(formatString);
        return formater.format((Object)formatTarget);
    }
}

