/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.brief;

import com.kingdee.bos.qing.common.grammar.AbstractExecuteContext;
import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.expr.VariantExpr;
import com.kingdee.bos.qing.core.brief.AbstractExecutor;
import com.kingdee.bos.qing.core.brief.BriefOutput;
import com.kingdee.bos.qing.core.brief.BriefOutputFunctions;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.IEngineOutput;
import com.kingdee.bos.qing.core.exception.BriefOutputException;
import com.kingdee.bos.qing.core.i18n.sort.LocaleComparer;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.brief.BriefOutputDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class BriefOutputExecutor
extends AbstractExecutor {
    private BriefOutputDefinition _definition;
    private boolean _display = true;
    private boolean _preview;
    private IEngineOutput _engineOutput;
    private List<BriefItem> _brief;

    public void setDefinition(BriefOutputDefinition definition) {
        this._definition = definition;
    }

    public void setUsageContext(boolean display, boolean preview) {
        this._display = display;
        this._preview = preview;
    }

    public void setEngineOutput(IEngineOutput engineOutput) {
        this._engineOutput = engineOutput;
    }

    public BriefOutput pickCube() {
        BriefOutput briefOutput;
        this.initBrief();
        try {
            this.filterBrief();
        }
        catch (BriefOutputException ex) {
            return new BriefOutput(ex.getErrorCode(), ex.getMessage());
        }
        this.sortBrief();
        List<OutputColumn> outputColumns = this.getOutputColumns();
        try {
            briefOutput = this.outputBrief(outputColumns);
        }
        catch (BriefOutputException ex) {
            return new BriefOutput(ex.getErrorCode(), ex.getMessage());
        }
        return briefOutput;
    }

    private void initBrief() {
        AnalyticalField field;
        Cuboid cuboid = this._engineOutput.getCuboid();
        HashMap<String, BriefOutputDefinition.AbstractPicker> definedDimensionPickers = new HashMap<String, BriefOutputDefinition.AbstractPicker>();
        List<BriefOutputDefinition.AbstractPicker> dimensionPickers = this._definition.getDimensionPickers();
        for (int i = 0; i < dimensionPickers.size(); ++i) {
            BriefOutputDefinition.AbstractPicker picker = dimensionPickers.get(i);
            definedDimensionPickers.put(picker.getFieldId(), picker);
        }
        dimensionPickers = new ArrayList<BriefOutputDefinition.AbstractPicker>();
        List<AnalyticalField> dimensions = cuboid.getDimensionFields();
        for (int i = 0; i < dimensions.size(); ++i) {
            AnalyticalField field2 = dimensions.get(i);
            BriefOutputDefinition.AbstractPicker picker = (BriefOutputDefinition.AbstractPicker)definedDimensionPickers.get(field2.getId());
            if (picker == null) {
                picker = new BriefOutputDefinition.FullPicker();
            }
            dimensionPickers.add(picker);
        }
        this._definition.setDimensionPickers(dimensionPickers);
        HashMap<String, BriefOutputDefinition.AbstractPicker> definedMeasurePickers = new HashMap<String, BriefOutputDefinition.AbstractPicker>();
        List<BriefOutputDefinition.AbstractPicker> measurePickers = this._definition.getMeasurePickers();
        for (int i = 0; i < measurePickers.size(); ++i) {
            BriefOutputDefinition.AbstractPicker picker = measurePickers.get(i);
            definedMeasurePickers.put(picker.getFieldId(), picker);
        }
        measurePickers = new ArrayList<BriefOutputDefinition.AbstractPicker>();
        List<AnalyticalField> measures = cuboid.getMeasureFields();
        for (int i = 0; i < measures.size() && (field = measures.get(i)).getId() != null; ++i) {
            BriefOutputDefinition.AbstractPicker picker = (BriefOutputDefinition.AbstractPicker)definedMeasurePickers.get(field.getId());
            if (picker == null) {
                picker = new BriefOutputDefinition.FullPicker();
            }
            measurePickers.add(picker);
        }
        this._definition.setMeasurePickers(measurePickers);
        this._brief = new LinkedList<BriefItem>();
        Iterator<CompositeKey> it = cuboid.createDimensionKeyIterator();
        while (it.hasNext()) {
            CompositeKey dimKey = it.next();
            Aggregator[] aggs = cuboid.getCellAggregators(dimKey);
            this._brief.add(new BriefItem(dimKey, aggs));
        }
    }

    private void filterBrief() throws BriefOutputException {
        List<BriefOutputDefinition.AbstractPicker> dimensionPickers = this._definition.getDimensionPickers();
        block14: for (int i = 0; i < dimensionPickers.size(); ++i) {
            BriefOutputDefinition.AbstractPicker picker = dimensionPickers.get(i);
            switch (picker.getType()) {
                case CONDITION: {
                    try {
                        this.conditionFilter(true, i, (BriefOutputDefinition.ConditionPicker)picker);
                        continue block14;
                    }
                    catch (ExecuteException ex) {
                        String which = this.getMLS("briefOutputDimensionCondition", "\u7b2c#1\u4e2a\u7ef4\u5ea6\u7684\u7b5b\u9009\u6761\u4ef6").replace("#1", String.valueOf(i + 1));
                        String script = ((BriefOutputDefinition.ConditionPicker)picker).getConditionScript();
                        throw this.createBriefOutputException(ex, which, script);
                    }
                }
                case FULL: {
                    continue block14;
                }
                default: {
                    throw new RuntimeException("Impossible");
                }
            }
        }
        List<BriefOutputDefinition.AbstractPicker> measurePickers = this._definition.getMeasurePickers();
        block15: for (int i = 0; i < measurePickers.size(); ++i) {
            BriefOutputDefinition.AbstractPicker picker = measurePickers.get(i);
            switch (picker.getType()) {
                case CONDITION: {
                    try {
                        this.conditionFilter(false, i, (BriefOutputDefinition.ConditionPicker)picker);
                        continue block15;
                    }
                    catch (ExecuteException ex) {
                        String which = this.getMLS("briefOutputMeasureCondition", "\u7b2c#1\u4e2a\u5ea6\u91cf\u7684\u7b5b\u9009\u6761\u4ef6").replace("#1", String.valueOf(i + 1));
                        String script = ((BriefOutputDefinition.ConditionPicker)picker).getConditionScript();
                        throw this.createBriefOutputException(ex, which, script);
                    }
                }
                case MAX: {
                    this.topFilter(i, false, ((BriefOutputDefinition.MaxPicker)picker).getTopN());
                    continue block15;
                }
                case MIN: {
                    this.topFilter(i, true, ((BriefOutputDefinition.MinPicker)picker).getTopN());
                    continue block15;
                }
                case FULL: {
                    continue block15;
                }
                default: {
                    throw new RuntimeException("Impossible");
                }
            }
        }
    }

    private BriefOutputException createBriefOutputException(ExecuteException ex, String which, String script) {
        String who = this._definition.getName();
        String what = this.getMLS("briefOutputExecute", "\u6267\u884c\u8fc7\u7a0b");
        String exMsg = "type:" + ex.getType();
        String message = who + " | " + which + " | " + what + " | " + exMsg + "\r\n" + script;
        return BriefOutputException.createFormulaExecuteException(message);
    }

    private void sortBrief() {
        List<BriefOutputDefinition.AbstractPicker> dimensionPickers = this._definition.getDimensionPickers();
        for (int i = 0; i < dimensionPickers.size(); ++i) {
            BriefOutputDefinition.AbstractPicker picker = dimensionPickers.get(i);
            if (!picker.isSortAccording()) continue;
            this.sortAccordingDimension(i, picker.isSortAsc());
            return;
        }
        List<BriefOutputDefinition.AbstractPicker> measurePickers = this._definition.getMeasurePickers();
        for (int i = 0; i < measurePickers.size(); ++i) {
            BriefOutputDefinition.AbstractPicker picker = measurePickers.get(i);
            if (!picker.isSortAccording()) continue;
            this.sortAccordingMeasure(i, picker.isSortAsc());
            return;
        }
    }

    private List<OutputColumn> getOutputColumns() {
        int i;
        int iColumnCount = 4;
        ArrayList<OutputColumn> outputColumns = new ArrayList<OutputColumn>(iColumnCount);
        for (int i2 = 0; i2 < iColumnCount; ++i2) {
            outputColumns.add(null);
        }
        List<BriefOutputDefinition.AbstractPicker> dimensionPickers = this._definition.getDimensionPickers();
        for (int i3 = 0; i3 < dimensionPickers.size(); ++i3) {
            BriefOutputDefinition.AbstractPicker picker = dimensionPickers.get(i3);
            if (!picker.isOutputTarget()) continue;
            outputColumns.set(picker.getOutputTargetIndex(), new OutputColumn(true, i3));
        }
        List<BriefOutputDefinition.AbstractPicker> measurePickers = this._definition.getMeasurePickers();
        for (i = 0; i < measurePickers.size(); ++i) {
            BriefOutputDefinition.AbstractPicker picker = measurePickers.get(i);
            if (!picker.isOutputTarget()) continue;
            outputColumns.set(picker.getOutputTargetIndex(), new OutputColumn(false, i));
        }
        for (i = iColumnCount - 2; i > 0; --i) {
            if (outputColumns.get(i) != null) continue;
            outputColumns.remove(i);
            outputColumns.add(null);
        }
        return outputColumns;
    }

    private BriefOutput outputBrief(List<OutputColumn> outputColumns) throws BriefOutputException {
        LinkedList<List<Object>> matrix = new LinkedList<List<Object>>();
        for (BriefItem item : this._brief) {
            int i;
            ArrayList<Object> row = new ArrayList<Object>(outputColumns.size());
            matrix.add(row);
            for (i = 0; i < outputColumns.size(); ++i) {
                row.add(null);
            }
            if (item.hasRanking()) {
                row.set(0, item.getRanking());
            }
            for (i = 1; i < outputColumns.size(); ++i) {
                OutputColumn outputColumn = outputColumns.get(i);
                if (outputColumn == null) continue;
                int idx = outputColumn.getDimensionOrMeasureIndex();
                Object value = outputColumn.isDimension() ? item.getCompositeKey().getMember(idx) : item.getAggregators()[idx].getValue();
                row.set(i, value);
            }
        }
        BriefOutput briefOutput = new BriefOutput();
        if (this._display) {
            List<List<String>> displayMatrix = this.formatEachCell(matrix, outputColumns);
            if (this._preview) {
                briefOutput.setPreviewMatrix(displayMatrix);
            }
            IExpr script = this._definition.getPostScriptExpr();
            String displayText = null;
            displayText = script != null ? this.formatDisplayByScript(displayMatrix, script) : this.formatDisplayDefault(displayMatrix);
            briefOutput.setDisplayText(displayText);
        }
        return briefOutput;
    }

    private List<List<String>> formatEachCell(List<List<Object>> matrix, List<OutputColumn> outputColumns) {
        Cuboid cuboid = this._engineOutput.getCuboid();
        LinkedList<List<String>> displayMatrix = new LinkedList<List<String>>();
        for (List<Object> row : matrix) {
            int i;
            ArrayList<String> displayRow = new ArrayList<String>();
            displayMatrix.add(displayRow);
            displayRow.add(row.get(0) == null ? null : String.valueOf(row.get(0)));
            for (i = 1; i < outputColumns.size(); ++i) {
                displayRow.add(null);
            }
            for (i = 1; i < outputColumns.size(); ++i) {
                String displayCell;
                AnalyticalField field;
                OutputColumn outputColumn = outputColumns.get(i);
                if (outputColumn == null) continue;
                Object cell = row.get(i);
                int idx = outputColumn.getDimensionOrMeasureIndex();
                if (outputColumn.isDimension()) {
                    field = cuboid.getDimensionField(idx);
                    displayCell = this.formatDimension(cell, field);
                } else {
                    field = cuboid.getMeasureField(idx);
                    displayCell = this.formatMeasure(cell, field);
                }
                displayRow.set(i, displayCell);
            }
        }
        return displayMatrix;
    }

    private String formatDisplayDefault(List<List<String>> displayMatrix) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < displayMatrix.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            List<String> row = displayMatrix.get(i);
            boolean bracket = false;
            for (int j = 1; j < row.size(); ++j) {
                String cell = row.get(j);
                if (cell == null) continue;
                if (j == 2) {
                    sb.append("(");
                    bracket = true;
                } else if (j > 2) {
                    sb.append(", ");
                }
                sb.append(cell);
            }
            if (!bracket) continue;
            sb.append(")");
        }
        return sb.toString();
    }

    private String formatDisplayByScript(List<List<String>> displayMatrix, IExpr script) throws BriefOutputException {
        PostScriptRuntimeContext ctx = new PostScriptRuntimeContext(displayMatrix);
        ctx.setI18nContext(this.getI18nContext());
        Object value = null;
        try {
            value = script.execute((IExecuteContext)ctx);
        }
        catch (ExecuteException ex) {
            String which = this.getMLS("briefOutputPostScript", "\u540e\u5904\u7406\u811a\u672c");
            throw this.createBriefOutputException(ex, which, this._definition.getPostScript());
        }
        return value == null ? "" : value.toString();
    }

    private void conditionFilter(boolean forDimension, int fieldIndex, BriefOutputDefinition.ConditionPicker picker) throws ExecuteException {
        ConditionFilterRuntimeContext ctx = new ConditionFilterRuntimeContext();
        ctx.setI18nContext(this.getI18nContext());
        IExpr checkerExpr = picker.getConditionExpr();
        Iterator<BriefItem> it = this._brief.iterator();
        while (it.hasNext()) {
            boolean matched;
            BriefItem item = it.next();
            Object checked = Boolean.FALSE;
            if (checkerExpr != null) {
                if (forDimension) {
                    CompositeKey dimKey = item.getCompositeKey();
                    Object member = dimKey.getMember(fieldIndex);
                    ctx.bindValue(member);
                } else {
                    Aggregator[] aggs = item.getAggregators();
                    Aggregator agg = aggs[fieldIndex];
                    ctx.bindValue(agg.getValue());
                }
                checked = checkerExpr.execute((IExecuteContext)ctx);
            }
            if (matched = checked instanceof Boolean && ((Boolean)checked).booleanValue()) continue;
            it.remove();
        }
    }

    private void topFilter(int measureIndex, boolean asc, int topN) {
        this.sortAccordingMeasure(measureIndex, asc);
        BriefItemComparator comparator = new BriefItemComparator(asc, null);
        BriefItem lastItem = null;
        int count = 0;
        LinkedList<BriefItem> briefTopN = new LinkedList<BriefItem>();
        for (BriefItem item : this._brief) {
            if (item.getSortAccording() == null) break;
            if (lastItem == null || comparator.compare(lastItem, item) != 0) {
                ++count;
            }
            if (count > topN) break;
            item.setRanking(count);
            briefTopN.add(item);
            lastItem = item;
        }
        this._brief = briefTopN;
    }

    private void sortAccordingDimension(int dimensionIndex, boolean asc) {
        for (BriefItem item : this._brief) {
            Object member = item.getCompositeKey().getMember(dimensionIndex);
            item.setSortAccording(member);
        }
        this.sort(asc);
    }

    private void sortAccordingMeasure(int measureIndex, boolean asc) {
        for (BriefItem item : this._brief) {
            Aggregator agg = item.getAggregators()[measureIndex];
            item.setSortAccording(agg.getValue());
        }
        this.sort(asc);
    }

    private void sort(boolean asc) {
        BriefItem[] ary = this._brief.toArray(new BriefItem[0]);
        Arrays.sort(ary, new BriefItemComparator(asc, this.getI18nContext().getLanManager().getLocale()));
        this._brief = new LinkedList<BriefItem>();
        for (BriefItem item : ary) {
            this._brief.add(item);
        }
    }

    private static class OutputColumn {
        private boolean _dimension;
        private int _index;

        public OutputColumn(boolean dimension, int index) {
            this._dimension = dimension;
            this._index = index;
        }

        public boolean isDimension() {
            return this._dimension;
        }

        public int getDimensionOrMeasureIndex() {
            return this._index;
        }
    }

    private static class BriefItemComparator
    implements Comparator<BriefItem> {
        private boolean _asc;
        private LocaleComparer _localeComparer;

        public BriefItemComparator(boolean asc, Locale locale) {
            this._asc = asc;
            this._localeComparer = locale == null ? null : LocaleComparer.create(locale);
        }

        @Override
        public int compare(BriefItem o1, BriefItem o2) {
            Comparable a1 = o1.getSortAccording();
            Comparable a2 = o2.getSortAccording();
            if (a1 == null && a2 == null) {
                return 0;
            }
            if (a1 == null) {
                return 1;
            }
            if (a2 == null) {
                return -1;
            }
            int compared = this._localeComparer == null ? a1.compareTo(a2) : this._localeComparer.compare(a1, a2);
            return this._asc ? compared : -compared;
        }
    }

    private static class BriefItem {
        private CompositeKey _dimKey;
        private Aggregator[] _aggs;
        private Comparable<?> _sortAccording;
        private Integer _ranking;

        public BriefItem(CompositeKey dimKey, Aggregator[] aggs) {
            this._dimKey = dimKey;
            this._aggs = aggs;
        }

        public CompositeKey getCompositeKey() {
            return this._dimKey;
        }

        public Aggregator[] getAggregators() {
            return this._aggs;
        }

        public void setSortAccording(Object value) {
            this._sortAccording = (Comparable)value;
        }

        public Comparable getSortAccording() {
            return this._sortAccording;
        }

        public void setRanking(int ranking) {
            this._ranking = ranking;
        }

        public boolean hasRanking() {
            return this._ranking != null;
        }

        public int getRanking() {
            return this._ranking;
        }
    }

    private static class PostScriptRuntimeContext
    extends AbstractExecuteContext
    implements BriefOutputFunctions.IBriefOutputFormularContext {
        private List<List<String>> _displayMatrix;

        public PostScriptRuntimeContext(List<List<String>> displayMatrix) {
            this._displayMatrix = displayMatrix;
        }

        public Object getValue(IExpr expr) throws ExecuteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<List<String>> getDisplayMatrix() {
            return this._displayMatrix;
        }
    }

    private static class ConditionFilterRuntimeContext
    extends AbstractExecuteContext {
        private Object _value;

        private ConditionFilterRuntimeContext() {
        }

        public void bindValue(Object value) {
            this._value = value;
        }

        public Object getValue(IExpr expr) throws ExecuteException {
            String name;
            if (expr instanceof VariantExpr && "VALUE".equalsIgnoreCase(name = ((VariantExpr)expr).getName())) {
                return this._value;
            }
            return null;
        }
    }
}

