/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.brief;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractFunctionExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BriefOutputFunctions {
    private BriefOutputFunctions() {
    }

    public static class RankTop
    extends AbstractFunctionExpr {
        private static final String PREFIX = "RT_";

        public RankTop() {
            super("RankTop");
        }

        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsCommonImpl(subExprs, new int[]{2});
        }

        public int getReturnDataType() {
            return 1;
        }

        public Object execute(IExecuteContext ctx) throws ExecuteException {
            int top = this.getIntValue(this.getParams()[0], ctx);
            return RankTop.encode(top);
        }

        private static String encode(int top) {
            return PREFIX + top;
        }

        public static boolean isRecognized(String encoded) {
            return encoded != null && encoded.startsWith(PREFIX);
        }

        public static int decode(String encoded) {
            String value = encoded.substring(PREFIX.length());
            int top = Integer.parseInt(value);
            return top;
        }
    }

    public static class Rank
    extends AbstractFunctionExpr {
        private static final String PREFIX = "R_";

        public Rank() {
            super("Rank");
        }

        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsCommonImpl(subExprs, new int[]{2});
        }

        public int getReturnDataType() {
            return 1;
        }

        public Object execute(IExecuteContext ctx) throws ExecuteException {
            int rank = this.getIntValue(this.getParams()[0], ctx);
            return Rank.encode(rank);
        }

        private static String encode(int rank) {
            return PREFIX + rank;
        }

        public static boolean isRecognized(String encoded) {
            return encoded != null && encoded.startsWith(PREFIX);
        }

        public static int decode(String encoded) {
            String value = encoded.substring(PREFIX.length());
            int rank = Integer.parseInt(value);
            return rank;
        }
    }

    public static class TopRows
    extends AbstractMatrixTraversalFunction {
        private int _topRows;
        private String _formatString;
        private String _separater;
        private StringBuilder _display;
        private int _count;

        public TopRows() {
            super("TopRows");
        }

        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsCommonImpl(subExprs, new int[]{2, 1, 1}, new int[]{2, 1, 1, 1});
        }

        public int getReturnDataType() {
            return 1;
        }

        public Object execute(IExecuteContext ctx) throws ExecuteException {
            IExpr[] params = this.getParams();
            this._topRows = this.getIntValue(params[0], ctx);
            this._formatString = this.getStringValue(params[1], ctx);
            this._separater = this.getStringValue(params[2], ctx);
            this._display = null;
            this._count = 1;
            String scope = this.getParamStringValueUseDefaultIfNotExist(ctx, 3, null);
            this.traversal(scope, ctx);
            return this._display == null ? "" : this._display.toString();
        }

        @Override
        protected boolean visitRow(List<String> row) {
            String displayRow = this.formatOneRow(row, this._formatString);
            if (this._display == null) {
                this._display = new StringBuilder();
            } else {
                this._display.append(this._separater);
            }
            this._display.append(displayRow);
            ++this._count;
            boolean isBreak = this._count > this._topRows;
            return isBreak;
        }
    }

    public static class EachRow
    extends AbstractMatrixTraversalFunction {
        private String _formatString;
        private String _separater;
        private StringBuilder _display;

        public EachRow() {
            super("EachRow");
        }

        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsCommonImpl(subExprs, new int[]{1, 1}, new int[]{1, 1, 1});
        }

        public int getReturnDataType() {
            return 1;
        }

        public Object execute(IExecuteContext ctx) throws ExecuteException {
            IExpr[] params = this.getParams();
            this._formatString = this.getStringValue(params[0], ctx);
            this._separater = this.getStringValue(params[1], ctx);
            this._display = null;
            String scope = this.getParamStringValueUseDefaultIfNotExist(ctx, 2, null);
            this.traversal(scope, ctx);
            return this._display == null ? "" : this._display.toString();
        }

        @Override
        protected boolean visitRow(List<String> row) {
            String displayRow = this.formatOneRow(row, this._formatString);
            if (this._display == null) {
                this._display = new StringBuilder();
            } else {
                this._display.append(this._separater);
            }
            this._display.append(displayRow);
            boolean isBreak = false;
            return isBreak;
        }
    }

    public static class RowsCount
    extends AbstractMatrixTraversalFunction {
        private int _count;

        public RowsCount() {
            super("RowsCount");
        }

        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsCommonImpl(subExprs, new int[0], new int[]{1});
        }

        public int getReturnDataType() {
            return 2;
        }

        public Object execute(IExecuteContext ctx) throws ExecuteException {
            this._count = 0;
            String scope = this.getParamStringValueUseDefaultIfNotExist(ctx, 0, null);
            if (scope == null) {
                List<List<String>> matrix = ((IBriefOutputFormularContext)ctx).getDisplayMatrix();
                this._count = matrix.size();
            } else {
                this.traversal(scope, ctx);
            }
            return new BigDecimal(this._count);
        }

        @Override
        protected boolean visitRow(List<String> row) {
            ++this._count;
            boolean isBreak = false;
            return isBreak;
        }
    }

    private static abstract class AbstractMatrixTraversalFunction
    extends AbstractFunctionExpr {
        protected AbstractMatrixTraversalFunction(String name) {
            super(name);
        }

        protected final void traversal(String scopeParamValue, IExecuteContext ctx) {
            List<List<String>> matrix = ((IBriefOutputFormularContext)ctx).getDisplayMatrix();
            if (Rank.isRecognized(scopeParamValue)) {
                int rank = Rank.decode(scopeParamValue);
                this.traversalRank(matrix, rank);
            } else if (RankTop.isRecognized(scopeParamValue)) {
                int rankTop = RankTop.decode(scopeParamValue);
                this.traversalRankTop(matrix, rankTop);
            } else {
                this.traversalAll(matrix);
            }
        }

        private void traversalAll(List<List<String>> matrix) {
            List<String> row;
            boolean isBreak;
            Iterator<List<String>> iterator = matrix.iterator();
            while (iterator.hasNext() && !(isBreak = this.visitRow(row = iterator.next()))) {
            }
        }

        private void traversalRank(List<List<String>> matrix, int rank) {
            boolean isBreak;
            List<String> row;
            String displayRank;
            String targetRank = Integer.toString(rank);
            Iterator<List<String>> iterator = matrix.iterator();
            while (!(!iterator.hasNext() || (displayRank = (row = iterator.next()).get(0)) != null && displayRank.equals(targetRank) && (isBreak = this.visitRow(row)))) {
            }
        }

        private void traversalRankTop(List<List<String>> matrix, int rankTop) {
            HashMap<Integer, LinkedList<List<String>>> bucket = new HashMap<Integer, LinkedList<List<String>>>();
            for (List<String> row : matrix) {
                int rank;
                String displayRank = row.get(0);
                if (displayRank == null || (rank = Integer.parseInt(displayRank)) > rankTop) continue;
                LinkedList<List<String>> rows = (LinkedList<List<String>>)bucket.get(rank);
                if (rows == null) {
                    rows = new LinkedList<List<String>>();
                    bucket.put(rank, rows);
                }
                rows.add(row);
            }
            for (int i = 1; i <= rankTop; ++i) {
                List rows = (List)bucket.get(i);
                if (rows == null) continue;
                for (List row : rows) {
                    boolean isBreak = this.visitRow(row);
                    if (!isBreak) continue;
                    return;
                }
            }
        }

        protected abstract boolean visitRow(List<String> var1);

        protected final String formatOneRow(List<String> row, String formatString) {
            String displayRow = formatString;
            for (int i = 0; i < row.size(); ++i) {
                String columnTag = "\\{" + i + "\\}";
                String displayCell = row.get(i);
                displayCell = displayCell == null ? "" : displayCell;
                displayRow = displayRow.replaceAll(columnTag, displayCell);
            }
            return displayRow;
        }
    }

    public static interface IBriefOutputFormularContext {
        public List<List<String>> getDisplayMatrix();
    }
}

