/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.charttype.longer;

import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.PartValue;
import com.kingdee.bos.qing.core.model.analysis.longer.AbstractFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.MarkFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.ModelAssistantStructure;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import java.util.List;

public abstract class AbstractChartTypeCoupler {
    public abstract ModelAssistantStructure parseAssistantStructure(AnalyticalModel var1);

    public abstract AbstractFlatBuilder createFlatBuilder();

    protected final void parseFields(AbstractFieldSet fieldSet, List<AnalyticalField> dimensionFields, List<AnalyticalField> measureFields) {
        this.parseFields(fieldSet.getFields(), dimensionFields, measureFields, true);
    }

    protected final void parseFieldsWithoutCheckingSame(AbstractFieldSet fieldSet, List<AnalyticalField> dimensionFields, List<AnalyticalField> measureFields) {
        this.parseFields(fieldSet.getFields(), dimensionFields, measureFields, false);
    }

    private void parseFields(List<AnalyticalField> fields, List<AnalyticalField> dimensionFields, List<AnalyticalField> measureFields, boolean isCheckingSame) {
        for (AnalyticalField field : fields) {
            MetaField mf = field.getMetaField();
            if (mf.isCalculation() && !mf.isValidCalculation()) continue;
            if (field.isMeasure()) {
                if (measureFields == null) continue;
                boolean isFound = false;
                if (isCheckingSame) {
                    for (int i = 0; i < measureFields.size(); ++i) {
                        if (!measureFields.get(i).isSame(field) || mf.getFormulaAggStatus() == MetaField.FormulaAggStatus.Interline || mf.getFormulaAggStatus() == MetaField.FormulaAggStatus.WithTotal) continue;
                        isFound = true;
                        break;
                    }
                }
                if (isFound) continue;
                measureFields.add(field);
                continue;
            }
            if (dimensionFields == null || mf.isCalculation() && MetaField.FormulaAggStatus.isRelativeAggregation(mf.getFormulaAggStatus())) continue;
            dimensionFields.add(field);
        }
    }

    protected static final void makeSureMarkTypeExist(MarkFieldSet markFieldSet) {
        List<String> markTypes = markFieldSet.getMarkTypes();
        List<AnalyticalField> fields = markFieldSet.getFields();
        for (int i = markFieldSet.getFieldCount() - 1; i >= 0; --i) {
            String markType = markTypes.get(i);
            if (markType != null && !"".equals(markType)) continue;
            markTypes.remove(i);
            fields.remove(i);
        }
    }

    protected static final void makeSureMarkTypeAppointed(MarkFieldSet markFieldSet, String markType, String role) {
        List<String> markTypes = markFieldSet.getMarkTypes();
        List<AnalyticalField> fields = markFieldSet.getFields();
        for (int i = markFieldSet.getFieldCount() - 1; i >= 0; --i) {
            String mt = markTypes.get(i);
            if (!markType.equals(mt) || role.equals(fields.get(i).getRole())) continue;
            markTypes.remove(i);
            fields.remove(i);
        }
    }

    protected static final void makeSureMarkTypeSingle(MarkFieldSet markFieldSet, String markType, String role) {
        int i;
        List<String> markTypes = markFieldSet.getMarkTypes();
        List<AnalyticalField> fields = markFieldSet.getFields();
        int targetIdx = Integer.MAX_VALUE;
        int c = markFieldSet.getFieldCount();
        for (i = 0; i < c; ++i) {
            String mt = markTypes.get(i);
            if (!markType.equals(mt) || !role.equals(fields.get(i).getRole())) continue;
            targetIdx = i;
            break;
        }
        for (i = markFieldSet.getFieldCount() - 1; i > targetIdx; --i) {
            String mt = markTypes.get(i);
            if (!markType.equals(mt) || !role.equals(fields.get(i).getRole())) continue;
            markTypes.remove(i);
            fields.remove(i);
        }
    }

    protected static final void makeSureMarkTypeSingle(MarkFieldSet markFieldSet, String markType) {
        int i;
        List<String> markTypes = markFieldSet.getMarkTypes();
        List<AnalyticalField> fields = markFieldSet.getFields();
        int targetIdx = Integer.MAX_VALUE;
        int c = markFieldSet.getFieldCount();
        for (i = 0; i < c; ++i) {
            String mt = markTypes.get(i);
            if (!markType.equals(mt)) continue;
            targetIdx = i;
            break;
        }
        for (i = markFieldSet.getFieldCount() - 1; i > targetIdx; --i) {
            String mt = markTypes.get(i);
            if (!markType.equals(mt)) continue;
            markTypes.remove(i);
            fields.remove(i);
        }
    }

    protected static final void makeSureOnlyOneMeasure(List<AnalyticalField> measures) {
        if (measures.isEmpty()) {
            return;
        }
        for (int i = measures.size(); i > 1; --i) {
            measures.remove(i - 1);
        }
    }

    protected static final void makeDateFieldContinuous(AnalyticalField field) {
        if (field.getDataType() == DataType.DATE) {
            field.setContinuous(true);
            field.getMetaField().setFiscalYearStart(0);
            switch (field.getPartValue()) {
                case DATE_QUARTER: {
                    field.setPartValue(PartValue.DATE_YQ);
                    break;
                }
                case DATE_MONTH: {
                    field.setPartValue(PartValue.DATE_YM);
                    break;
                }
                case DATE_DAY: {
                    field.setPartValue(PartValue.DATE_YMD);
                    break;
                }
            }
        }
    }
}

