/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.charttype.square;

import com.kingdee.bos.qing.core.charttype.square.AbstractChartPreprocessor;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.AbstractChart;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.RollFieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.chart.PercentArea;
import java.util.List;

class PercentAreaPreprocessor
extends AbstractChartPreprocessor {
    PercentAreaPreprocessor() {
    }

    @Override
    protected void preprocessChart(AbstractChart chart) {
        PercentArea area = (PercentArea)chart;
        PercentAreaPreprocessor.washDimension(area.getXAxis(), 1);
        PercentAreaPreprocessor.washDimension(area.getSeries(), 1);
        PercentAreaPreprocessor.washMeasure(area.getYAxis(), area.getSeries().getFieldCount() > 0 ? 1 : 64);
        FieldSet xAxis = area.getXAxis();
        if (xAxis.getFieldCount() > 0) {
            PercentAreaPreprocessor.makeDateFieldContinuous(xAxis.getField(0));
        }
        RollFieldSet rollFieldSet = area.getRoll();
        for (int i = 0; i < rollFieldSet.getFieldCount(); ++i) {
            PercentAreaPreprocessor.makeDateFieldContinuous(rollFieldSet.getField(i));
        }
    }

    @Override
    protected FieldSet getBeRolledFieldSet(AbstractChart chart) {
        PercentArea area = (PercentArea)chart;
        return area.getXAxis();
    }

    @Override
    protected List<AnalyticalField> createBeRolledFieldSetFields(AnalyticalField insteadField, List<AnalyticalField> drillDownPathFields, AbstractChart chart) {
        if (PercentAreaPreprocessor.checkContainsCubeInterlineCalculation(((PercentArea)chart).getYAxis())) {
            drillDownPathFields.add(0, insteadField);
            return drillDownPathFields;
        }
        return super.createBeRolledFieldSetFields(insteadField, drillDownPathFields, chart);
    }
}

