/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.monitor.heapsize.OccupyByte;
import com.kingdee.bos.qing.util.JsonUtil;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Aggregator {
    public static Aggregator create(Aggregation aggregation) {
        switch (aggregation) {
            case SUM: {
                return new Sum();
            }
            case AVG: {
                return new Avg();
            }
            case CNT: {
                return new Count();
            }
            case CNTD: {
                return new CountDistinct();
            }
            case MAX: {
                return new Max();
            }
            case MIN: {
                return new Min();
            }
            case AGG: {
                return new Agg();
            }
            case PROPERTIES: {
                return new Properties();
            }
            case ROW_NUM: {
                return new RowNum();
            }
        }
        throw new RuntimeException("Modify here when new aggregation is defined.");
    }

    public abstract void append(Object var1);

    public abstract Object getValue();

    public abstract void add(Aggregator var1);

    public abstract void carry(Aggregator var1);

    public abstract int getHeapSize();

    public abstract boolean comparing(Aggregator var1);

    public final BigDecimal getNumberValue() {
        return (BigDecimal)this.getValue();
    }

    public final Calendar getCalendarValue() {
        BigDecimal number = this.getNumberValue();
        return number == null ? null : Aggregator.bigDecimalToCalendar(number);
    }

    private static BigDecimal calendarToBigDecimal(Calendar date) {
        long ms1900 = date.getTimeInMillis() + 2209017600000L;
        double number = (double)ms1900 / 8.64E7 + 1.0;
        return BigDecimal.valueOf(number);
    }

    public static Calendar bigDecimalToCalendar(BigDecimal number) {
        long ms1970 = (long)((number.doubleValue() - 1.0) * 8.64E7 - 2.2090176E12);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(ms1970);
        return calendar;
    }

    public static class RowNum
    extends Properties<Long> {
        public List<Long> getRowNums() {
            LinkedList<Long> rowNums = new LinkedList<Long>(this._elements);
            return rowNums;
        }
    }

    public static class Properties<T>
    extends Aggregator {
        protected Set<T> _elements = new HashSet<T>();

        @Override
        public void append(Object value) {
            this._elements.add(value);
        }

        @Override
        public void carry(Aggregator another) {
            if (!(another instanceof Properties)) {
                throw new RuntimeException("Same class needed.");
            }
            this._elements.clear();
            this._elements.addAll(((Properties)another)._elements);
        }

        @Override
        public Object getValue() {
            return this._elements;
        }

        public Set<T> getDistinctValues() {
            return this._elements;
        }

        public int getValueCount() {
            return this._elements.size();
        }

        public T getSingleValue() {
            Iterator<T> it = this._elements.iterator();
            if (it.hasNext()) {
                return it.next();
            }
            return null;
        }

        @Override
        public void add(Aggregator aggregator) {
            if (!(aggregator instanceof Properties)) {
                throw new RuntimeException("Same class needed.");
            }
            Properties another = (Properties)aggregator;
            this._elements.addAll(another._elements);
        }

        @Override
        public boolean comparing(Aggregator aggregator) {
            if (aggregator instanceof Properties) {
                Properties another = (Properties)aggregator;
                return another._elements.equals(this._elements);
            }
            return false;
        }

        @Override
        public int getHeapSize() {
            int contentSize = (OccupyByte.REFERENCE + OccupyByte.OBJECT) * this._elements.size();
            return OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE) + contentSize;
        }
    }

    public static class Agg
    extends Aggregator {
        private BigDecimal _value;
        private Map<IExpr, Object> _interim;

        @Override
        public void append(Object value) {
            if (value instanceof BigDecimal) {
                this._value = (BigDecimal)value;
            } else if (value instanceof Calendar) {
                this._value = Aggregator.calendarToBigDecimal((Calendar)value);
            }
        }

        @Override
        public void carry(Aggregator another) {
            if (!(another instanceof Agg)) {
                throw new RuntimeException("Same class needed.");
            }
            this._value = ((Agg)another)._value;
        }

        @Override
        public Object getValue() {
            return this._value;
        }

        @Override
        public void add(Aggregator aggregator) {
        }

        @Override
        public int getHeapSize() {
            return OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE * 2) + OccupyByte.BIGDECIMAL;
        }

        @Override
        public boolean comparing(Aggregator aggregator) {
            Aggregator aggregator2 = aggregator = aggregator == EmptyInstead.Single ? new Agg() : aggregator;
            if (aggregator instanceof Agg) {
                Agg another = (Agg)aggregator;
                return this._value == null && another._value == null || this._value != null && this._value.equals(another._value);
            }
            return false;
        }

        private Map<IExpr, Object> getInterimMap() {
            if (this._interim == null) {
                this._interim = new HashMap<IExpr, Object>();
            }
            return this._interim;
        }

        public void setInterimValue(IExpr sub, Object value) {
            this.getInterimMap().put(sub, value);
        }

        public Object getInterimValue(IExpr sub) {
            return this.getInterimMap().get(sub);
        }
    }

    public static class Min
    extends Aggregator {
        private BigDecimal _min;

        @Override
        public void append(Object value) {
            if (value instanceof BigDecimal) {
                this.append((BigDecimal)value);
            } else if (value instanceof Calendar) {
                BigDecimal number = Aggregator.calendarToBigDecimal((Calendar)value);
                this.append(number);
            }
        }

        private void append(BigDecimal number) {
            this._min = this._min == null ? number : this._min.min(number);
        }

        @Override
        public void carry(Aggregator another) {
            if (!(another instanceof Min)) {
                throw new RuntimeException("Same class needed.");
            }
            this._min = ((Min)another)._min;
        }

        @Override
        public Object getValue() {
            return this._min;
        }

        @Override
        public void add(Aggregator aggregator) {
            Aggregator aggregator2 = aggregator = aggregator == EmptyInstead.Single ? new Min() : aggregator;
            if (!(aggregator instanceof Min)) {
                throw new RuntimeException("Same class needed.");
            }
            Min another = (Min)aggregator;
            this._min = this._min == null ? another._min : (another._min == null ? this._min : this._min.min(another._min));
        }

        @Override
        public boolean comparing(Aggregator aggregator) {
            if (aggregator instanceof Min) {
                Min another = (Min)aggregator;
                return this._min == null && another._min == null || this._min != null && this._min.equals(another._min);
            }
            return false;
        }

        @Override
        public int getHeapSize() {
            return OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE) + OccupyByte.BIGDECIMAL;
        }
    }

    public static class Max
    extends Aggregator {
        private BigDecimal _max;

        @Override
        public void append(Object value) {
            if (value instanceof BigDecimal) {
                this.append((BigDecimal)value);
            } else if (value instanceof Calendar) {
                BigDecimal number = Aggregator.calendarToBigDecimal((Calendar)value);
                this.append(number);
            }
        }

        private void append(BigDecimal number) {
            this._max = this._max == null ? number : this._max.max(number);
        }

        @Override
        public void carry(Aggregator another) {
            if (!(another instanceof Max)) {
                throw new RuntimeException("Same class needed.");
            }
            this._max = ((Max)another)._max;
        }

        @Override
        public Object getValue() {
            return this._max;
        }

        @Override
        public void add(Aggregator aggregator) {
            if (!(aggregator instanceof Max)) {
                throw new RuntimeException("Same class needed.");
            }
            Max another = (Max)aggregator;
            this._max = this._max == null ? another._max : (another._max == null ? this._max : this._max.max(another._max));
        }

        @Override
        public boolean comparing(Aggregator aggregator) {
            Aggregator aggregator2 = aggregator = aggregator == EmptyInstead.Single ? new Max() : aggregator;
            if (aggregator instanceof Max) {
                Max another = (Max)aggregator;
                return this._max == null && another._max == null || this._max != null && this._max.equals(another._max);
            }
            return false;
        }

        @Override
        public int getHeapSize() {
            return OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE) + OccupyByte.BIGDECIMAL;
        }
    }

    public static class CountDistinct
    extends Aggregator {
        private Set<Object> _collector = new HashSet<Object>();

        @Override
        public void append(Object value) {
            if (value != null) {
                this._collector.add(value);
            }
        }

        @Override
        public void carry(Aggregator another) {
            if (!(another instanceof CountDistinct)) {
                throw new RuntimeException("Same class needed.");
            }
            this._collector.clear();
            this._collector.addAll(((CountDistinct)another)._collector);
        }

        @Override
        public Object getValue() {
            return new BigDecimal(this._collector.size());
        }

        @Override
        public void add(Aggregator aggregator) {
            if (!(aggregator instanceof CountDistinct)) {
                throw new RuntimeException("Same class needed.");
            }
            CountDistinct another = (CountDistinct)aggregator;
            this._collector.addAll(another._collector);
        }

        @Override
        public boolean comparing(Aggregator aggregator) {
            Aggregator aggregator2 = aggregator = aggregator == EmptyInstead.Single ? new CountDistinct() : aggregator;
            if (aggregator instanceof CountDistinct) {
                CountDistinct another = (CountDistinct)aggregator;
                return this._collector.equals(another._collector);
            }
            return false;
        }

        @Override
        public int getHeapSize() {
            int subs = this._collector.size() * OccupyByte.MAP_ENTRY;
            return OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE) + OccupyByte.HASHMAP + subs;
        }
    }

    public static class Count
    extends Aggregator {
        private long _count;

        @Override
        public void append(Object value) {
            if (value != null) {
                ++this._count;
            }
        }

        @Override
        public void carry(Aggregator another) {
            if (!(another instanceof Count)) {
                throw new RuntimeException("Same class needed.");
            }
            this._count = ((Count)another)._count;
        }

        @Override
        public Object getValue() {
            return new BigDecimal(this._count);
        }

        @Override
        public void add(Aggregator aggregator) {
            if (aggregator instanceof Count) {
                Count another = (Count)aggregator;
                this._count += another._count;
            } else {
                throw new RuntimeException("Same class needed.");
            }
        }

        @Override
        public boolean comparing(Aggregator aggregator) {
            Aggregator aggregator2 = aggregator = aggregator == EmptyInstead.Single ? new Count() : aggregator;
            if (aggregator instanceof Count) {
                Count another = (Count)aggregator;
                return this._count == another._count;
            }
            return false;
        }

        @Override
        public int getHeapSize() {
            return OccupyByte.align(OccupyByte.OBJECT + OccupyByte.LONG);
        }
    }

    public static class Avg
    extends Aggregator {
        private long _count;
        private BigDecimal _sum;

        @Override
        public void append(Object value) {
            if (value instanceof BigDecimal) {
                this.append((BigDecimal)value);
            } else if (value instanceof Calendar) {
                BigDecimal number = Aggregator.calendarToBigDecimal((Calendar)value);
                this.append(number);
            }
        }

        private void append(BigDecimal number) {
            this._sum = this._sum == null ? number : this._sum.add(number);
            ++this._count;
        }

        @Override
        public void carry(Aggregator another) {
            if (!(another instanceof Avg)) {
                throw new RuntimeException("Same class needed.");
            }
            this._sum = ((Avg)another)._sum;
            this._count = ((Avg)another)._count;
        }

        @Override
        public Object getValue() {
            if (this._sum == null || this._count == 0L) {
                return null;
            }
            int scale = Math.min(15, Math.max(8, this._sum.scale()));
            return this._sum.divide(new BigDecimal(this._count), scale, 4);
        }

        @Override
        public void add(Aggregator aggregator) {
            Avg another;
            if (aggregator instanceof Avg) {
                another = (Avg)aggregator;
                this._count += another._count;
            } else {
                throw new RuntimeException("Same class needed.");
            }
            this._sum = this._sum == null ? another._sum : (another._sum == null ? this._sum : this._sum.add(another._sum));
        }

        @Override
        public boolean comparing(Aggregator aggregator) {
            Aggregator aggregator2 = aggregator = aggregator == EmptyInstead.Single ? new Avg() : aggregator;
            if (aggregator instanceof Avg) {
                Avg another = (Avg)aggregator;
                return this._count == another._count && (this._sum == null && another._sum == null || this._sum != null && this._sum.equals(another._sum));
            }
            return false;
        }

        @Override
        public int getHeapSize() {
            return OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE + OccupyByte.LONG) + OccupyByte.BIGDECIMAL;
        }
    }

    public static class Sum
    extends Aggregator {
        private BigDecimal _sum;

        @Override
        public void append(Object value) {
            if (value instanceof BigDecimal) {
                BigDecimal v = (BigDecimal)value;
                this._sum = this._sum == null ? v : this._sum.add(v);
            }
        }

        @Override
        public void carry(Aggregator another) {
            if (!(another instanceof Sum)) {
                throw new RuntimeException("Same class needed.");
            }
            this._sum = ((Sum)another)._sum;
        }

        @Override
        public Object getValue() {
            return this._sum;
        }

        @Override
        public void add(Aggregator aggregator) {
            if (!(aggregator instanceof Sum)) {
                throw new RuntimeException("Same class needed.");
            }
            Sum another = (Sum)aggregator;
            this._sum = this._sum == null ? another._sum : (another._sum == null ? this._sum : this._sum.add(another._sum));
        }

        @Override
        public boolean comparing(Aggregator aggregator) {
            Aggregator aggregator2 = aggregator = aggregator == EmptyInstead.Single ? new Sum() : aggregator;
            if (aggregator instanceof Sum) {
                Sum another = (Sum)aggregator;
                return this._sum == null && another._sum == null || this._sum != null && this._sum.equals(another._sum);
            }
            return false;
        }

        @Override
        public int getHeapSize() {
            return OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE) + OccupyByte.BIGDECIMAL;
        }
    }

    private static class EmptyInstead
    extends Sum {
        public static final EmptyInstead Single = new EmptyInstead();

        private EmptyInstead() {
        }
    }

    public static class JsonDecoder
    extends JsonUtil.AbstractJsonDecoder<Aggregator> {
        protected Aggregator decode(JsonUtil.AbstractJsonDecoder.Json json) {
            if (json.hasAttr("_max")) {
                return (Aggregator)this.fromJson(json, Max.class);
            }
            if (json.hasAttr("_min")) {
                return (Aggregator)this.fromJson(json, Min.class);
            }
            if (json.hasAttr("_sum")) {
                if (json.hasAttr("_count")) {
                    return (Aggregator)this.fromJson(json, Avg.class);
                }
                return (Aggregator)this.fromJson(json, Sum.class);
            }
            if (json.hasAttr("_count")) {
                return (Aggregator)this.fromJson(json, Count.class);
            }
            if (json.hasAttr("_value")) {
                return (Aggregator)this.fromJson(json, Agg.class);
            }
            return EmptyInstead.Single;
        }
    }
}

