/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.ContinuousChoosableModel;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.ContinuousDateChoosableModel;
import com.kingdee.bos.qing.monitor.heapsize.OccupyByte;
import java.math.BigDecimal;
import java.util.Calendar;

class ContinuousPreparedValueGainer
extends FilterPreparedValueGainer.AbstractPreparedValueGainer {
    private static final int HEAPSIZE_OVERHEAD = OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE + OccupyByte.BOOLEAN + OccupyByte.REFERENCE * 2) + OccupyByte.BIGDECIMAL * 2;
    private boolean _isForDate = false;
    private BigDecimal _max;
    private BigDecimal _min;

    public ContinuousPreparedValueGainer(AnalyticalField field) {
        super(field);
    }

    public void setForDate(boolean isForDate) {
        this._isForDate = isForDate;
    }

    @Override
    protected void doGain(Object value) {
        if (this._isForDate) {
            if (value instanceof Calendar) {
                Calendar c = (Calendar)value;
                long ms = c.getTime().getTime();
                BigDecimal v = new BigDecimal(ms);
                this._max = this._max == null ? v : this._max.max(v);
                this._min = this._min == null ? v : this._min.min(v);
            }
        } else if (value instanceof BigDecimal) {
            BigDecimal v = (BigDecimal)value;
            this._max = this._max == null ? v : this._max.max(v);
            this._min = this._min == null ? v : this._min.min(v);
        }
    }

    @Override
    public FilterPreparedValueGainer.IPreparedValueFruit getFruit() {
        if (this._isForDate) {
            return new MyContinousDateFruit(this._min, this._max);
        }
        return new MyContinuousFruit(this._min, this._max);
    }

    @Override
    public long estimateHeapSize(int reserved) {
        return HEAPSIZE_OVERHEAD;
    }

    private static class MyContinousDateFruit
    implements FilterPreparedValueGainer.IPreparedValueFruit {
        private Long _from;
        private Long _to;

        public MyContinousDateFruit(BigDecimal fromDate, BigDecimal toDate) {
            this._from = fromDate == null ? null : Long.valueOf(fromDate.longValue());
            this._to = toDate == null ? null : Long.valueOf(toDate.longValue());
        }

        @Override
        public boolean isGainerInvalid() {
            return this._from == null || this._to == null;
        }

        @Override
        public AbstractPreparedValue getPreparedValue() {
            ContinuousDateChoosableModel cdcm = new ContinuousDateChoosableModel();
            cdcm.setFromDate(this._from);
            cdcm.setToDate(this._to);
            return cdcm;
        }
    }

    private static class MyContinuousFruit
    implements FilterPreparedValueGainer.IPreparedValueFruit {
        private BigDecimal _min;
        private BigDecimal _max;

        public MyContinuousFruit(BigDecimal min, BigDecimal max) {
            this._min = min;
            this._max = max;
        }

        @Override
        public boolean isGainerInvalid() {
            return this._min == null || this._max == null;
        }

        @Override
        public AbstractPreparedValue getPreparedValue() {
            ContinuousChoosableModel ccm = new ContinuousChoosableModel();
            ccm.setMin(this._min);
            ccm.setMax(this._max);
            ccm.setSelectedMin(this._min);
            ccm.setSelectedMax(this._max);
            return ccm;
        }
    }
}

