/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.common.format.Formater;
import com.kingdee.bos.qing.core.engine.AbstractRuntimeDsFilter;
import com.kingdee.bos.qing.core.engine.DateProcesser;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.ParentChildDimensionMember;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.core.model.meta.DataType;
import java.util.HashSet;
import java.util.Set;

class DiscreteRuntimeFilter
extends AbstractRuntimeDsFilter {
    private Set<String> _comparingSet;
    private boolean _isComparingExclude;
    private boolean _isExcludeAll;
    private Formater _formater;
    private FilterPreparedValueGainer.IDateReprocessing _reprocessing;

    public DiscreteRuntimeFilter(AnalyticalField field, DiscreteFilter filter) {
        super(field, filter);
        this.prepare(filter);
    }

    private void prepare(DiscreteFilter filter) {
        this._comparingSet = new HashSet<String>();
        this._comparingSet.addAll(filter.getSelecteds());
        this._isComparingExclude = filter.isExclude();
        this._isExcludeAll = this._isComparingExclude && filter.isFullValue() || !this._isComparingExclude && this._comparingSet.isEmpty();
        this.prepareFormater();
    }

    private void prepareFormater() {
        if (DataType.DATE == this.getField().getDataType()) {
            this._reprocessing = new DateProcesser(this.getField());
        } else {
            String formatString = this.getField().getUsableNumberFormat();
            if (formatString != null && formatString.length() > 0) {
                this._formater = new Formater(formatString);
            }
        }
    }

    @Override
    public boolean isAccepted(Object value) throws AnalysisException {
        if (this._isExcludeAll) {
            return false;
        }
        String str = null;
        if (value instanceof ParentChildDimensionMember) {
            value = ((ParentChildDimensionMember)value).getIdValue();
        } else if (value != null && this._reprocessing != null) {
            value = this._reprocessing.toPromissoryValue(value);
        }
        if (value != null) {
            str = this._formater != null ? this._formater.format(value) : value.toString();
        }
        boolean isContains = this._comparingSet.contains(str);
        return this._isComparingExclude && !isContains || !this._isComparingExclude && isContains;
    }
}

