/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.AbstractRuntimeFilter;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.square.AbstractChart;
import com.kingdee.bos.qing.core.model.analysis.square.FilterItem;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class EngineOfSquare
extends AbstractEngine {
    private SquareModel _model;
    private boolean _grandTotal;

    public void setAnalyticalModel(SquareModel model, boolean isGrandTotalRequest) {
        this._model = model;
        this._grandTotal = isGrandTotalRequest;
        super.setAnalyticalModel(model);
    }

    @Override
    protected AbstractRuntimeFilter.IModelVisitor createModelVisitorForRuntimeFilter(boolean isIgnoredCubeInterlineCalculation) {
        return new ModelVisitorForRuntimeFilter(isIgnoredCubeInterlineCalculation);
    }

    @Override
    protected List<AnalyticalField> getFilterFields() {
        List<FilterItem> items = this._model.getFilters();
        if (items == null) {
            return null;
        }
        ArrayList<AnalyticalField> fields = new ArrayList<AnalyticalField>(items.size());
        for (FilterItem item : items) {
            fields.add(item.getField());
        }
        return fields;
    }

    @Override
    protected AbstractEngine.ISubtotalDependance createSubtotalDependance() {
        return new SubtotalDependance();
    }

    private class SubtotalDependance
    implements AbstractEngine.ISubtotalDependance {
        private SubtotalDependance() {
        }

        @Override
        public List<AnalyticalField> getRowDimensionFields() {
            final ArrayList<AnalyticalField> fields = new ArrayList<AnalyticalField>();
            EngineOfSquare.this._model.getChartModel().visitAllFields(new AbstractChart.AbstractFieldVisitor(){

                @Override
                public boolean visit(AnalyticalField field) {
                    if (field.isDimension()) {
                        fields.add(field);
                    }
                    return false;
                }
            });
            return fields;
        }

        @Override
        public List<AnalyticalField> getColumnDimensionFields() {
            return new ArrayList<AnalyticalField>();
        }

        @Override
        public boolean isColumnGrandTotal() {
            return EngineOfSquare.this._grandTotal;
        }

        @Override
        public boolean isRowGrandTotal() {
            return false;
        }
    }

    private class ModelVisitorForRuntimeFilter
    implements AbstractRuntimeFilter.IModelVisitor {
        private boolean _isIgnoredCubeInterlineCalculation = false;

        public ModelVisitorForRuntimeFilter(boolean isIgnoredCubeInterlineCalculation) {
            this._isIgnoredCubeInterlineCalculation = isIgnoredCubeInterlineCalculation;
        }

        @Override
        public int getFilterCount() {
            List<FilterItem> filters = EngineOfSquare.this._model.getFilters();
            return filters == null ? 0 : filters.size();
        }

        @Override
        public AnalyticalField getFilterField(int idx) {
            return EngineOfSquare.this._model.getFilters().get(idx).getField();
        }

        @Override
        public AbstractAnalyticalFilter getFilter(int idx) {
            return EngineOfSquare.this._model.getFilters().get(idx).getFilter();
        }

        @Override
        public boolean isContainsCubeInterlineCalculation() {
            return this._isIgnoredCubeInterlineCalculation ? false : EngineOfSquare.this._model.isContainsCubeInterlineCalculation();
        }

        @Override
        public Set<AnalyticalField> getCubeInterlineDimensions(AnalyticalField field) {
            return EngineOfSquare.this._model.getCubeInterlineDimensions(field);
        }
    }
}

