/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.core.exception.DataUnanalysableException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.meta.Elimination;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.datasource.exception.UnAnalysableException;
import com.kingdee.bos.qing.datasource.meta.DSElimination;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSMeta;
import com.kingdee.bos.qing.datasource.spec.IMetaVisitor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class MetaRecognizer {
    private IMetaVisitor _metaVisitor;
    private Set<DSFieldKey> _measures = new HashSet<DSFieldKey>();
    private Set<DSFieldKey> _nonmeasures = new HashSet<DSFieldKey>();
    private Set<DSElimination> _dsEliminations;
    private Set<DSFieldKey> _traversalFields;
    private Set<Elimination> _eliminations;

    public MetaRecognizer(IMetaVisitor metaVisitor) {
        this._metaVisitor = metaVisitor;
    }

    public void classifyFields(List<AnalyticalField> fields, Boolean appointedAsMeasure) {
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                AnalyticalField field = fields.get(i);
                boolean isMeasure = appointedAsMeasure == null ? field.isMeasure() : appointedAsMeasure.booleanValue();
                this.classifyField(isMeasure, field.getMetaField());
                if (field.getSortAccordingField() != null) {
                    this.classifyField(false, field.getSortAccordingField());
                }
                if (!field.isParentChildDimension()) continue;
                this.classifyField(false, field.getParentChildDimensionIdField());
                this.classifyField(false, field.getParentChildDimensionParentIdField());
            }
        }
    }

    private void classifyField(boolean isMeasure, MetaField mf) {
        Set<String> fieldNames = this.getUsedFieldNames(mf);
        if (isMeasure) {
            this.registerMeasureFields(fieldNames);
        } else {
            this.registerOtherFields(fieldNames);
        }
    }

    private Set<String> getUsedFieldNames(MetaField mf) {
        HashSet<String> fields = new HashSet<String>();
        if (mf.isCalculation()) {
            if (mf.isValidCalculation()) {
                Set<String> dependence = mf.getAllDependence();
                if (dependence != null && !dependence.isEmpty()) {
                    fields.addAll(dependence);
                }
                fields.add(mf.getFullName());
            }
        } else {
            fields.add(mf.getFullName());
        }
        return fields;
    }

    private void registerMeasureField(String fieldName) {
        String[] twoParts = MetaField.decodeFullName(fieldName);
        this._measures.add(new DSFieldKey(twoParts[0], twoParts[1]));
    }

    private void registerMeasureFields(Set<String> fieldNames) {
        if (fieldNames != null) {
            for (String fieldName : fieldNames) {
                this.registerMeasureField(fieldName);
            }
        }
    }

    private void registerOtherFields(String fieldName) {
        String[] twoParts = MetaField.decodeFullName(fieldName);
        this._nonmeasures.add(new DSFieldKey(twoParts[0], twoParts[1]));
    }

    private void registerOtherFields(Set<String> fieldNames) {
        if (fieldNames != null) {
            for (String fieldName : fieldNames) {
                this.registerOtherFields(fieldName);
            }
        }
    }

    public void appointEliminations(List<Elimination> eliminations) {
        if (eliminations == null || eliminations.isEmpty()) {
            return;
        }
        this._dsEliminations = new HashSet<DSElimination>();
        for (Elimination elimination : eliminations) {
            DSElimination dsElimination = new DSElimination();
            dsElimination.setIdField(elimination.getIdField());
            dsElimination.addAssociatedFields(elimination.getAssociatedFields());
            this._dsEliminations.add(dsElimination);
        }
    }

    public void recognizing() throws DataUnanalysableException {
        this._traversalFields = new HashSet<DSFieldKey>();
        this._traversalFields.addAll(this._nonmeasures);
        this._traversalFields.addAll(this._measures);
        this.recognizeEliminations();
    }

    public Set<DSFieldKey> getTraversalFields() {
        return this._traversalFields;
    }

    public Set<Elimination> getEliminations() {
        return this._eliminations;
    }

    private void recognizeEliminations() throws DataUnanalysableException {
        DSMeta dsMeta = this._metaVisitor.getMeta();
        if (dsMeta.getEliminations() == null) {
            try {
                dsMeta.fixEliminations(this._traversalFields, this._measures);
            }
            catch (UnAnalysableException e) {
                throw new DataUnanalysableException(e);
            }
        }
        HashSet dses = this._dsEliminations == null ? (dsMeta.getEliminations() == null ? null : new HashSet(dsMeta.getEliminations())) : this._dsEliminations;
        this._eliminations = this.transEliminations(dses);
    }

    private Set<Elimination> transEliminations(Set<DSElimination> dses) {
        if (dses == null || dses.isEmpty()) {
            return null;
        }
        HashSet<Elimination> eliminations = new HashSet<Elimination>(dses.size());
        for (DSElimination dse : dses) {
            Elimination elimination = new Elimination();
            elimination.setIdField(dse.getIdField());
            elimination.setAssociatedFields(dse.getAssociatedFields());
            eliminations.add(elimination);
            String idField = dse.getIdField();
            if (idField == null) continue;
            String[] twoParts = MetaField.decodeFullName(idField);
            this._traversalFields.add(new DSFieldKey(twoParts[0], twoParts[1]));
        }
        return eliminations;
    }
}

