/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine.runner.square;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.AbstractRuntimeFilter;
import com.kingdee.bos.qing.core.engine.DataSourceTraversal;
import com.kingdee.bos.qing.core.engine.ParentChildDimensionFilterPretreater;
import com.kingdee.bos.qing.core.engine.RuntimePushdownFilter;
import com.kingdee.bos.qing.core.engine.runner.square.AbstractEngineRunner;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.NecesaryDimensionMissingException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.core.model.analysis.square.AbstractChart;
import com.kingdee.bos.qing.core.model.analysis.square.FilterItem;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.AbstractChartProperty;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EngineRunner
extends AbstractEngineRunner {
    private List<AbstractRuntimeFilter.IRuntimePushdownFilter> _pushdownFilters;

    public EngineRunner(IDataSourceVisitor dataSourceVisitor, SquareModel model, II18nContext ctx) {
        super(dataSourceVisitor, model, ctx);
        this.setDataEmptyIgnored(true);
    }

    @Override
    protected void beforeRun() throws AnalysisException {
        this.checkDimensionNecessity();
    }

    @Override
    protected void initFilter(List<AnalyticalField> dimensionFields, List<AnalyticalField> measureFields) throws AnalysisException {
        this.pretreatParentChildDimensionFilter(dimensionFields);
    }

    @Override
    protected void initFilterPreparedValueGainer(AbstractEngine engine) {
    }

    @Override
    protected void applyAdditionalMeasure(List<AnalyticalField> measureFields) {
        AbstractChartProperty property = this.getModel().getChartModel().getChartProperty();
        if (property instanceof AbstractChartProperty.IAdditionalMeasureProvider) {
            final Map<String, MetaField> metaFields = this.getModel().getMeta().createSearchingMap();
            ((AbstractChartProperty.IAdditionalMeasureProvider)((Object)property)).confirmAdditionalMeasure(measureFields, new AbstractChartProperty.IAdditionalMeasureProvider.IMetaFieldSearcher(){

                @Override
                public MetaField search(String fullName) {
                    MetaField metaField = (MetaField)metaFields.get(fullName);
                    if (metaField == null) {
                        EngineRunner.this.getMultiInfoWrapper().getLostMetaFields().add(fullName);
                    } else if (metaField.isInvalid()) {
                        EngineRunner.this.getMultiInfoWrapper().getInvalidMetaFields().add(metaField.getFullDisplayName());
                        metaField = null;
                    }
                    return metaField;
                }
            });
        }
    }

    @Override
    protected DataSourceTraversal createDataSourceTraversal() {
        DataSourceTraversal dataSourceTraversal = super.createDataSourceTraversal();
        if (this._pushdownFilters != null) {
            dataSourceTraversal.addPushdownFilters(this._pushdownFilters);
        }
        return dataSourceTraversal;
    }

    private void checkDimensionNecessity() throws NecesaryDimensionMissingException {
        Collection<String> rootRepresentedParentIdFieldNames;
        final Map<String, MetaField> allMetaFields = this.getModel().getMeta().createSearchingMap();
        final HashSet<MetaField> mfs = new HashSet<MetaField>();
        this.getModel().getChartModel().visitAllFields(new AbstractChart.AbstractFieldVisitor(){

            @Override
            public boolean visit(AnalyticalField field) {
                EngineRunner.this.collectUsedMetaField(allMetaFields, field.getMetaField(), mfs);
                return false;
            }
        });
        if (this.getModel().getFilters() != null) {
            for (FilterItem item : this.getModel().getFilters()) {
                MetaField mf = item.getField().getMetaField();
                this.collectUsedMetaField(allMetaFields, mf, mfs);
            }
        }
        if ((rootRepresentedParentIdFieldNames = this.getModel().getMeta().checkNecessaryDimension(mfs)) != null) {
            Map<String, MetaField> metaFields = this.getModel().getMeta().createSearchingMap();
            for (String name : rootRepresentedParentIdFieldNames) {
                AnalyticalField field = new AnalyticalField();
                field.setName(name);
                field.setRole("dimension");
                field.bindMetaField(metaFields.get(name));
                DiscreteFilter filter = new DiscreteFilter();
                filter.setSelecteds(Arrays.asList(new String[]{null}));
                RuntimePushdownFilter runtimeFilter = AbstractRuntimeFilter.createDiscreteRuntimePushdownFilter(field, filter);
                if (this._pushdownFilters == null) {
                    this._pushdownFilters = new ArrayList<AbstractRuntimeFilter.IRuntimePushdownFilter>();
                }
                this._pushdownFilters.add(runtimeFilter);
            }
        }
    }

    private void collectUsedMetaField(Map<String, MetaField> allMetaFields, MetaField mf, Set<MetaField> mfs) {
        Set<String> dependence;
        mfs.add(mf);
        if (mf.isValidCalculation() && (dependence = mf.getAllDependence()) != null) {
            for (String fullName : dependence) {
                mfs.add(allMetaFields.get(fullName));
            }
        }
    }

    private void pretreatParentChildDimensionFilter(List<AnalyticalField> dimensionFields) throws AnalysisException {
        List<FilterItem> filterItems = this.getModel().getFilters();
        if (filterItems != null && !filterItems.isEmpty()) {
            ParentChildDimensionFilterPretreater pretreater = new ParentChildDimensionFilterPretreater();
            pretreater.pretreat(this.getModel(), dimensionFields, this.getDataSourceVisitor());
        }
    }
}

