/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine.runner.square;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.DataSourceGreenChannel;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.runner.square.AbstractEngineRunnerForFilterPreparedValue;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.DataTraversalException;
import com.kingdee.bos.qing.core.exception.FormulaExecutingException;
import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EngineRunnerForFilterPreparedValue
extends AbstractEngineRunnerForFilterPreparedValue {
    public EngineRunnerForFilterPreparedValue(IDataSourceVisitor dataSourceVisitor, SquareModel model, II18nContext ctx) {
        this(dataSourceVisitor, model, null, ctx);
    }

    public EngineRunnerForFilterPreparedValue(IDataSourceVisitor dataSourceVisitor, SquareModel model, AnalyticalField field, II18nContext ctx) {
        super(dataSourceVisitor, EngineRunnerForFilterPreparedValue.cloneAndRemoveFilterFromModel(model), ctx);
        this.getModel().setFilters(null);
        if (field == null) {
            this.setTargetFilterFields(this.getFilterFields());
        } else {
            this.setTargetFilterField(field);
        }
    }

    private static SquareModel cloneAndRemoveFilterFromModel(SquareModel model) {
        SquareModel noFilterModel = model.copy();
        noFilterModel.setFilters(null);
        return noFilterModel;
    }

    @Override
    protected void initFilter(List<AnalyticalField> dimensionFields, List<AnalyticalField> measureFields) {
        this.applyAppointedFilterFieldToMeasuresSafely(dimensionFields, measureFields);
    }

    @Override
    protected void initGainers(AbstractEngine engine, List<FilterPreparedValueGainer.AbstractPreparedValueGainer> gainers) throws AnalysisException {
        ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer> quick = null;
        ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer> slow = null;
        for (FilterPreparedValueGainer.AbstractPreparedValueGainer gainer : gainers) {
            if (gainer.isCanPullDown()) {
                if (quick == null) {
                    quick = new ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer>();
                }
                quick.add(gainer);
                continue;
            }
            if (slow == null) {
                slow = new ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer>();
            }
            slow.add(gainer);
        }
        engine.setFilterPreparedValueGainer(slow);
        if (quick != null) {
            this.pullDown(quick);
        }
    }

    private void pullDown(List<FilterPreparedValueGainer.AbstractPreparedValueGainer> gainers) throws DataTraversalException, UserStoppedException {
        DataSourceGreenChannel greenChannel = new DataSourceGreenChannel(this.getDataSourceVisitor());
        for (final FilterPreparedValueGainer.AbstractPreparedValueGainer gainer : gainers) {
            AnalyticalField analyticalField = gainer.getField();
            DataSourceGreenChannel.AbstractValueCollecter valueCollecter = new DataSourceGreenChannel.AbstractValueCollecter(){

                @Override
                public void accept(Map<String, Object> values) {
                    Object value;
                    try {
                        value = gainer.getDataGetter(null).getData(values);
                    }
                    catch (FormulaExecutingException e) {
                        value = null;
                    }
                    gainer.gain(value);
                }
            };
            try {
                greenChannel.getDistinctValue(analyticalField, valueCollecter);
            }
            catch (AbstractDataSourceException e) {
                throw DataTraversalException.createGetDistinctError((Exception)((Object)e));
            }
        }
    }
}

