/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine.sort;

import com.kingdee.bos.qing.core.engine.SortableCompositeMember;
import com.kingdee.bos.qing.core.i18n.sort.LocaleComparer;
import java.util.Comparator;
import java.util.Locale;

public class CommonComparator
implements Comparator<Comparable<?>> {
    private boolean _isEmptyAhead = false;
    private LocaleComparer _localeComparer;
    private boolean _isReversedEnabled;

    public CommonComparator(Locale locale) {
        this._localeComparer = LocaleComparer.create(locale);
    }

    public void setEmptyAheadAlways(boolean isEmptyAhead) {
        this._isEmptyAhead = isEmptyAhead;
    }

    protected Comparable<?> getComparingValue(Comparable<?> o) {
        return o;
    }

    @Override
    public int compare(Comparable<?> o1, Comparable<?> o2) {
        o1 = this.getComparingValue(o1);
        o2 = this.getComparingValue(o2);
        this._isReversedEnabled = true;
        boolean isO1Empty = this.isValueEmpty(o1);
        boolean isO2Empty = this.isValueEmpty(o2);
        if (isO1Empty && isO2Empty) {
            return 0;
        }
        if (isO1Empty) {
            this._isReversedEnabled = false;
            return this._isEmptyAhead ? -1 : 1;
        }
        if (isO2Empty) {
            this._isReversedEnabled = false;
            return this._isEmptyAhead ? 1 : -1;
        }
        if (o1 instanceof String && o2 instanceof String) {
            return this._localeComparer.compare(o1, o2);
        }
        if (o1 instanceof SortableCompositeMember && o2 instanceof SortableCompositeMember) {
            Object v1 = ((SortableCompositeMember)o1).getSortAccordingValue();
            Object v2 = ((SortableCompositeMember)o2).getSortAccordingValue();
            boolean isV1Int = v1 instanceof Integer;
            boolean isV2Int = v2 instanceof Integer;
            if (isV1Int && isV2Int) {
                return ((Integer)v1).compareTo((Integer)v2);
            }
            if (isV1Int) {
                return -1;
            }
            if (isV2Int) {
                return 1;
            }
            boolean isV1Empty = this.isValueEmpty(v1);
            boolean isV2Empty = this.isValueEmpty(v2);
            if (isV1Empty && isV2Empty) {
                return 0;
            }
            if (isV1Empty) {
                this._isReversedEnabled = false;
                return this._isEmptyAhead ? -1 : 1;
            }
            if (isV2Empty) {
                this._isReversedEnabled = false;
                return this._isEmptyAhead ? 1 : -1;
            }
            if (v1 instanceof String && v2 instanceof String) {
                return this._localeComparer.compare(v1, v2);
            }
            return ((Comparable)v1).compareTo((Comparable)v2);
        }
        return o1.compareTo(o2);
    }

    public boolean isReversedEnabled() {
        return this._isReversedEnabled;
    }

    private boolean isValueEmpty(Object value) {
        return value == null || "".equals(value);
    }
}

