/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.exception;

import com.kingdee.bos.qing.core.exception.AnalysisException;

public class EnvCeilingException
extends AnalysisException {
    private static final long serialVersionUID = -1075108630606309306L;
    private static final int RequestDenied = 1;
    private static final int Abort = 2;
    private static final int NoCapacity = 3;
    private int _key;
    private long _needByte;
    private long _allByte;

    private EnvCeilingException(int key) {
        super(205400 + key);
        this._key = key;
    }

    public static EnvCeilingException createRequestDenied(long needByte) {
        EnvCeilingException ex = new EnvCeilingException(1);
        ex._needByte = needByte;
        return ex;
    }

    public static EnvCeilingException createAbort(long needByte) {
        EnvCeilingException ex = new EnvCeilingException(2);
        ex._needByte = needByte;
        return ex;
    }

    public static EnvCeilingException createNoCapacity(long needByte, long allByte) {
        EnvCeilingException ex = new EnvCeilingException(3);
        ex._needByte = needByte;
        ex._allByte = allByte;
        return ex;
    }

    public String getMessage() {
        String message = null;
        switch (this._key) {
            case 1: {
                message = "Not enough reserved memory to start.";
                break;
            }
            case 2: {
                message = "Not enough reserved memory to go on.";
                break;
            }
            case 3: {
                message = "Total reserved memory is " + this._allByte + " bytes. ";
            }
        }
        message = message + " " + this._needByte + " bytes are needed.";
        return message;
    }
}

