/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.longer;

import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.MarkFieldSet;
import com.kingdee.bos.qing.core.model.exhibition.longer.DrawInfo;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractMarkParser {
    private MarkFieldSet _markFieldSet;
    private boolean[] _whichMeasureToDraw;

    AbstractMarkParser() {
    }

    public final void setModel(MarkFieldSet markFieldSet) {
        this._markFieldSet = markFieldSet;
    }

    protected final MarkFieldSet getModel() {
        return this._markFieldSet;
    }

    public String getSecondaryType() {
        return null;
    }

    public DrawInfo.Direction getDirection() {
        return null;
    }

    public final boolean[] getWhichMeasureToDraw() {
        return this._whichMeasureToDraw;
    }

    public final void parse(List<AnalyticalField> measureFields, int count) {
        this._whichMeasureToDraw = new boolean[count];
        if (measureFields.size() > 0) {
            this.confirmWhichMeasureToDraw(measureFields, this._whichMeasureToDraw);
        }
    }

    protected abstract void confirmWhichMeasureToDraw(List<AnalyticalField> var1, boolean[] var2);

    protected final int getDrawingMeasureCount() {
        boolean[] whichMeasureToDraw = this.getWhichMeasureToDraw();
        int drawingMeasureCount = 0;
        for (boolean value : whichMeasureToDraw) {
            if (!value) continue;
            ++drawingMeasureCount;
        }
        return drawingMeasureCount;
    }

    protected final int searchMarkAsDimension(String markType) {
        List<AnalyticalField> fields = this._markFieldSet.getFields();
        List<String> markTypes = this._markFieldSet.getMarkTypes();
        for (int i = 0; i < fields.size(); ++i) {
            String mt;
            AnalyticalField field = fields.get(i);
            if (field.getMetaField().isCalculation() && field.getMetaField().isInvalid() || !markType.equals(mt = markTypes.get(i)) || !field.isDimension()) continue;
            return i;
        }
        return -1;
    }

    protected final int searchMarkAsMeasure(String markType) {
        List<AnalyticalField> fields = this._markFieldSet.getFields();
        List<String> markTypes = this._markFieldSet.getMarkTypes();
        for (int i = 0; i < fields.size(); ++i) {
            String mt;
            AnalyticalField field = fields.get(i);
            if (field.getMetaField().isCalculation() && field.getMetaField().isInvalid() || !markType.equals(mt = markTypes.get(i)) || !field.isMeasure()) continue;
            return i;
        }
        return -1;
    }

    protected final List<AnalyticalField> searchAllMarkFieldAsMeasure(String markType) {
        ArrayList<AnalyticalField> result = new ArrayList<AnalyticalField>(3);
        List<AnalyticalField> fields = this._markFieldSet.getFields();
        List<String> markTypes = this._markFieldSet.getMarkTypes();
        for (int i = 0; i < fields.size(); ++i) {
            String mt;
            AnalyticalField field = fields.get(i);
            if (field.getMetaField().isCalculation() && field.getMetaField().isInvalid() || !markType.equals(mt = markTypes.get(i)) || !field.isMeasure()) continue;
            result.add(field);
        }
        return result;
    }

    protected static int getIndexAtMeasure(AnalyticalField field, List<AnalyticalField> measureFields) {
        int i;
        for (i = 0; i < measureFields.size(); ++i) {
            if (field != measureFields.get(i)) continue;
            return i;
        }
        for (i = 0; i < measureFields.size(); ++i) {
            if (!field.isSame(measureFields.get(i))) continue;
            return i;
        }
        return -1;
    }
}

