/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.longer;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.SubCuboidKey;
import com.kingdee.bos.qing.core.exception.EnvCeilingException;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilderForLineSimilar;
import com.kingdee.bos.qing.core.flattening.longer.AbstractMarkParser;
import com.kingdee.bos.qing.core.flattening.longer.CuboidSpliter;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.ModelAssistantStructure;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.ChartCell;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FlatBuilderForLine
extends AbstractFlatBuilderForLineSimilar {
    private CuboidSpliter _cuboidSpliter;
    private Scope _unifiedAxisScope = new Scope();
    private int _estimatedHeapSizePerCell;

    @Override
    protected AbstractMarkParser createMarkParser() {
        return new MarkParserForLine();
    }

    @Override
    protected void beforeFlatCuboid() {
        this._cuboidSpliter = this.createCuboidSpliter();
        ModelAssistantStructure mas = this.getModelAssistantStructure();
        int m = mas.getCellDimensionFieldCount();
        this.setCategoryField(m > 0 ? mas.getCellDimensionFields().get(0) : null);
    }

    @Override
    protected Iterator<CompositeKey> prepareIteratorForFlatCuboid(Cuboid cuboid, SubCuboidKey subCuboidTag) throws EnvCeilingException {
        this._cuboidSpliter.standardizingCuboid(cuboid, subCuboidTag, new CuboidSpliter.AbstractDoMoreHandler(){

            @Override
            public void forDimension(CompositeKey dimKeyInCell) {
                Object categoryValue = FlatBuilderForLine.this.getCategoryValue(dimKeyInCell);
                FlatBuilderForLine.this.collectCategory(categoryValue);
            }

            @Override
            public void forMeasure(int measureIndex, Aggregator aggregator) {
                BigDecimal measureValue = aggregator.getNumberValue();
                FlatBuilderForLine.this._unifiedAxisScope.join(measureValue);
            }
        });
        int displayMeasureCount = this.getModelAssistantStructure().getMeasureFieldCountForCell();
        this._estimatedHeapSizePerCell = ChartCell.HEAPZISE_OVERHEAD + MultiSeriesChartModel.HEAPZISE_OVERHEAD + AbstractNormalChartModel.Series.HEAPZISE_OVERHEAD * displayMeasureCount + (AbstractNormalChartModel.Category.HEAPZISE_OVERHEAD + AbstractNormalChartModel.Node.HEAPZISE_OVERHEAD) * this.getCategorySize();
        return this._cuboidSpliter.getStandardizedCube(subCuboidTag).keySet().iterator();
    }

    @Override
    protected void flatCubeCell(SubCuboidKey subCuboidTag, boolean[] whichMeasureToDraw, CompositeKey dimKey) {
        AbstractFlatBuilder.GroupItem groupItem = this.createGroupItem(dimKey, subCuboidTag, 0);
        this.mapping(dimKey, groupItem, -1);
    }

    @Override
    protected void afterFlatCuboid() {
        this.makeSureDateContinuous();
        this.makeCommonChart();
    }

    @Override
    protected int getCellHeapSize() {
        return this._estimatedHeapSizePerCell;
    }

    @Override
    protected ICell createCell(AbstractFlatBuilder.GroupItem item) {
        MultiSeriesChartModel chart = new MultiSeriesChartModel();
        int categoryCount = this.getCategorySize();
        int displayMeasureCount = this.getModelAssistantStructure().getMeasureFieldCountForCell();
        for (int i = 0; i < displayMeasureCount; ++i) {
            String name = this.getMeasureTitle(i);
            AbstractNormalChartModel.Series series = chart.addSeries(name);
            for (int j = 0; j < categoryCount; ++j) {
                series.getNodes().add(j, null);
            }
        }
        Map<CompositeKey, Cuboid> rowColPartOfCuboid = this._cuboidSpliter.getStandardizedCube(item.getSubCuboidTag());
        CompositeKey dimKey = item.getDimensionKey();
        Cuboid cuboidInCell = rowColPartOfCuboid.get(dimKey);
        Iterator<CompositeKey> it = cuboidInCell.createDimensionKeyIterator();
        while (it.hasNext()) {
            CompositeKey dimKeyInCell = it.next();
            Object categoryValue = this.getCategoryValue(dimKeyInCell);
            int categoryIndex = this.getCategoryIndex(categoryValue);
            Aggregator[] aggregators = cuboidInCell.getCellAggregators(dimKeyInCell);
            for (int i = 0; i < displayMeasureCount; ++i) {
                Aggregator aggregator = aggregators[i];
                BigDecimal measureValue = aggregator.getNumberValue();
                AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
                node.setValue(measureValue == null ? "" : measureValue.toString());
                node.setText(this.formatNumber(measureValue, this.getModelAssistantStructure().getMeasureField(i)));
                AbstractNormalChartModel.Series series = chart.getSeries(i);
                series.getNodes().set(categoryIndex, node);
            }
        }
        this.cutTooLargeChart(chart);
        ChartCell cell = new ChartCell();
        cell.setChart(chart);
        return cell;
    }

    @Override
    protected void makeRedundance() {
        MultiSeriesChartModel commonChart = this.getCommonChart();
        commonChart.addValueScope(this._unifiedAxisScope.getMin().toString(), this._unifiedAxisScope.getMax().toString());
        int seriesCount = this.getModelAssistantStructure().getMeasureFieldCountForAxis();
        if (seriesCount > 1) {
            for (int i = 0; i < seriesCount; ++i) {
                String name = this.getMeasureTitle(i);
                AbstractNormalChartModel.Series series = commonChart.addSeries(name);
                series.setOrderingValue(i);
                series.setColor(this.makeDiscreteColorValue(series, name));
            }
        } else {
            AbstractNormalChartModel.Series series = commonChart.addSeries(null);
            if (seriesCount > 0) {
                series.setFormatString(this.getModelAssistantStructure().getMeasureField(0).getUsableNumberFormat());
                series.setColor(this.getDefaultColorValue());
            }
        }
        ChartCell cell = new ChartCell();
        cell.setChart(commonChart);
        this.getTableView().setCommonCell(cell);
    }

    @Override
    protected AnalyticalField getColorField() {
        return null;
    }

    private static class MarkParserForLine
    extends AbstractMarkParser {
        private MarkParserForLine() {
        }

        @Override
        protected void confirmWhichMeasureToDraw(List<AnalyticalField> measureFields, boolean[] whichMeasureToDraw) {
            for (int i = 0; i < whichMeasureToDraw.length; ++i) {
                whichMeasureToDraw[i] = true;
            }
        }
    }
}

