/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.longer;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.SubCuboidKey;
import com.kingdee.bos.qing.core.exception.EnvCeilingException;
import com.kingdee.bos.qing.core.flattening.common.Palette;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilderForLineSimilar;
import com.kingdee.bos.qing.core.flattening.longer.AbstractMarkParser;
import com.kingdee.bos.qing.core.flattening.longer.CuboidSpliter;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.ModelAssistantStructure;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.ChartCell;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlatBuilderForMultiLine
extends AbstractFlatBuilderForLineSimilar {
    private CuboidSpliter _cuboidSpliter;
    private Scope _unifiedAxisScope = new Scope();
    private Set<Object> _seriesCollection = new HashSet<Object>();
    private int _estimatedHeapSizePerCell;

    @Override
    protected AbstractMarkParser createMarkParser() {
        return new MarkParserForMultiLine();
    }

    private MarkParserForMultiLine getMyMarkParser() {
        return (MarkParserForMultiLine)this.getMarkParser();
    }

    @Override
    protected Palette.PaletteType getPaletteType() {
        return Palette.PaletteType.CONTRASTING_LINE;
    }

    @Override
    protected void beforeFlatCuboid() {
        this._cuboidSpliter = this.createCuboidSpliter();
        ModelAssistantStructure mas = this.getModelAssistantStructure();
        int m = mas.getCellDimensionFieldCount();
        if (this.getMyMarkParser().hasColorField()) {
            this.setCategoryField(m > 1 ? mas.getCellDimensionFields().get(0) : null);
        } else {
            this.setCategoryField(m > 0 ? mas.getCellDimensionFields().get(0) : null);
        }
    }

    @Override
    protected Iterator<CompositeKey> prepareIteratorForFlatCuboid(Cuboid cuboid, SubCuboidKey subCuboidTag) throws EnvCeilingException {
        this._cuboidSpliter.standardizingCuboid(cuboid, subCuboidTag, new CuboidSpliter.AbstractDoMoreHandler(){

            @Override
            public void forDimension(CompositeKey dimKeyInCell) {
                Object categoryValue = FlatBuilderForMultiLine.this.getCategoryValue(dimKeyInCell);
                FlatBuilderForMultiLine.this.collectCategory(categoryValue);
                if (FlatBuilderForMultiLine.this.getMyMarkParser().hasColorField()) {
                    Object value = dimKeyInCell.getMember(dimKeyInCell.getMemberCount() - 1);
                    FlatBuilderForMultiLine.this._seriesCollection.add(value);
                }
            }

            @Override
            public void forMeasure(int measureIndex, Aggregator aggregator) {
                BigDecimal measureValue = aggregator.getNumberValue();
                FlatBuilderForMultiLine.this._unifiedAxisScope.join(measureValue);
            }
        });
        int displayMeasureCount = this.getModelAssistantStructure().getMeasureFieldCountForCell();
        int categoryCount = this.getCategorySize();
        this._estimatedHeapSizePerCell = ChartCell.HEAPZISE_OVERHEAD + MultiSeriesChartModel.HEAPZISE_OVERHEAD + AbstractNormalChartModel.Series.HEAPZISE_OVERHEAD * displayMeasureCount + AbstractNormalChartModel.Category.HEAPZISE_OVERHEAD * categoryCount + AbstractNormalChartModel.Node.HEAPZISE_OVERHEAD * displayMeasureCount * categoryCount;
        return this._cuboidSpliter.getStandardizedCube(subCuboidTag).keySet().iterator();
    }

    @Override
    protected void flatCubeCell(SubCuboidKey subCuboidTag, boolean[] whichMeasureToDraw, CompositeKey dimKey) {
        int measureIndex = this.getDrawingMeasureCount() == 1 ? 0 : -1;
        AbstractFlatBuilder.GroupItem groupItem = this.createGroupItem(dimKey, subCuboidTag, measureIndex);
        this.mapping(dimKey, groupItem, -1);
    }

    @Override
    protected void afterFlatCuboid() {
        this.makeSureDateContinuous();
        this.makeCommonChart();
        this.addAllSeriesColors();
        if (this.getMyMarkParser().hasColorField()) {
            this.confirmDiscreteColorLegendTitlebyField(this.getMyMarkParser().getColorField());
        } else if (this.getModelAssistantStructure().getMeasureFieldCountForCell() > 1) {
            this.confirmDiscreteColorLegendTitlebyField(null);
        }
    }

    private void addAllSeriesColors() {
        List<AbstractChartModel.IOrderingSupported> sortedList = AbstractChartModel.toOrderedWrapList(this._seriesCollection, this.getI18nCtx().getLanManager().getLocale());
        for (AbstractChartModel.IOrderingSupported seriesValue : sortedList) {
            String seriesName = this.formatValue(seriesValue.getOrderingValue(), this.getMyMarkParser().getColorField());
            this.makeDiscreteColorValue(seriesValue, seriesName);
        }
    }

    @Override
    protected int getCellHeapSize() {
        return this._estimatedHeapSizePerCell;
    }

    @Override
    protected ICell createCell(AbstractFlatBuilder.GroupItem item) {
        MultiSeriesChartModel chart = new MultiSeriesChartModel();
        int categoryCount = this.getCategorySize();
        Map<CompositeKey, Cuboid> rowColPartOfCuboid = this._cuboidSpliter.getStandardizedCube(item.getSubCuboidTag());
        CompositeKey dimKey = item.getDimensionKey();
        Cuboid cuboidInCell = rowColPartOfCuboid.get(dimKey);
        if (this.getMyMarkParser().hasColorField()) {
            boolean hasMeasure;
            Iterator<CompositeKey> it = cuboidInCell.createDimensionKeyIterator();
            ArrayList<Object> seriesFieldValueList = new ArrayList<Object>();
            boolean bl = hasMeasure = this.getModelAssistantStructure().getMeasureFieldCountForCell() > 0;
            while (it.hasNext()) {
                CompositeKey dimKeyInCell = it.next();
                Object seriesFieldValue = dimKeyInCell.getMember(dimKeyInCell.getMemberCount() - 1);
                int seriesIdx = seriesFieldValueList.indexOf(seriesFieldValue);
                if (seriesIdx < 0) {
                    seriesIdx = seriesFieldValueList.size();
                    seriesFieldValueList.add(seriesFieldValue);
                    String seriesFieldValueText = this.formatValue(seriesFieldValue, this.getMyMarkParser().getColorField());
                    String seriesName = hasMeasure ? this.getMeasureTitle(0) : null;
                    AbstractNormalChartModel.Series series = chart.addSeries(seriesName);
                    series.setSeriesFieldValueText(FlatBuilderForMultiLine.encodeCategoryValue(seriesFieldValue, seriesFieldValueText), seriesFieldValueText);
                    series.setOrderingValue(seriesFieldValue);
                    String color = this.makeDiscreteColorValue(series, seriesFieldValueText);
                    series.setColor(color);
                    for (int j = 0; j < categoryCount; ++j) {
                        series.getNodes().add(j, null);
                    }
                }
                Object categoryValue = this.getCategoryValue(dimKeyInCell);
                int categoryIndex = this.getCategoryIndex(categoryValue);
                Aggregator[] aggregators = cuboidInCell.getCellAggregators(dimKeyInCell);
                Aggregator aggregator = aggregators[0];
                BigDecimal measureValue = aggregator.getNumberValue();
                AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
                node.setValue(measureValue == null ? "" : measureValue.toString());
                node.setText(this.formatNumber(measureValue, this.getModelAssistantStructure().getMeasureField(0)));
                AbstractNormalChartModel.Series series = chart.getSeries(seriesIdx);
                series.getNodes().set(categoryIndex, node);
            }
        } else {
            int displayMeasureCount = this.getModelAssistantStructure().getMeasureFieldCountForCell();
            for (int i = 0; i < displayMeasureCount; ++i) {
                String name = this.getMeasureTitle(i);
                AbstractNormalChartModel.Series series = chart.addSeries(name);
                for (int j = 0; j < categoryCount; ++j) {
                    series.getNodes().add(j, null);
                }
            }
            Iterator<CompositeKey> it = cuboidInCell.createDimensionKeyIterator();
            while (it.hasNext()) {
                CompositeKey dimKeyInCell = it.next();
                Object categoryValue = this.getCategoryValue(dimKeyInCell);
                int categoryIndex = this.getCategoryIndex(categoryValue);
                Aggregator[] aggregators = cuboidInCell.getCellAggregators(dimKeyInCell);
                for (int i = 0; i < displayMeasureCount; ++i) {
                    Aggregator aggregator = aggregators[i];
                    BigDecimal measureValue = aggregator.getNumberValue();
                    AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
                    node.setValue(measureValue == null ? "" : measureValue.toString());
                    node.setText(this.formatNumber(measureValue, this.getModelAssistantStructure().getMeasureField(i)));
                    AbstractNormalChartModel.Series series = chart.getSeries(i);
                    series.getNodes().set(categoryIndex, node);
                }
            }
        }
        this.cutTooLargeChart(chart);
        ChartCell cell = new ChartCell();
        cell.setChart(chart);
        return cell;
    }

    @Override
    protected void makeRedundance() {
        MultiSeriesChartModel commonChart = this.getCommonChart();
        commonChart.addValueScope(this._unifiedAxisScope.getMin().toString(), this._unifiedAxisScope.getMax().toString());
        int seriesCount = this.getModelAssistantStructure().getMeasureFieldCountForAxis();
        if (this.getMyMarkParser().hasColorField()) {
            AbstractNormalChartModel.Series series = commonChart.addSeries(null);
            if (seriesCount > 0) {
                series.setFormatString(this.getModelAssistantStructure().getMeasureField(0).getUsableNumberFormat());
            }
        } else if (seriesCount > 1) {
            for (int i = 0; i < seriesCount; ++i) {
                String name = this.getMeasureTitle(i);
                AbstractNormalChartModel.Series series = commonChart.addSeries(name);
                series.setOrderingValue(i);
                series.setColor(this.makeDiscreteColorValue(series, name));
                series.setFormatString(this.getModelAssistantStructure().getMeasureField(i).getUsableNumberFormat());
            }
        } else {
            AbstractNormalChartModel.Series series = commonChart.addSeries(null);
            if (seriesCount > 0) {
                series.setFormatString(this.getModelAssistantStructure().getMeasureField(0).getUsableNumberFormat());
                series.setColor(this.getDefaultColorValue());
            }
        }
        ChartCell cell = new ChartCell();
        cell.setChart(commonChart);
        this.getTableView().setCommonCell(cell);
    }

    @Override
    protected AnalyticalField getColorField() {
        return this.getMyMarkParser().getColorField();
    }

    private static class MarkParserForMultiLine
    extends AbstractMarkParser {
        private AnalyticalField _colorDimensionField;

        private MarkParserForMultiLine() {
        }

        public AnalyticalField getColorField() {
            return this._colorDimensionField;
        }

        public boolean hasColorField() {
            return this._colorDimensionField != null;
        }

        @Override
        protected void confirmWhichMeasureToDraw(List<AnalyticalField> measureFields, boolean[] whichMeasureToDraw) {
            int idx = this.searchMarkAsDimension("color");
            if (idx >= 0) {
                this._colorDimensionField = this.getModel().getFields().get(idx);
            }
            for (int i = 0; i < whichMeasureToDraw.length; ++i) {
                whichMeasureToDraw[i] = true;
            }
        }
    }
}

