/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.longer;

import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.exhibition.common.Legends;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

class RatioConfirmer {
    private AnalyticalField _analyticalField;
    private BigDecimal _min;
    private BigDecimal _max;
    private BigDecimal _distance;
    private List<BigDecimal> _segmentedValues;
    private List<BigDecimal> _segmentedRatios;

    public RatioConfirmer(BigDecimal min, BigDecimal max) {
        this._min = min;
        if (min.compareTo(max) == 0) {
            this._distance = null;
        } else {
            this._max = max;
            this._distance = max.subtract(min);
            this.confirmSegment();
        }
    }

    public void setAnalyticalField(AnalyticalField analyticalField) {
        this._analyticalField = analyticalField;
    }

    public AnalyticalField getAnalyticalField() {
        return this._analyticalField;
    }

    public BigDecimal getRatio(BigDecimal value) {
        if (this._distance == null) {
            return BigDecimal.ONE;
        }
        for (int i = this._segmentedValues.size() - 1; i >= 0; --i) {
            if (value.compareTo(this._segmentedValues.get(i)) < 0) continue;
            return this._segmentedRatios.get(i);
        }
        throw new RuntimeException("The value must be more than the _min.  value is:" + value + "  _min is:" + this._min);
    }

    public Legends.SizeLegend createLegend() {
        Legends.SizeLegend legend = new Legends.SizeLegend();
        return legend;
    }

    public int getSegmentCount() {
        return this._distance == null ? 1 : this._segmentedRatios.size();
    }

    public BigDecimal getSegmentedValue(int idx) {
        return this._distance == null ? this._min : this._segmentedValues.get(idx);
    }

    public BigDecimal getSegmentedRatio(int idx) {
        return this._distance == null ? BigDecimal.ONE : this._segmentedRatios.get(idx);
    }

    private void confirmSegment() {
        BigDecimal ratioDistance;
        BigDecimal ratioStart;
        BigDecimal sectionLength;
        BigDecimal startLine;
        int base;
        int[] head = this.parseDistance(this._distance);
        int head2Digit = head[0];
        int times = head[1];
        if (head2Digit >= 30 && head2Digit < 60) {
            base = 1;
        } else if (head2Digit >= 11 && head2Digit < 30) {
            BigDecimal moreDistance;
            base = 5;
            if (head2Digit < 15 && this.parseDistance(moreDistance = this._max.subtract(startLine = this.calculateSectionLine(this._min, sectionLength = this.calculateSectionLength(base, --times))))[0] < 15) {
                base = 2;
            }
        } else {
            base = 2;
            times = head2Digit == 10 ? times - 1 : times;
        }
        sectionLength = this.calculateSectionLength(base, times);
        startLine = this.calculateSectionLine(this._min, sectionLength);
        BigDecimal endLine = this.calculateSectionLine(this._max, sectionLength);
        BigDecimal count = endLine.subtract(startLine).divide(sectionLength, 0, RoundingMode.UNNECESSARY);
        if (count.intValue() < 5) {
            ratioStart = new BigDecimal("0.25");
            ratioDistance = new BigDecimal("0.75");
        } else {
            ratioStart = new BigDecimal("0.15");
            ratioDistance = new BigDecimal("0.85");
        }
        BigDecimal ratioSectionLength = ratioDistance.divide(count, 4, RoundingMode.DOWN);
        BigDecimal value = startLine;
        BigDecimal ratio = ratioStart;
        MathContext ratioContext = new MathContext(2, RoundingMode.HALF_DOWN);
        this._segmentedValues = new ArrayList<BigDecimal>(count.intValue() + 1);
        this._segmentedRatios = new ArrayList<BigDecimal>(count.intValue() + 1);
        int c = count.intValue() + 1;
        for (int i = 0; i < c; ++i) {
            this._segmentedValues.add(value);
            this._segmentedRatios.add(ratio);
            value = value.add(sectionLength);
            ratio = ratioStart.add(ratioSectionLength.multiply(new BigDecimal(i + 1), ratioContext));
        }
    }

    private BigDecimal calculateSectionLine(BigDecimal value, BigDecimal sectionLength) {
        return value.divide(sectionLength, 0, RoundingMode.FLOOR).multiply(sectionLength);
    }

    private BigDecimal calculateSectionLength(int base, int times) {
        if (times < 0) {
            return new BigDecimal(base).multiply(BigDecimal.TEN.pow(times, new MathContext(-times, RoundingMode.HALF_UP)));
        }
        return new BigDecimal(base).multiply(BigDecimal.TEN.pow(times));
    }

    private int[] parseDistance(BigDecimal distance) {
        String text = distance.unscaledValue().toString();
        int txtLen = text.length();
        int bdScale = distance.scale();
        int times = txtLen - bdScale - 1;
        text = txtLen == 1 ? text.substring(0, 1) + "0" : text.substring(0, 2);
        int head2Digit = Integer.parseInt(text);
        return new int[]{head2Digit, times};
    }
}

