/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractFunctionExpr;
import com.kingdee.bos.qing.common.grammar.expr.AbstractOpExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.expr.VariantExpr;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.sort.CommonComparator;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.common.ExecutableValueCoder;
import com.kingdee.bos.qing.core.flattening.common.StyleStorage;
import com.kingdee.bos.qing.core.flattening.common.func.AbstractAssistedExecutableFunction;
import com.kingdee.bos.qing.core.flattening.common.func.AbstractConditionStyleExecuteContext;
import com.kingdee.bos.qing.core.flattening.common.sort.AbstractSortProcessor;
import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.AbstractListChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.Style;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.square.GridChartModel;
import com.kingdee.bos.qing.util.LogUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

abstract class AbstractSimilarListMaker
extends AbstractSquareViewMaker {
    protected static final String ALIGN_RIGHT = "right";
    private StyleStorage _styleStorage;
    private List<IExpr> _exprsForColumn;
    private List<IExpr> _exprsForRow;
    private List<IExpr> _exprsForCell;
    private ScriptExecuteContext _scriptExecuteContext;

    AbstractSimilarListMaker() {
    }

    @Override
    protected final AbstractChartModel makeChart() throws AnalysisException {
        this.divideStyleScripts();
        GridChartModel chart = new GridChartModel();
        this.makeColumns(chart);
        this.runColumnScript(chart);
        this.makeRows(chart);
        this.makeHeaderFooter(chart);
        this.postMake(chart);
        if (this._styleStorage != null) {
            chart.setStyles(this._styleStorage.access());
        }
        return chart;
    }

    protected abstract FieldSet getFieldSet();

    protected abstract int getColumnNumberOffset();

    protected abstract void makeColumns(GridChartModel var1);

    protected abstract void makeOneRow(int var1, GridChartModel.Row var2, CompositeKey var3);

    protected abstract void makeHeaderFooter(GridChartModel var1);

    protected abstract void postMake(GridChartModel var1);

    protected final StyleStorage getStyleStorage() {
        if (this._styleStorage == null) {
            this._styleStorage = new StyleStorage();
        }
        return this._styleStorage;
    }

    protected final Integer mergeStoreStyle(Integer styleIndex, String key, Object value) {
        Style style = this.readStyle(styleIndex);
        style.set(key, value);
        return this.writeStyle(style);
    }

    protected final Integer mergeStoreStyle(Integer styleIndex, Map<String, Object> kv) {
        Style style = this.readStyle(styleIndex);
        for (Map.Entry<String, Object> each : kv.entrySet()) {
            style.set(each.getKey(), each.getValue());
        }
        return this.writeStyle(style);
    }

    private Style readStyle(Integer styleIndex) {
        Style style = this.getStyleStorage().access(styleIndex);
        style = style == null ? new Style() : style.copy();
        return style;
    }

    private Integer writeStyle(Style style) {
        Integer idx = this.getStyleStorage().store(style);
        return idx;
    }

    protected final void addLinkageKeywordValueToRow(GridChartModel.Row row, Object member, String label) {
        String encoded = ExecutableValueCoder.dimemsionMemberToJsonString(member, label);
        row.addLinkageKeywordValue(encoded == null ? label : encoded);
    }

    protected final void setAffectionSrcToRow(GridChartModel.Row row, Object member, String label) {
        String encoded = ExecutableValueCoder.dimemsionMemberToJsonString(member, label);
        String value = encoded == null ? label : encoded;
        String text = encoded == null ? null : label;
        row.setAffectionSrc(value, text);
    }

    private AbstractListChartProperty getDesignProperty() {
        return (AbstractListChartProperty)this.getModel().getChartModel().getChartProperty();
    }

    private void makeRows(GridChartModel chart) throws AnalysisException {
        int itemCountLimit = this.getDesignProperty().getTopN() <= 0 ? 999 : this.getDesignProperty().getTopN();
        MySortProcessor sortProcessor = new MySortProcessor();
        sortProcessor.setTopN(itemCountLimit);
        sortProcessor.setOthersAsAnItem(false);
        sortProcessor.setAscendent(this.getDesignProperty().isAscendent());
        sortProcessor.sortAndTopN(this.getCuboid(), AbstractSortProcessor.CuboidShell.copyShellFrom(this.getCuboid()));
        List<GridChartModel.Column> columns = chart.getColumns();
        Map<Integer, CompositeKey> sortedMap = sortProcessor.getSortedSearcher();
        int c = sortedMap.size();
        for (int i = 0; i < c; ++i) {
            CompositeKey dimKey = sortedMap.get(i);
            int rowNum = i + 1;
            GridChartModel.Row row = chart.addOneRow();
            this.makeOneRow(rowNum, row, dimKey);
            this.runRowScript(rowNum, row, columns);
            this.runCellScript(rowNum, row, columns);
        }
    }

    private void runColumnScript(GridChartModel chart) {
        if (this._exprsForColumn != null) {
            List<GridChartModel.Column> columns = chart.getColumns();
            for (int colIdx = 0; colIdx < columns.size(); ++colIdx) {
                this.getScriptExecuteContext().setContext(columns, colIdx);
                for (int i = 0; i < this._exprsForColumn.size(); ++i) {
                    IExpr expr = this._exprsForColumn.get(i);
                    this.runExpr(expr);
                }
            }
        }
    }

    private void runRowScript(int rowNum, GridChartModel.Row row, List<GridChartModel.Column> columns) {
        if (this._exprsForRow != null) {
            this.getScriptExecuteContext().setContext(rowNum, row, columns);
            for (int i = 0; i < this._exprsForRow.size(); ++i) {
                IExpr expr = this._exprsForRow.get(i);
                this.runExpr(expr);
            }
        }
    }

    private void runCellScript(int rowNum, GridChartModel.Row row, List<GridChartModel.Column> columns) {
        if (this._exprsForCell != null) {
            int c = columns.size();
            for (int j = 0; j < c; ++j) {
                this.getScriptExecuteContext().setContext(rowNum, row, columns, j);
                for (int i = 0; i < this._exprsForCell.size(); ++i) {
                    IExpr expr = this._exprsForCell.get(i);
                    this.runExpr(expr);
                }
            }
        }
    }

    private void runExpr(IExpr expr) {
        try {
            expr.execute((IExecuteContext)this.getScriptExecuteContext());
        }
        catch (ExecuteException ex) {
            LogUtil.debug((String)"Execute style-script error.", (Throwable)ex);
        }
    }

    private ScriptExecuteContext getScriptExecuteContext() {
        if (this._scriptExecuteContext == null) {
            this._scriptExecuteContext = new ScriptExecuteContext();
            this._scriptExecuteContext.setI18nContext(this.getI18nContext());
        }
        return this._scriptExecuteContext;
    }

    private void divideStyleScripts() {
        List<IExpr> exprs = this.getDesignProperty().getStyleExprs();
        if (exprs == null) {
            return;
        }
        block0: for (int i = 0; i < exprs.size(); ++i) {
            IExpr expr = exprs.get(i);
            LinkedList<IExpr> queue = new LinkedList<IExpr>();
            queue.add(expr);
            while (!queue.isEmpty()) {
                IExpr one = (IExpr)queue.remove(0);
                if (one instanceof AbstractFunctionExpr) {
                    String functionName = ((AbstractFunctionExpr)one).getName();
                    if ("setColumn".equalsIgnoreCase(functionName)) {
                        this.getExprsForColumn().add(expr);
                        continue block0;
                    }
                    if ("setRow".equalsIgnoreCase(functionName)) {
                        this.getExprsForRow().add(expr);
                        continue block0;
                    }
                    if ("setCell".equalsIgnoreCase(functionName)) {
                        this.getExprsForCell().add(expr);
                        continue block0;
                    }
                }
                if (!(one instanceof AbstractOpExpr)) continue;
                IExpr[] subs = ((AbstractOpExpr)one).getSubExprs();
                for (int k = 0; k < subs.length; ++k) {
                    queue.add(subs[k]);
                }
            }
        }
    }

    private List<IExpr> getExprsForColumn() {
        if (this._exprsForColumn == null) {
            this._exprsForColumn = new ArrayList<IExpr>();
        }
        return this._exprsForColumn;
    }

    private List<IExpr> getExprsForRow() {
        if (this._exprsForRow == null) {
            this._exprsForRow = new ArrayList<IExpr>();
        }
        return this._exprsForRow;
    }

    private List<IExpr> getExprsForCell() {
        if (this._exprsForCell == null) {
            this._exprsForCell = new ArrayList<IExpr>();
        }
        return this._exprsForCell;
    }

    private class ScriptExecuteContext
    extends AbstractConditionStyleExecuteContext {
        private int _rowNum;
        private GridChartModel.Row _currentRow;
        private List<GridChartModel.Column> _columns;
        private List<GridChartModel.Cell> _cells;
        private int _currentColIdx;

        private ScriptExecuteContext() {
        }

        public void setContext(List<GridChartModel.Column> columns, int columnIndex) {
            this.setContext(0, null, columns, columnIndex);
        }

        public void setContext(int rowNum, GridChartModel.Row row, List<GridChartModel.Column> columns) {
            this.setContext(rowNum, row, columns, 0);
        }

        public void setContext(int rowNum, GridChartModel.Row row, List<GridChartModel.Column> columns, int columnIndex) {
            this._rowNum = rowNum;
            this._currentRow = row;
            this._columns = columns;
            this._cells = row == null ? null : row.getCells();
            this._currentColIdx = columnIndex;
        }

        private GridChartModel.Column getCurrentColumn() {
            return this._columns.get(this._currentColIdx);
        }

        private GridChartModel.Cell getCurrentCell() {
            return this._cells == null ? null : this._cells.get(this._currentColIdx);
        }

        private GridChartModel.Cell searchCell(String columnName) {
            for (int i = this._columns.size() - 1; i >= 0; --i) {
                if (!this._columns.get(i).getTitle().equalsIgnoreCase(columnName)) continue;
                return this._cells == null ? null : this._cells.get(i);
            }
            return null;
        }

        public Object getValue(IExpr expr) throws ExecuteException {
            AbstractAssistedExecutableFunction func;
            String name;
            if (expr instanceof VariantExpr) {
                String name2 = ((VariantExpr)expr).getName();
                if ("ROW_NUM".equalsIgnoreCase(name2)) {
                    return new BigDecimal(this._rowNum);
                }
                if ("COLUMN_NUM".equalsIgnoreCase(name2)) {
                    int num = this._currentColIdx + 1 + AbstractSimilarListMaker.this.getColumnNumberOffset();
                    return new BigDecimal(num);
                }
                if ("COLUMN_NAME".equalsIgnoreCase(name2)) {
                    return this.getCurrentColumn().getTitle();
                }
                if ("VALUE".equalsIgnoreCase(name2)) {
                    GridChartModel.Cell cell = this.getCurrentCell();
                    return cell == null ? null : cell.getValue();
                }
            } else if (expr instanceof AbstractAssistedExecutableFunction && "getValue".equalsIgnoreCase(name = (func = (AbstractAssistedExecutableFunction)expr).getName())) {
                String columnName = func.getStringParamValue(0, (IExecuteContext)this);
                GridChartModel.Cell cell = this.searchCell(columnName);
                return cell == null ? null : cell.getValue();
            }
            return null;
        }

        @Override
        public Object getHost(AbstractFunctionExpr expr) {
            String functionName = expr.getName();
            if ("setColumn".equalsIgnoreCase(functionName)) {
                return this.getCurrentColumn();
            }
            if ("setRow".equalsIgnoreCase(functionName)) {
                return this._currentRow;
            }
            if ("setCell".equalsIgnoreCase(functionName)) {
                return this.getCurrentCell();
            }
            return null;
        }

        @Override
        public StyleStorage getStyleStorage() {
            return AbstractSimilarListMaker.this.getStyleStorage();
        }
    }

    private class MySortProcessor
    extends AbstractSortProcessor {
        private Map<Integer, CompositeKey> _sortedMap = new HashMap<Integer, CompositeKey>();
        private CommonComparator _comparer;

        private MySortProcessor() {
        }

        public Map<Integer, CompositeKey> getSortedSearcher() {
            return this._sortedMap;
        }

        private int confirmMeasureIndex() {
            AnalyticalField sortField = AbstractSimilarListMaker.this.getDesignProperty().getSortField();
            if (sortField != null) {
                int idx = -1;
                for (int i = 0; i < AbstractSimilarListMaker.this.getFieldSet().getFieldCount(); ++i) {
                    AnalyticalField field = AbstractSimilarListMaker.this.getFieldSet().getField(i);
                    if (!field.isMeasure()) continue;
                    ++idx;
                    if (field != sortField) continue;
                    return idx;
                }
            }
            return -1;
        }

        @Override
        protected List<AbstractSortProcessor.SortableItem> preSort(Cuboid cuboid, AbstractSortProcessor.ICuboidShell insteadCuboid) {
            int measureIdx = this.confirmMeasureIndex();
            ArrayList<AbstractSortProcessor.SortableItem> list = new ArrayList<AbstractSortProcessor.SortableItem>();
            Iterator<CompositeKey> itDimKey = cuboid.createDimensionKeyIterator();
            while (itDimKey.hasNext()) {
                CompositeKey dimKey = itDimKey.next();
                Aggregator[] aggregators = cuboid.getCellAggregators(dimKey);
                MySortableItem item = new MySortableItem();
                item.setCategoryValue(dimKey);
                item.setAscendent(this.isAscendent());
                list.add(item);
                if (measureIdx >= 0) {
                    BigDecimal accordingValue = aggregators[measureIdx].getNumberValue();
                    item.addCuboidCell(dimKey, aggregators, accordingValue);
                    continue;
                }
                item.setSortAccording(dimKey);
            }
            return list;
        }

        @Override
        protected void collectCategory(Object categoryValue, int idxForSort) {
            this._sortedMap.put(idxForSort, (CompositeKey)categoryValue);
        }

        @Override
        protected CompositeKey replaceMemberForOthers(CompositeKey dimKey, AbstractSortProcessor.OthersMember others) {
            return null;
        }

        @Override
        protected void mergeMeasureForOthers(Cuboid insteadCuboid, CompositeKey insteadDimKey, Aggregator[] aggs) {
        }

        private CommonComparator getCommonComparator() {
            if (this._comparer == null) {
                Locale locale = AbstractSimilarListMaker.this.getI18nContext().getLanManager().getLocale();
                this._comparer = new CommonComparator(locale);
                this._comparer.setEmptyAheadAlways(false);
            }
            return this._comparer;
        }

        private class MySortableItem
        extends AbstractSortProcessor.SortableItem {
            private CompositeKey _mySortAccording;

            private MySortableItem() {
            }

            public void setSortAccording(CompositeKey dimKey) {
                this._mySortAccording = dimKey;
            }

            @Override
            public int compareTo(AbstractSortProcessor.SortableItem o) {
                if (this._mySortAccording == null) {
                    return super.compareTo(o);
                }
                CompositeKey anotherOne = ((MySortableItem)o)._mySortAccording;
                for (int i = 0; i < this._mySortAccording.getMemberCount(); ++i) {
                    Comparable member = (Comparable)this._mySortAccording.getMember(i);
                    Comparable anotherMember = (Comparable)anotherOne.getMember(i);
                    int compared = MySortProcessor.this.getCommonComparator().compare(member, anotherMember);
                    if (compared == 0) continue;
                    return compared;
                }
                return 0;
            }
        }
    }
}

