/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.square.AbstractSimilarColumnMaker;
import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.flattening.square.MakerForColumn;
import com.kingdee.bos.qing.core.flattening.square.MakerForLine;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.chart.Column;
import com.kingdee.bos.qing.core.model.analysis.square.chart.CompositeChart;
import com.kingdee.bos.qing.core.model.analysis.square.chart.Line;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.CompositeChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.XSYNChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.sub.Sort;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.util.LogUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

class MakerForComposite
extends AbstractSquareViewMaker {
    MakerForComposite() {
    }

    @Override
    protected AbstractChartModel makeChart() throws AnalysisException {
        MultiSeriesChartModel chart = new MultiSeriesChartModel();
        if (this.getDesignChartModel().getLeftYAxis().getFieldCount() > 0 && this.getDesignChartModel().getRightYAxis().getFieldCount() > 0) {
            if (this.getCuboid().getCellCount() == 0) {
                this.makeChartWhenDataEmpty(chart);
            } else {
                this.makeChartComposite(chart);
            }
        }
        return chart;
    }

    @Override
    protected int getCategoryMemberLimitedCount() {
        return 512;
    }

    @Override
    protected int getSeriesMemberLimitedCount() {
        return 20;
    }

    private CompositeChart getDesignChartModel() {
        return (CompositeChart)this.getModel().getChartModel();
    }

    private void makeChartWhenDataEmpty(MultiSeriesChartModel chart) {
        AbstractNormalChartModel.Node node1 = this.createNode(BigDecimal.ZERO, null);
        node1.setText("");
        AbstractNormalChartModel.Series series1 = new AbstractNormalChartModel.Series();
        series1.setName(this.getMeasureTitle(this.getDesignChartModel().getLeftYAxis().getField(0)));
        series1.getCategoryFitnessNodeList(1).set(0, node1);
        AbstractNormalChartModel.Node node2 = this.createNode(BigDecimal.ZERO, null);
        node2.setText("");
        AbstractNormalChartModel.Series series2 = new AbstractNormalChartModel.Series();
        series2.setName(this.getMeasureTitle(this.getDesignChartModel().getRightYAxis().getField(0)));
        series2.getCategoryFitnessNodeList(1).set(0, node2);
        chart.addCategory(new AbstractNormalChartModel.Category());
        chart.setSeries(new ArrayList<AbstractNormalChartModel.Series>());
        chart.getSeries().add(series1);
        chart.getSeries().add(series2);
        chart.addValueScope("0", "1");
        chart.addValueScope("0", "1");
    }

    private void makeChartComposite(MultiSeriesChartModel chart) throws AnalysisException {
        int rightMeasureFields;
        int leftMeasureFields;
        CompositeChart designtimeCompositeChart = this.getDesignChartModel();
        Column designtimeColumnChart = this.createColumnChartModel(designtimeCompositeChart);
        Line designtimeLineChart = this.createLineChartModel(designtimeCompositeChart);
        Cuboid cuboid = this.getCuboid();
        boolean isSortByColumn = false;
        CompositeChartProperty chartProperty = (CompositeChartProperty)designtimeCompositeChart.getChartProperty();
        if (chartProperty.isSortToDealWithByColumn(designtimeColumnChart.getYAxis().getFieldCount())) {
            isSortByColumn = true;
            XSYNChartProperty columnProperty = (XSYNChartProperty)designtimeColumnChart.getChartProperty();
            Sort.copyBase(chartProperty.getSort(), columnProperty.getSort());
        }
        this.getModel().setChartModel(designtimeColumnChart);
        MakerForColumn columnMaker = this.createColumnChartMaker(cuboid);
        MultiSeriesChartModel column = (MultiSeriesChartModel)columnMaker.makeChart();
        int cuboidMesaureIndexOffset = designtimeCompositeChart.getLeftYAxis().getFieldCount();
        if (designtimeColumnChart.getSeries().getFieldCount() > 0) {
            Object maxSeriesMember = column.getSeries(column.getSeries().size() - 1).getOrderingValue();
            cuboid = this.aggreateFurtherCuboid(designtimeCompositeChart, cuboid, cuboidMesaureIndexOffset, maxSeriesMember);
        }
        this.getModel().setChartModel(designtimeLineChart);
        MultiSeriesChartModel line = this.makeLineChart(cuboid, cuboidMesaureIndexOffset);
        if (isSortByColumn) {
            MakerForComposite.sortLineAsSameAsColumn(columnMaker, column, line);
        }
        chart.setCategories(column.getCategories());
        chart.setCategoryTitle(column.getCategoryTitle());
        chart.setSeriesFieldTitle(column.getSeriesFieldTitle());
        ArrayList<AbstractNormalChartModel.Series> series = new ArrayList<AbstractNormalChartModel.Series>();
        this.moveSeries(column.getSeries(), series, 0);
        this.moveSeries(line.getSeries(), series, 1);
        chart.setSeries(series);
        ArrayList<AbstractNormalChartModel.AxisValueScope> scopes = new ArrayList<AbstractNormalChartModel.AxisValueScope>();
        scopes.addAll(column.getScopes());
        scopes.addAll(line.getScopes());
        chart.setScopes(scopes);
        if (!isSortByColumn && chartProperty.isSortToDealWithByLine(leftMeasureFields = designtimeColumnChart.getYAxis().getFieldCount(), rightMeasureFields = designtimeLineChart.getYAxis().getFieldCount())) {
            Sort sort = chartProperty.getSort();
            int targetSeriesIdxAtLine = sort.getSortAccording().getMeasureIndex() - leftMeasureFields;
            AbstractNormalChartModel.Series sortingSeries = line.getSeries(targetSeriesIdxAtLine);
            MakerForComposite.sortByLine(chart, sortingSeries, sort.isAscendent());
        }
        chart.setPaintableLines(this.mergePaintableLines(column.getPaintableLines(), line.getPaintableLines()));
        this.getModel().setChartModel(designtimeCompositeChart);
        this.executeStyleScriptsToAddGuideline(chart);
    }

    private void executeStyleScriptsToAddGuideline(MultiSeriesChartModel chart) {
        ArrayList<IExpr> exprsForGuideline = new ArrayList<IExpr>();
        AbstractSimilarColumnMaker.divideStyleScripts(this.getModel(), exprsForGuideline);
        if (exprsForGuideline.size() == 0) {
            return;
        }
        AbstractSimilarColumnMaker.ScriptExecuteContext ctx = new AbstractSimilarColumnMaker.ScriptExecuteContext();
        ctx.setCategoryContinuous(false);
        ctx.setChart(chart);
        for (int i = 0; i < exprsForGuideline.size(); ++i) {
            IExpr expr = (IExpr)exprsForGuideline.get(i);
            try {
                expr.execute((IExecuteContext)ctx);
                continue;
            }
            catch (ExecuteException ex) {
                LogUtil.debug((String)"Execute style-script error.", (Throwable)ex);
            }
        }
    }

    private void moveSeries(List<AbstractNormalChartModel.Series> srcSeries, List<AbstractNormalChartModel.Series> destSeries, int axisIdx) {
        for (AbstractNormalChartModel.Series series : srcSeries) {
            series.setAxisIndex(axisIdx);
            destSeries.add(series);
        }
    }

    private List<List<AbstractNormalChartModel.PaintableLine>> mergePaintableLines(List<List<AbstractNormalChartModel.PaintableLine>> pls1, List<List<AbstractNormalChartModel.PaintableLine>> pls2) {
        ArrayList pls = null;
        if (pls1 != null || pls2 != null) {
            pls = new ArrayList();
            pls.add(pls1 == null ? new ArrayList() : pls1.get(0));
            pls.add(pls2 == null ? new ArrayList() : pls2.get(0));
        }
        return pls;
    }

    private MakerForColumn createColumnChartMaker(Cuboid cuboid) throws AnalysisException {
        MakerForColumn maker = new MakerForColumn();
        maker.updateCuboid(cuboid);
        maker.transferContextFrom(this);
        maker.setColorValueMaker(this.getColorValueMaker());
        return maker;
    }

    private MultiSeriesChartModel makeLineChart(Cuboid cuboid, int cuboidMesaureIndexOffset) throws AnalysisException {
        MakerForLine maker = new MakerForLine();
        maker.updateCuboid(cuboid);
        maker.setCuboidMeasureIndexOffset(cuboidMesaureIndexOffset);
        maker.transferContextFrom(this);
        maker.setColorValueMaker(this.getColorValueMaker());
        return (MultiSeriesChartModel)maker.makeChart();
    }

    private Column createColumnChartModel(CompositeChart composite) {
        Column column = new Column();
        column.setXAxis(composite.getXAxis());
        column.setYAxis(composite.getLeftYAxis());
        column.setSeries(composite.getLeftSeries());
        column.setChartProperty(((CompositeChartProperty)composite.getChartProperty()).extractLeft());
        return column;
    }

    private Line createLineChartModel(CompositeChart composite) {
        Line line = new Line();
        line.setXAxis(composite.getXAxis());
        line.setYAxis(composite.getRightYAxis());
        line.setSeries(FieldSet.createEmptyInstance());
        line.setChartProperty(((CompositeChartProperty)composite.getChartProperty()).extractRight());
        return line;
    }

    private Cuboid aggreateFurtherCuboid(CompositeChart designtimeCompositeChart, Cuboid cuboid, int cuboidMesaureIndexOffset, Object maxSeriesMember) {
        int measureCount = designtimeCompositeChart.getRightYAxis().getFieldCount();
        boolean[] isInterlineCalculation = new boolean[measureCount];
        this.checkMeasureInterlineCalculation(designtimeCompositeChart, isInterlineCalculation);
        boolean isAllInterlineCalculation = this.isAllInterlineCalculation(isInterlineCalculation);
        boolean isAnyInterlineCalculation = this.isAnyInterlineCalculation(isInterlineCalculation);
        Cuboid subCuboid = this.getGrandTotalCuboid();
        int xAxisFieldCount = designtimeCompositeChart.getXAxis().getFieldCount();
        Cuboid furtherCuboid = new Cuboid();
        furtherCuboid.setDimensionFields(cuboid.getDimensionFields().subList(0, xAxisFieldCount));
        furtherCuboid.setMeasureFields(cuboid.getMeasureFields());
        Iterator<CompositeKey> it = cuboid.createDimensionKeyIterator();
        while (it.hasNext()) {
            CompositeKey dimKey = it.next();
            CompositeKey[] twoKeys = dimKey.split(xAxisFieldCount);
            CompositeKey furtherDimKey = twoKeys[0];
            CompositeKey seriesDimKey = twoKeys[1];
            Aggregator[] furtherAggs = furtherCuboid.getCellAggregators(furtherDimKey);
            if (!isAnyInterlineCalculation) continue;
            Aggregator[] aggs = cuboid.getCellAggregators(dimKey);
            for (int i = 0; i < measureCount; ++i) {
                int measureIdx = i + cuboidMesaureIndexOffset;
                Aggregator furtherAgg = furtherAggs[measureIdx];
                if (!isInterlineCalculation[i]) continue;
                Aggregator agg = aggs[measureIdx];
                Object seriesMember = seriesDimKey.getMember(0);
                if (maxSeriesMember == null || !maxSeriesMember.equals(seriesMember)) continue;
                furtherAgg.append(agg.getValue());
            }
        }
        if (!isAllInterlineCalculation) {
            it = furtherCuboid.createDimensionKeyIterator();
            while (it.hasNext()) {
                CompositeKey furtherDimKey = it.next();
                CompositeKey subTotalDimKey = furtherDimKey.copy();
                subTotalDimKey.addMember("com.kingdee.bos.qing.All");
                Aggregator[] furtherAggs = furtherCuboid.getCellAggregators(furtherDimKey);
                Aggregator[] subTotalAggs = subCuboid.getCellAggregators(subTotalDimKey);
                for (int i = 0; i < measureCount; ++i) {
                    int measureIdx = i + cuboidMesaureIndexOffset;
                    Aggregator furtherAgg = furtherAggs[measureIdx];
                    if (isInterlineCalculation[i]) continue;
                    Aggregator subTotalAgg = subTotalAggs[measureIdx];
                    furtherAgg.carry(subTotalAgg);
                }
            }
        }
        return furtherCuboid;
    }

    private void checkMeasureInterlineCalculation(CompositeChart designtimeCompositeChart, boolean[] isInterlineCalculation) {
        AnalyticalField seriesField = designtimeCompositeChart.getLeftSeries().getField(0);
        if (seriesField.getDataType() == DataType.DATE) {
            FieldSet fieldSet = designtimeCompositeChart.getRightYAxis();
            for (int i = 0; i < fieldSet.getFieldCount(); ++i) {
                if (fieldSet.getField(i).getMetaField().getFormulaAggStatus() != MetaField.FormulaAggStatus.Interline) continue;
                isInterlineCalculation[i] = true;
            }
        }
    }

    private boolean isAllInterlineCalculation(boolean[] isInterlineCalculation) {
        for (int i = 0; i < isInterlineCalculation.length; ++i) {
            if (isInterlineCalculation[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isAnyInterlineCalculation(boolean[] isInterlineCalculation) {
        for (int i = 0; i < isInterlineCalculation.length; ++i) {
            if (!isInterlineCalculation[i]) continue;
            return true;
        }
        return false;
    }

    private static void sortLineAsSameAsColumn(MakerForColumn columnMaker, MultiSeriesChartModel column, MultiSeriesChartModel line) {
        HashMap<AbstractNormalChartModel.Category, Integer> columnCategoriesIndex = new HashMap<AbstractNormalChartModel.Category, Integer>();
        List<AbstractNormalChartModel.Category> columnCategories = column.getCategories();
        for (int i = 0; i < columnCategories.size(); ++i) {
            AbstractNormalChartModel.Category category = columnCategories.get(i);
            columnCategoriesIndex.put(category, i);
        }
        HashMap<Integer, Integer> indexMapping = new HashMap<Integer, Integer>();
        List<AbstractNormalChartModel.Category> lineCategories = line.getCategories();
        for (int i = 0; i < lineCategories.size(); ++i) {
            AbstractNormalChartModel.Category lineCategory = lineCategories.get(i);
            AbstractNormalChartModel.Category columnCategory = columnMaker.searchCategory(lineCategory.getOrderingValue());
            int sortedIdx = (Integer)columnCategoriesIndex.get(columnCategory);
            indexMapping.put(i, sortedIdx);
        }
        List<AbstractNormalChartModel.Series> lineSeries = line.getSeries();
        for (AbstractNormalChartModel.Series series : lineSeries) {
            List<AbstractNormalChartModel.INode> nodes = series.getNodes();
            AbstractNormalChartModel.Series tempSeries = new AbstractNormalChartModel.Series();
            List<AbstractNormalChartModel.INode> tempNodes = tempSeries.getCategoryFitnessNodeList(nodes.size());
            for (int i = 0; i < nodes.size(); ++i) {
                AbstractNormalChartModel.INode node = nodes.get(i);
                int sortedIdx = (Integer)indexMapping.get(i);
                tempNodes.set(sortedIdx, node);
            }
            series.setNodes(tempNodes);
        }
    }

    private static void sortByLine(MultiSeriesChartModel compositeChart, AbstractNormalChartModel.Series sortingSeries, boolean isAscendent) {
        List<AbstractNormalChartModel.INode> nodes = sortingSeries.getNodes();
        ArrayList<AbstractNormalChartModel.Node> sortingNodes = new ArrayList<AbstractNormalChartModel.Node>();
        AbstractNormalChartModel.toOrderedNodes(nodes, sortingNodes, isAscendent);
        HashMap<AbstractNormalChartModel.INode, Integer> nodeToIndex = new HashMap<AbstractNormalChartModel.INode, Integer>();
        for (int i = 0; i < sortingNodes.size(); ++i) {
            AbstractNormalChartModel.INode node = (AbstractNormalChartModel.INode)sortingNodes.get(i);
            nodeToIndex.put(node, i);
        }
        HashMap<Integer, Integer> indexMapping = new HashMap<Integer, Integer>();
        for (int i = 0; i < nodes.size(); ++i) {
            AbstractNormalChartModel.INode node = nodes.get(i);
            int sortedIndex = (Integer)nodeToIndex.get(node);
            indexMapping.put(i, sortedIndex);
        }
        List<AbstractNormalChartModel.Category> categories = compositeChart.getCategories();
        AbstractNormalChartModel.Category[] sortedCategories = new AbstractNormalChartModel.Category[categories.size()];
        for (int i = 0; i < categories.size(); ++i) {
            AbstractNormalChartModel.Category category = categories.get(i);
            int sortedIdx = (Integer)indexMapping.get(i);
            sortedCategories[sortedIdx] = category;
        }
        compositeChart.setCategories(Arrays.asList(sortedCategories));
        List<AbstractNormalChartModel.Series> allSeries = compositeChart.getSeries();
        for (AbstractNormalChartModel.Series oneSeries : allSeries) {
            List<AbstractNormalChartModel.INode> theNodes = oneSeries.getNodes();
            AbstractNormalChartModel.Series tempSeries = new AbstractNormalChartModel.Series();
            List<AbstractNormalChartModel.INode> tempNodes = tempSeries.getCategoryFitnessNodeList(theNodes.size());
            for (int i = 0; i < theNodes.size(); ++i) {
                AbstractNormalChartModel.INode node = theNodes.get(i);
                int sortedIdx = (Integer)indexMapping.get(i);
                tempNodes.set(sortedIdx, node);
            }
            oneSeries.setNodes(tempNodes);
        }
    }
}

