/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.common.grammar.AbstractExecuteContext;
import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractFunctionExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.expr.VariantExpr;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.flattening.common.func.AbstractAssistedExecutableFunction;
import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.model.analysis.square.chart.Kpi;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.KpiChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.SingleSeriesChartModel;
import com.kingdee.bos.qing.util.LogUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class MakerForKpi
extends AbstractSquareViewMaker {
    private static final String CAPTION = "caption_text";
    private static final String PRIMARY_VALUE = "primary_value";
    private static final String PRIMARY_TEXT = "primary_text";
    private static final String SECONDARY_ = "secondary_";
    private static final String SECONDARY_VALUE = "secondary_value";
    private static final String SECONDARY_TEXT = "secondary_text";
    private Aggregator[] _aggs;

    MakerForKpi() {
    }

    @Override
    protected AbstractChartModel makeChart() {
        this.input();
        SingleSeriesChartModel chart = new SingleSeriesChartModel();
        this.ouputCaption(chart);
        this.outputPrimaryAndSecondary(chart);
        this.runConditionStyleScript(chart);
        return chart;
    }

    private boolean isPrimaryFieldExist() {
        Kpi kpi = (Kpi)this.getModel().getChartModel();
        return kpi.getPrimaryFieldSet().getFieldCount() > 0;
    }

    private int getSecondaryMeasureCount() {
        Kpi kpi = (Kpi)this.getModel().getChartModel();
        return kpi.getSecondaryFieldSet().getFieldCount();
    }

    private KpiChartProperty getDesignProperty() {
        return (KpiChartProperty)this.getModel().getChartModel().getChartProperty();
    }

    private void input() {
        Cuboid cuboid = this.getCuboid();
        Iterator<CompositeKey> itKeys = cuboid.createDimensionKeyIterator();
        if (itKeys.hasNext()) {
            CompositeKey dimKey = itKeys.next();
            this._aggs = cuboid.getCellAggregators(dimKey);
        }
    }

    private BigDecimal getNumber(int measureIdx, boolean isInstead) {
        if (this._aggs == null) {
            if (isInstead) {
                try {
                    return new BigDecimal(this.getDesignProperty().getPrimaryDataEmptyInstead());
                }
                catch (NumberFormatException ex) {
                    return BigDecimal.ZERO;
                }
            }
            return null;
        }
        Aggregator agg = this._aggs[measureIdx];
        BigDecimal measureValue = agg.getNumberValue();
        return measureValue;
    }

    private AbstractNormalChartModel.Node createTextNode(String text) {
        AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
        node.setValue("");
        node.setText(text);
        return node;
    }

    private AbstractNormalChartModel.Category createCategory(String key, String color) {
        AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
        category.setLabel(key);
        category.setColor(color);
        return category;
    }

    private void ouputCaption(SingleSeriesChartModel chart) {
        String caption = this.getDesignProperty().getCaption();
        if (caption != null && !"".equals(caption)) {
            KpiChartProperty.KpiCustomStyles kpiCustomStyles = this.getDesignProperty().getCustomStyles();
            String color = kpiCustomStyles == null ? null : kpiCustomStyles.getCaptionStyleItem().getColor();
            AbstractNormalChartModel.Category category = this.createCategory(CAPTION, color);
            AbstractNormalChartModel.Node node = this.createTextNode(caption);
            chart.addData(category, node);
        }
    }

    private void outputPrimaryAndSecondary(final SingleSeriesChartModel chart) {
        final KpiChartProperty.KpiCustomStyles kpiCustomStyles = this.getDesignProperty().getCustomStyles();
        final boolean isPrimaryFieldExist = this.isPrimaryFieldExist();
        this.splitCompositeString(this.getDesignProperty().getPrimaryString(), 1, new ICompositeStringHandler(){

            @Override
            public void addValue(int idx) {
                String color = kpiCustomStyles == null ? null : kpiCustomStyles.getPrimaryValueStyleItem().getColor();
                AbstractNormalChartModel.Category category = MakerForKpi.this.createCategory(MakerForKpi.PRIMARY_VALUE, color);
                AbstractNormalChartModel.Node node = null;
                if (isPrimaryFieldExist) {
                    int measureIdx = 0;
                    BigDecimal measureValue = MakerForKpi.this.getNumber(measureIdx, true);
                    node = MakerForKpi.this.createNode(measureValue, MakerForKpi.this.getCuboid().getMeasureField(measureIdx));
                }
                chart.addData(category, node);
            }

            @Override
            public void addPart(String text) {
                String color = kpiCustomStyles == null ? null : kpiCustomStyles.getPrimaryTextStyleItem().getColor();
                AbstractNormalChartModel.Category category = MakerForKpi.this.createCategory(MakerForKpi.PRIMARY_TEXT, color);
                AbstractNormalChartModel.Node node = MakerForKpi.this.createTextNode(text);
                chart.addData(category, node);
            }
        });
        final int secondaryMeasureCount = this.getSecondaryMeasureCount();
        final int usableMeasureCount = (isPrimaryFieldExist ? 1 : 0) + secondaryMeasureCount;
        this.splitCompositeString(this.getDesignProperty().getSecondaryString(), secondaryMeasureCount, new ICompositeStringHandler(){

            @Override
            public void addValue(int idx) {
                String color = kpiCustomStyles == null ? null : kpiCustomStyles.getSecondaryValueStyleItem().getColor();
                AbstractNormalChartModel.Category category = MakerForKpi.this.createCategory(MakerForKpi.SECONDARY_VALUE, color);
                AbstractNormalChartModel.Node node = null;
                int measureIdx = idx + (isPrimaryFieldExist ? 1 : 0);
                if (MakerForKpi.this._aggs == null) {
                    if (secondaryMeasureCount > 0) {
                        node = MakerForKpi.this.createNodeNotNull(null, null);
                        node.setText("--");
                    }
                } else if (measureIdx < usableMeasureCount) {
                    BigDecimal measureValue = MakerForKpi.this.getNumber(measureIdx, false);
                    node = MakerForKpi.this.createNode(measureValue, MakerForKpi.this.getCuboid().getMeasureField(measureIdx));
                }
                chart.addData(category, node);
            }

            @Override
            public void addPart(String text) {
                String color = kpiCustomStyles == null ? null : kpiCustomStyles.getSecondaryTextStyleItem().getColor();
                AbstractNormalChartModel.Category category = MakerForKpi.this.createCategory(MakerForKpi.SECONDARY_TEXT, color);
                AbstractNormalChartModel.Node node = MakerForKpi.this.createTextNode(text);
                chart.addData(category, node);
            }
        });
    }

    private void splitCompositeString(String compositeString, int valueCount, ICompositeStringHandler handler) {
        if (compositeString == null || "".equals(compositeString)) {
            if (valueCount > 0) {
                handler.addValue(0);
            }
            return;
        }
        int valueIdx = 0;
        boolean isContinue = true;
        while (isContinue) {
            String replacer = "${" + valueIdx + "}$";
            int replacerLength = replacer.length();
            int replacerIdx = compositeString.indexOf(replacer);
            if (replacerIdx > 0) {
                String prefix = compositeString.substring(0, replacerIdx);
                handler.addPart(prefix);
            }
            if (replacerIdx >= 0) {
                String postfix;
                handler.addValue(valueIdx);
                compositeString = postfix = compositeString.substring(replacerIdx + replacerLength);
                ++valueIdx;
                continue;
            }
            isContinue = false;
        }
        if (compositeString.length() > 0) {
            handler.addPart(compositeString);
        }
    }

    private void runConditionStyleScript(SingleSeriesChartModel chart) {
        List<IExpr> exprs = this.getDesignProperty().getStyleExprs();
        if (exprs != null) {
            ScriptExecuteContext ctx = new ScriptExecuteContext();
            ctx.setI18nContext(this.getI18nContext());
            ctx.setChart(chart);
            for (IExpr expr : exprs) {
                try {
                    expr.execute((IExecuteContext)ctx);
                }
                catch (ExecuteException ex) {
                    LogUtil.debug((String)"Execute style-script error.", (Throwable)ex);
                }
            }
        }
    }

    static class ScriptExecuteContext
    extends AbstractExecuteContext {
        private SingleSeriesChartModel _chart;

        ScriptExecuteContext() {
        }

        public void setChart(SingleSeriesChartModel chart) {
            this._chart = chart;
        }

        public Object getValue(IExpr expr) throws ExecuteException {
            AbstractFunctionExpr func;
            String name;
            if (expr instanceof VariantExpr) {
                String name2 = ((VariantExpr)expr).getName();
                if ("VALUE".equalsIgnoreCase(name2)) {
                    return this.searchMeasure(MakerForKpi.PRIMARY_VALUE, 1);
                }
            } else if (expr instanceof AbstractAssistedExecutableFunction) {
                AbstractAssistedExecutableFunction func2 = (AbstractAssistedExecutableFunction)expr;
                String name3 = func2.getName();
                if ("setCaption".equalsIgnoreCase(name3)) {
                    return this.setCaption(func2);
                }
                if ("setPrimary".equalsIgnoreCase(name3)) {
                    return this.setPrimary(func2, true);
                }
                if ("setPrimaryNumber".equalsIgnoreCase(name3)) {
                    return this.setPrimary(func2, false);
                }
                if ("setSecondary".equalsIgnoreCase(name3)) {
                    return this.setSecondary(func2);
                }
                if ("setSecondaryNumber".equalsIgnoreCase(name3)) {
                    return this.setSecondaryNumber(func2);
                }
            } else if (expr instanceof AbstractFunctionExpr && "getValue".equalsIgnoreCase(name = (func = (AbstractFunctionExpr)expr).getName())) {
                return this.getValue(func);
            }
            return null;
        }

        private BigDecimal searchMeasure(String key, int ranking) {
            AbstractNormalChartModel.Series series = this._chart.getOnlyOneSeries();
            List<AbstractNormalChartModel.Category> categories = this._chart.getCategories();
            int count = 1;
            for (int i = 0; i < categories.size(); ++i) {
                AbstractNormalChartModel.Category category = categories.get(i);
                if (!key.equals(category.getLabel())) continue;
                if (count == ranking) {
                    AbstractNormalChartModel.Node node = (AbstractNormalChartModel.Node)series.getNodes().get(i);
                    return node == null ? null : node.getOrigin();
                }
                ++count;
            }
            return null;
        }

        private List<AbstractNormalChartModel.Category> searchCategories(String keyPrefix, int ranking) {
            ArrayList<AbstractNormalChartModel.Category> targets = new ArrayList<AbstractNormalChartModel.Category>();
            List<AbstractNormalChartModel.Category> categories = this._chart.getCategories();
            int count = 1;
            for (int i = 0; i < categories.size(); ++i) {
                AbstractNormalChartModel.Category category = categories.get(i);
                if (category.getLabel().indexOf(keyPrefix) != 0) continue;
                if (count == ranking) {
                    targets.add(category);
                    break;
                }
                ++count;
            }
            return targets;
        }

        private List<AbstractNormalChartModel.Category> searchCategories(String key) {
            ArrayList<AbstractNormalChartModel.Category> targets = new ArrayList<AbstractNormalChartModel.Category>();
            List<AbstractNormalChartModel.Category> categories = this._chart.getCategories();
            for (int i = 0; i < categories.size(); ++i) {
                AbstractNormalChartModel.Category category = categories.get(i);
                if (!key.equals(category.getLabel())) continue;
                targets.add(category);
            }
            return targets;
        }

        private boolean checkColorStyleName(AbstractAssistedExecutableFunction func) throws ExecuteException {
            return "color".equals(func.getStringParamValue(0, (IExecuteContext)this));
        }

        private String getColorStyleValue(AbstractAssistedExecutableFunction func) throws ExecuteException {
            return func.getStringParamValue(1, (IExecuteContext)this);
        }

        private int getPartIndex(AbstractAssistedExecutableFunction func) throws ExecuteException {
            if (func.getParams().length > 2) {
                return func.getIntParamValue(2, (IExecuteContext)this);
            }
            return -1;
        }

        private void setColorValue(List<AbstractNormalChartModel.Category> targets, String color) throws ExecuteException {
            for (AbstractNormalChartModel.Category category : targets) {
                category.setColor(color);
            }
        }

        private Boolean setCaption(AbstractAssistedExecutableFunction func) throws ExecuteException {
            if (this.checkColorStyleName(func)) {
                String color = this.getColorStyleValue(func);
                this.setColorValue(this.searchCategories(MakerForKpi.CAPTION), color);
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        private Boolean setPrimary(AbstractAssistedExecutableFunction func, boolean isWholeLine) throws ExecuteException {
            if (this.checkColorStyleName(func)) {
                String color = this.getColorStyleValue(func);
                this.setColorValue(this.searchCategories(MakerForKpi.PRIMARY_VALUE), color);
                if (isWholeLine) {
                    this.setColorValue(this.searchCategories(MakerForKpi.PRIMARY_TEXT), color);
                }
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        private Boolean setSecondary(AbstractAssistedExecutableFunction func) throws ExecuteException {
            if (this.checkColorStyleName(func)) {
                String color = this.getColorStyleValue(func);
                int partIdx = this.getPartIndex(func);
                if (partIdx >= 0) {
                    this.setColorValue(this.searchCategories(MakerForKpi.SECONDARY_, partIdx), color);
                } else {
                    this.setColorValue(this.searchCategories(MakerForKpi.SECONDARY_VALUE), color);
                    this.setColorValue(this.searchCategories(MakerForKpi.SECONDARY_TEXT), color);
                }
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        private Boolean setSecondaryNumber(AbstractAssistedExecutableFunction func) throws ExecuteException {
            if (this.checkColorStyleName(func)) {
                String color = this.getColorStyleValue(func);
                this.setColorValue(this.searchCategories(MakerForKpi.SECONDARY_VALUE), color);
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        private BigDecimal getValue(AbstractFunctionExpr func) throws ExecuteException {
            IExpr param;
            Object value;
            int whichOne = 1;
            IExpr[] subs = func.getParams();
            if (subs.length > 0 && (value = (param = subs[0]).execute((IExecuteContext)this)) instanceof BigDecimal) {
                whichOne = ((BigDecimal)value).intValue();
            }
            switch (whichOne) {
                case 1: {
                    return this.searchMeasure(MakerForKpi.PRIMARY_VALUE, 1);
                }
            }
            return this.searchMeasure(MakerForKpi.SECONDARY_VALUE, whichOne - 1);
        }
    }

    private static interface ICompositeStringHandler {
        public void addValue(int var1);

        public void addPart(String var1);
    }
}

