/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.ContinuousColor;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.chart.Map;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.MapChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

class MakerForMap
extends AbstractSquareViewMaker {
    private AnalyticalField _dimentionField;
    private AnalyticalField _measureField;
    private java.util.Map<Object, AbstractNormalChartModel.Category> _categoryMap = new HashMap<Object, AbstractNormalChartModel.Category>();

    MakerForMap() {
    }

    @Override
    protected AbstractChartModel makeChart() {
        this.parseDesignModel();
        MultiSeriesChartModel chart = new MultiSeriesChartModel();
        chart.addSeries("");
        if (this._dimentionField != null) {
            if (this.getCuboid().getCellCount() > 0) {
                this.scan(chart);
            } else {
                this.addData(chart, new AbstractNormalChartModel.Category(), null);
            }
        } else {
            this.addData(chart, new AbstractNormalChartModel.Category(), null);
        }
        return chart;
    }

    @Override
    protected AbstractSquareViewMaker.AbstractColorValueMaker createColorValueMaker() {
        MapChartProperty property = (MapChartProperty)this.getChartModel().getChartProperty();
        ContinuousColor colorDefine = property.getContinuousColor();
        String legendFormat = property.getLegendFormat();
        return super.createContinuousColorValueMaker(this._measureField, colorDefine, legendFormat);
    }

    private AbstractSquareViewMaker.ContinuousColorValueMaker getMyColorValueMaker() {
        return (AbstractSquareViewMaker.ContinuousColorValueMaker)this.getColorValueMaker();
    }

    private Map getChartModel() {
        return (Map)this.getModel().getChartModel();
    }

    private void parseDesignModel() {
        Map map = this.getChartModel();
        this._dimentionField = map.getDimensionSet().getFieldCount() > 0 ? map.getDimensionSet().getField(0) : null;
        this._measureField = map.getMeasureSet().getFieldCount() > 0 ? map.getMeasureSet().getField(0) : null;
    }

    private void addData(MultiSeriesChartModel chart, AbstractNormalChartModel.Category category, AbstractNormalChartModel.Node node) {
        chart.getCategories().add(category);
        chart.getSeries().get(0).getNodes().add(node);
    }

    private void scan(MultiSeriesChartModel chart) {
        String categoryFieldTitle = this._dimentionField.getTitle(this.getI18nContext());
        chart.setCategoryTitle(categoryFieldTitle);
        if (this._measureField != null) {
            String measureTitle = this.getMeasureTitle(this._measureField);
            AbstractNormalChartModel.Series series = chart.getSeries().get(0);
            series.setName(measureTitle);
            series.setFormatString(this._measureField.getUsableNumberFormat());
        }
        InfoMaker infoMaker = new InfoMaker(chart);
        Scope scope = new Scope();
        Cuboid cuboid = this.getCuboid();
        Iterator<CompositeKey> itKeys = cuboid.createDimensionKeyIterator();
        while (itKeys.hasNext()) {
            CompositeKey dimKey = itKeys.next();
            Object member = dimKey.getMember(0);
            String text = this.formatValue(member, this._dimentionField);
            String value = MakerForMap.encodeCategoryValue(member, text);
            AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
            category.setLabel(text);
            category.setValue(value);
            this._categoryMap.put(member, category);
            Aggregator[] aggs = cuboid.getCellAggregators(dimKey);
            AbstractNormalChartModel.Node node = null;
            if (this._measureField == null) {
                node = this.createNode(BigDecimal.ZERO, this._measureField);
            } else {
                Aggregator agg = aggs[0];
                BigDecimal measureValue = agg.getNumberValue();
                node = this.createNode(measureValue, this._measureField);
                scope.join(measureValue);
            }
            this.addData(chart, category, node);
            infoMaker.each(aggs);
        }
        if (this._measureField != null) {
            this.confirmColor(scope);
        }
    }

    private void confirmColor(Scope scope) {
        Cuboid cuboid = this.getCuboid();
        Iterator<CompositeKey> itKeys = cuboid.createDimensionKeyIterator();
        while (itKeys.hasNext()) {
            CompositeKey dimKey = itKeys.next();
            Object member = dimKey.getMember(0);
            Aggregator[] aggs = cuboid.getCellAggregators(dimKey);
            Aggregator agg = aggs[0];
            BigDecimal measureValue = agg.getNumberValue();
            String color = this.getMyColorValueMaker().makeContinuousColorValue(measureValue, scope);
            AbstractNormalChartModel.Category category = this._categoryMap.get(member);
            category.setColor(color);
        }
    }

    private class InfoMaker {
        private List<AnalyticalField> _infoFields;
        private List<Integer> _infoIdxsAtMeasure;
        private List<AbstractNormalChartModel.Series> _infoSeries;

        public InfoMaker(MultiSeriesChartModel chart) {
            FieldSet infoFieldSet = MakerForMap.this.getChartModel().getInfomationSet();
            int infoFieldCount = infoFieldSet.getFieldCount();
            this._infoFields = new ArrayList<AnalyticalField>(infoFieldCount);
            this._infoIdxsAtMeasure = new ArrayList<Integer>(infoFieldCount);
            this._infoSeries = new ArrayList<AbstractNormalChartModel.Series>(infoFieldCount);
            for (int i = 0; i < infoFieldCount; ++i) {
                AnalyticalField infoField = infoFieldSet.getField(i);
                this.addItem(infoField, chart);
            }
        }

        private void addItem(AnalyticalField infoField, MultiSeriesChartModel chart) {
            int idxAtMeasure = this.searchIndexAtMeasure(infoField);
            if (idxAtMeasure >= 0) {
                AbstractNormalChartModel.Series series = chart.addSeries(MakerForMap.this.getMeasureTitle(infoField));
                this._infoFields.add(infoField);
                this._infoIdxsAtMeasure.add(idxAtMeasure);
                this._infoSeries.add(series);
            }
        }

        public void each(Aggregator[] aggs) {
            for (int i = 0; i < this._infoIdxsAtMeasure.size(); ++i) {
                AnalyticalField field = this._infoFields.get(i);
                int idx = this._infoIdxsAtMeasure.get(i);
                Aggregator agg = aggs[idx];
                String label = agg instanceof Aggregator.Properties ? this.makePropertyLabel(aggs[idx], field) : MakerForMap.this.formatNumber(agg.getNumberValue(), field);
                AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
                node.setValue("");
                node.setText(label);
                AbstractNormalChartModel.Series series = this._infoSeries.get(i);
                series.getNodes().add(node);
            }
        }

        private int searchIndexAtMeasure(AnalyticalField targetField) {
            List<AnalyticalField> fields = MakerForMap.this.getCuboid().getMeasureFields();
            for (int i = 0; i < fields.size(); ++i) {
                if (!targetField.isSame(fields.get(i))) continue;
                return i;
            }
            return -1;
        }

        private String makePropertyLabel(Aggregator agg, AnalyticalField field) {
            Aggregator.Properties p = (Aggregator.Properties)agg;
            if (p.getValueCount() == 1) {
                Object value = p.getSingleValue();
                return MakerForMap.this.formatValue(value, field);
            }
            return "*";
        }
    }
}

