/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.common.Palette;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.chart.MapGis;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.MapGisChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.SingleSeriesChartModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class MakerForMapGis
extends AbstractSquareViewMaker {
    MakerForMapGis() {
    }

    @Override
    protected AbstractChartModel makeChart() throws AnalysisException {
        boolean hasLongitude = this.getChartModel().getCoordinateSet().getFieldCount() > 0;
        boolean hasLatitudeField = this.getChartModel().getCoordinateSet().getFieldCount() > 1;
        AbstractNormalChartModel chart = hasLongitude && hasLatitudeField && this.getCuboid().getCellCount() > 0 ? this.createChart() : this.createBlankChart();
        return chart;
    }

    @Override
    protected int getCategoryMemberLimitedCount() {
        return 512;
    }

    @Override
    protected int getSeriesMemberLimitedCount() {
        return 10;
    }

    @Override
    protected Palette.PaletteType getPaletteType() {
        return Palette.PaletteType.CONTRASTING_AREA;
    }

    @Override
    protected float getPaletteTranslucenceAlpha() {
        if (((MapGisChartProperty)this.getChartModel().getChartProperty()).getUsage() == MapGisChartProperty.Usage.BUBBLE) {
            return 0.7f;
        }
        return 1.0f;
    }

    private MapGis getChartModel() {
        return (MapGis)this.getModel().getChartModel();
    }

    private SingleSeriesChartModel createBlankChart() {
        SingleSeriesChartModel chart = new SingleSeriesChartModel();
        chart.addData(new AbstractNormalChartModel.Category(), null);
        return chart;
    }

    private MultiSeriesChartModel createChart() {
        MultiSeriesChartModel chart = new MultiSeriesChartModel();
        AbstractNormalChartModel.Series coordinateSeries = chart.addSeries("coordinate");
        AnalyticalField captionField = this.getTheField(this.getChartModel().getCaptionSet());
        AnalyticalField colorField = this.getTheField(this.getChartModel().getColorSet());
        int captionIdxAtMeasure = this.getIndexAtMeasure(captionField);
        int colorIdxAtMeasure = this.getIndexAtMeasure(colorField);
        int sizeIdxAtMeasure = this.getIndexAtMeasure(this.getTheField(this.getChartModel().getSizeSet()));
        Scope sizeScope = null;
        InfoMaker infoMaker = new InfoMaker(chart);
        int count = 0;
        Cuboid cuboid = this.getCuboid();
        Iterator<CompositeKey> itKeys = cuboid.createDimensionKeyIterator();
        while (itKeys.hasNext() && count <= this.getCategoryMemberLimitedCount()) {
            CompositeKey dimKey = itKeys.next();
            Object longitude = dimKey.getMember(0);
            Object latitude = dimKey.getMember(1);
            if (longitude == null || latitude == null) continue;
            ++count;
            AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
            chart.addCategory(category);
            AbstractNormalChartModel.XYNode coordinateNode = new AbstractNormalChartModel.XYNode();
            coordinateNode.setXAxisValue(longitude.toString());
            coordinateNode.setYAxisValue(latitude.toString());
            coordinateSeries.getNodes().add(coordinateNode);
            Aggregator[] aggs = cuboid.getCellAggregators(dimKey);
            if (captionIdxAtMeasure >= 0) {
                category.setLabel(this.makePropertyLabel(aggs[captionIdxAtMeasure], captionField));
            }
            if (sizeIdxAtMeasure >= 0) {
                Aggregator agg = aggs[sizeIdxAtMeasure];
                BigDecimal value = agg.getNumberValue();
                coordinateNode.setZAxisValue(value == null ? null : value.toString());
                if (sizeScope == null) {
                    sizeScope = new Scope();
                }
                sizeScope.join(value);
            }
            if (colorIdxAtMeasure >= 0) {
                String value = this.makePropertyLabel(aggs[colorIdxAtMeasure], colorField);
                category.setOrderingValue(value);
                String color = this.makeDiscreteColorValue(category, category.getLabel(), true);
                category.setColor(color);
            }
            infoMaker.each(aggs);
        }
        if (colorIdxAtMeasure < 0) {
            coordinateSeries.setColor(this.makeDiscreteColorValue(coordinateSeries, coordinateSeries.getName(), true));
        }
        if (sizeScope != null) {
            chart.addValueScope(sizeScope.getMin().toString(), sizeScope.getMax().toString());
        }
        return chart;
    }

    private int searchIndexAtMeasure(AnalyticalField targetField) {
        List<AnalyticalField> fields = this.getCuboid().getMeasureFields();
        for (int i = 0; i < fields.size(); ++i) {
            if (!targetField.isSame(fields.get(i))) continue;
            return i;
        }
        return -1;
    }

    private AnalyticalField getTheField(FieldSet fieldSet) {
        return fieldSet.getFieldCount() > 0 ? fieldSet.getField(0) : null;
    }

    private int getIndexAtMeasure(AnalyticalField field) {
        return field == null ? -1 : this.searchIndexAtMeasure(field);
    }

    private String makePropertyLabel(Aggregator agg, AnalyticalField field) {
        Aggregator.Properties p = (Aggregator.Properties)agg;
        if (p.getValueCount() == 1) {
            Object value = p.getSingleValue();
            return this.formatValue(value, field);
        }
        return "*";
    }

    private class InfoMaker {
        private List<AnalyticalField> _infoFields;
        private List<Integer> _infoIdxsAtMeasure;
        private List<AbstractNormalChartModel.Series> _infoSeries;

        public InfoMaker(MultiSeriesChartModel chart) {
            AnalyticalField captionField;
            AnalyticalField infoField;
            int i;
            FieldSet infoFieldSet = MakerForMapGis.this.getChartModel().getInfomationSet();
            int infoFieldCount = infoFieldSet.getFieldCount();
            this._infoFields = new ArrayList<AnalyticalField>(infoFieldCount);
            this._infoIdxsAtMeasure = new ArrayList<Integer>(infoFieldCount);
            this._infoSeries = new ArrayList<AbstractNormalChartModel.Series>(infoFieldCount);
            AnalyticalField colorField = MakerForMapGis.this.getTheField(MakerForMapGis.this.getChartModel().getColorSet());
            AnalyticalField sizeField = MakerForMapGis.this.getTheField(MakerForMapGis.this.getChartModel().getSizeSet());
            for (i = 0; i < infoFieldCount; ++i) {
                infoField = infoFieldSet.getField(i);
                if (colorField != null && colorField.isSame(infoField)) {
                    colorField = null;
                }
                if (sizeField == null || !sizeField.isSame(infoField)) continue;
                sizeField = null;
            }
            if (colorField != null && !colorField.isSame(captionField = MakerForMapGis.this.getTheField(MakerForMapGis.this.getChartModel().getCaptionSet()))) {
                this.addItem(colorField, chart);
            }
            if (sizeField != null) {
                this.addItem(sizeField, chart);
            }
            for (i = 0; i < infoFieldCount; ++i) {
                infoField = infoFieldSet.getField(i);
                this.addItem(infoField, chart);
            }
        }

        private void addItem(AnalyticalField infoField, MultiSeriesChartModel chart) {
            int idxAtMeasure = MakerForMapGis.this.searchIndexAtMeasure(infoField);
            if (idxAtMeasure >= 0) {
                AbstractNormalChartModel.Series series = chart.addSeries(MakerForMapGis.this.getMeasureTitle(infoField));
                this._infoFields.add(infoField);
                this._infoIdxsAtMeasure.add(idxAtMeasure);
                this._infoSeries.add(series);
            }
        }

        public void each(Aggregator[] aggs) {
            for (int i = 0; i < this._infoIdxsAtMeasure.size(); ++i) {
                AnalyticalField field = this._infoFields.get(i);
                int idx = this._infoIdxsAtMeasure.get(i);
                Aggregator agg = aggs[idx];
                String label = agg instanceof Aggregator.Properties ? MakerForMapGis.this.makePropertyLabel(aggs[idx], field) : MakerForMapGis.this.formatNumber(agg.getNumberValue(), field);
                AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
                node.setValue("");
                node.setText(label);
                AbstractNormalChartModel.Series series = this._infoSeries.get(i);
                series.getNodes().add(node);
            }
        }
    }
}

