/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.ParentChildDimensionMember;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.common.sort.AbstractSortProcessor;
import com.kingdee.bos.qing.core.flattening.common.sort.PieCommonProcessor;
import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.pie.LegendOrderMode;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.chart.AbstractPieChart;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.AbstractPieChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.SingleSeriesChartModel;
import com.kingdee.bos.qing.core.model.meta.DataType;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Locale;

class MakerForPie
extends AbstractSquareViewMaker {
    private AnalyticalField _colorField;
    private AnalyticalField _angleField;
    private int _angleMeasureIndex;
    private PieCommonProcessor _processor = new PieCommonProcessor(new ProcessorDependance());

    MakerForPie() {
    }

    private AbstractPieChart getDesignChartModel() {
        return (AbstractPieChart)this.getModel().getChartModel();
    }

    @Override
    protected AbstractChartModel makeChart() throws AnalysisException {
        this.parseDesignModel();
        SingleSeriesChartModel chart = new SingleSeriesChartModel();
        if (this._angleMeasureIndex >= 0) {
            AbstractPieChartProperty property = (AbstractPieChartProperty)this.getDesignChartModel().getChartProperty();
            int topN = property.getTopN();
            boolean isHideNegative = property.isHideNegative();
            LegendOrderMode legendOrderMode = property.getLegendOrderMode();
            AbstractSortProcessor.CuboidShell insteadCuboid = PieCommonProcessor.copyCuboidShellFrom(this.getCuboid());
            this._processor.setLegendOrgerMode(legendOrderMode);
            this._processor.setNegativeAsAbsolute(!isHideNegative);
            this._processor.setAscendent(false);
            this._processor.setTopN(topN);
            this._processor.setOthersAsAnItem(true);
            this._processor.setAngleMeasureIndex(this._angleMeasureIndex);
            this._processor.sortAndTopN(this.getCuboid(), insteadCuboid);
            this._processor.makeUnifiedColor();
            this.output(chart, insteadCuboid);
        }
        return chart;
    }

    private void parseDesignModel() {
        AbstractPieChart chartPie = this.getDesignChartModel();
        FieldSet colorFieldSet = chartPie.getColorFieldSet();
        if (colorFieldSet.getFieldCount() > 0) {
            this._colorField = colorFieldSet.getField(0);
            this._processor.setDateCategory(this._colorField.getDataType() == DataType.DATE);
        } else {
            this._colorField = null;
        }
        FieldSet angleFieldSet = chartPie.getAngleFieldSet();
        if (angleFieldSet.getFieldCount() > 0) {
            this._angleField = angleFieldSet.getField(0);
            this._angleMeasureIndex = 0;
        } else {
            this._angleField = null;
            this._angleMeasureIndex = -1;
        }
    }

    private void output(SingleSeriesChartModel chart, AbstractSortProcessor.CuboidShell cuboid) {
        Iterator<CompositeKey> itKeys = cuboid.createDimensionKeyIterator();
        if (itKeys.hasNext()) {
            while (itKeys.hasNext()) {
                CompositeKey dimKey = itKeys.next();
                Aggregator[] aggs = cuboid.getCellAggregators(dimKey);
                Aggregator agg = aggs[this._angleMeasureIndex];
                BigDecimal measureValue = agg.getNumberValue();
                AbstractNormalChartModel.Category category = this._processor.getCategory(dimKey);
                AbstractNormalChartModel.Node node = this.createNode(measureValue, this._angleField);
                chart.addData(category, node);
            }
        } else {
            AbstractNormalChartModel.Node node = this.createNode(BigDecimal.ZERO, null);
            node.setText("");
            AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
            category.setLabel("");
            category.setColor(this.getDefaultColor());
            chart.addData(category, node);
        }
        chart.setCategoryTitle(this._colorField == null ? null : this._colorField.getTitle(this.getI18nContext()));
        chart.getOnlyOneSeries().setName(this._angleField.getTitle(this.getI18nContext()));
        chart.getOnlyOneSeries().setFormatString(this._angleField.getUsableNumberFormat());
    }

    private class ProcessorDependance
    implements PieCommonProcessor.IDependance {
        private ProcessorDependance() {
        }

        @Override
        public Locale getI18nContext() {
            return MakerForPie.this.getI18nContext().getLanManager().getLocale();
        }

        @Override
        public boolean isSubtotal(CompositeKey dimKey) {
            return false;
        }

        @Override
        public String makeDiscreteColor(AbstractChartModel.IOrderingSupported object, String text) {
            return MakerForPie.this.makeDiscreteColorValue(object, text, false);
        }

        @Override
        public AbstractNormalChartModel.Category createCategory(Object categoryValue) throws AnalysisException {
            AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
            if (categoryValue instanceof AbstractSortProcessor.OthersMember) {
                category = MakerForPie.this.createCategoryForOthers((AbstractSortProcessor.OthersMember)categoryValue, MakerForPie.this._colorField);
            } else {
                category = new AbstractNormalChartModel.Category();
                String label = this.parseCategoryLabel(categoryValue);
                String value = AbstractSquareViewMaker.encodeCategoryValue(categoryValue, label);
                category.setLabel(label);
                category.setValue(value);
                MakerForPie.this.makePcdCategoryAsParent(categoryValue, MakerForPie.this._colorField, category);
            }
            return category;
        }

        private String parseCategoryLabel(Object categoryValue) {
            ParentChildDimensionMember pcdm;
            String label = categoryValue instanceof ParentChildDimensionMember ? ((pcdm = (ParentChildDimensionMember)categoryValue).getDisplayValue() == null ? "" : pcdm.getDisplayValue().toString()) : (categoryValue == null ? "" : (MakerForPie.this._colorField == null ? categoryValue.toString() : MakerForPie.this.formatValue(categoryValue, MakerForPie.this._colorField)));
            return label;
        }
    }
}

