/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square.refline;

import com.kingdee.bos.qing.common.format.NumberFormater;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.flattening.square.refline.AvgCalculator;
import com.kingdee.bos.qing.core.flattening.square.refline.ConstCalculator;
import com.kingdee.bos.qing.core.flattening.square.refline.MedCalculator;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.Refline;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import java.math.BigDecimal;

public abstract class AbstractReflineCalculator {
    private Refline _designModel;
    private AnalyticalField _measureField;

    public AbstractReflineCalculator(Refline model) {
        this._designModel = model;
    }

    protected final Refline getDesignModel() {
        return this._designModel;
    }

    public boolean isOnDuty(int measureIndex) {
        return this._designModel.getMeasureIndex() == measureIndex;
    }

    public abstract void collect(BigDecimal var1);

    public abstract BigDecimal getLineValue();

    public abstract AbstractNormalChartModel.PaintableLine getResult(II18nContext var1);

    public final void setMeasureField(AnalyticalField field) {
        this._measureField = field;
    }

    protected final String getMeasreTitle(II18nContext i18nCtx) {
        return this._measureField.getTitle(i18nCtx);
    }

    protected final String format(BigDecimal value) {
        NumberFormater formater = new NumberFormater();
        formater.setFormatString(this._measureField.getUsableNumberFormat());
        return formater.format(value);
    }

    public static AbstractReflineCalculator create(Refline model) {
        switch (model.getType()) {
            case AVG: {
                return new AvgCalculator(model);
            }
            case MEDIAN: {
                return new MedCalculator(model);
            }
            case CONST: {
                return new ConstCalculator(model);
            }
        }
        return null;
    }
}

