/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.common;

import com.kingdee.bos.qing.common.grammar.IContextRelativedExprConfirmer;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.RefExpr;
import com.kingdee.bos.qing.common.grammar.expr.VariantExpr;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.core.model.analysis.common.ContinuousColor;
import com.kingdee.bos.qing.core.model.analysis.common.Order;
import com.kingdee.bos.qing.core.model.analysis.common.PartValue;
import com.kingdee.bos.qing.core.model.analysis.common.QuickSetup;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.core.model.meta.MetaTable;
import com.kingdee.bos.qing.core.model.meta.ParentChildDimension;
import com.kingdee.bos.qing.core.model.parser.MetaFieldFormulaParser;
import com.kingdee.bos.qing.util.NameUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;

public class AnalyticalField {
    public static final String ROLE_DIMENSION = "dimension";
    public static final String ROLE_MEASURE = "measure";
    private String id;
    private String name;
    private String displayName;
    private String role;
    private boolean isContinuous;
    private Aggregation aggregation;
    private Aggregation totalUsing;
    private boolean isTotalDisplay = true;
    private boolean isShowSubtotal;
    private String numberFormat;
    private String dateFormat;
    private ContinuousColor continuousColor;
    private PartValue partValue;
    private Order sort;
    private QuickSetup quickSetup;
    private transient MetaField _metaField;
    private transient MetaField _pcdIdMetaField;
    private transient MetaField _pcdParentIdMetaField;
    private transient MetaField _sortAccordingMetaField;

    public AnalyticalField copy() {
        AnalyticalField target = new AnalyticalField();
        target.id = this.id;
        target.name = this.name;
        target.displayName = this.displayName;
        target.role = this.role;
        target.isContinuous = this.isContinuous;
        target.aggregation = this.aggregation;
        target.totalUsing = this.totalUsing;
        target.isShowSubtotal = this.isShowSubtotal;
        target.numberFormat = this.numberFormat;
        target.dateFormat = this.dateFormat;
        target.continuousColor = this.continuousColor;
        target.partValue = this.partValue;
        target.sort = this.sort;
        target.quickSetup = this.quickSetup;
        target._metaField = this._metaField;
        target._pcdIdMetaField = this._pcdIdMetaField;
        target._pcdParentIdMetaField = this._pcdParentIdMetaField;
        target._sortAccordingMetaField = this._sortAccordingMetaField;
        return target;
    }

    public void bindMetaField(MetaField mf) {
        this._metaField = mf;
        this.dealQuickSetup();
    }

    public MetaField getMetaField() {
        return this._metaField;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    private String getUsableDisplayName() {
        String text = this.displayName;
        if ((text == null || text.trim() == "") && (text = this._metaField.getPureDisplayName()) == null) {
            text = "";
        }
        return text;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public boolean isDimension() {
        return ROLE_DIMENSION.equals(this.role);
    }

    public boolean isMeasure() {
        return ROLE_MEASURE.equals(this.role);
    }

    public boolean isProperty() {
        return this.isMeasure() && this.aggregation == Aggregation.PROPERTIES;
    }

    public boolean isContinuous() {
        return this.isContinuous;
    }

    public void setContinuous(boolean isContinuous) {
        this.isContinuous = isContinuous;
    }

    public Aggregation getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(Aggregation aggregation) {
        this.aggregation = aggregation;
    }

    public Aggregation getTotalUsing() {
        return this.totalUsing;
    }

    public void setTotalUsing(Aggregation totalUsing) {
        this.totalUsing = totalUsing;
    }

    public boolean isTotalDisplay() {
        return this.isTotalDisplay;
    }

    public void setTotalDisplay(boolean isTotalDisplay) {
        this.isTotalDisplay = isTotalDisplay;
    }

    public boolean isShowSubtotal() {
        return this.isShowSubtotal;
    }

    public void setShowSubtotal(boolean isShowSubtotal) {
        this.isShowSubtotal = isShowSubtotal;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(String formatString) {
        this.numberFormat = formatString;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String formatString) {
        this.dateFormat = formatString;
    }

    public String getUsableNumberFormat() {
        return this.numberFormat == null ? this._metaField.getFormatString() : this.numberFormat;
    }

    public String getUsableDateFormat(II18nContext i18nCtx) {
        String format = this.dateFormat;
        if (format == null) {
            PartValue pv;
            PartValue partValue = pv = this.partValue == null ? PartValue.DATE_EXACT : this.partValue;
            if (this.isDimension() && this.isContinuous) {
                switch (pv) {
                    case DATE_YEAR: {
                        format = "yyyy";
                        break;
                    }
                    case DATE_QUARTER: 
                    case DATE_YQ: {
                        format = "yyyy'Q'q";
                        break;
                    }
                    case DATE_MONTH: 
                    case DATE_YM: {
                        format = "yyyy-M";
                        break;
                    }
                    default: {
                        format = "yyyy-M-d";
                        break;
                    }
                }
            } else {
                switch (pv) {
                    case DATE_YEAR: {
                        format = this.getFiscalYearStart() > 1 ? "'FY' yyyy" : "yyyy";
                        break;
                    }
                    case DATE_QUARTER: {
                        format = Messages.getLangMessage(i18nCtx, "formatQuarter", "\u7b2cq\u5b63\u5ea6");
                        break;
                    }
                    case DATE_MONTH: {
                        format = Messages.getLangMessage(i18nCtx, "formatMonth", "M\u6708");
                        break;
                    }
                    case DATE_DAY: {
                        format = "d";
                        break;
                    }
                    case DATE_YQ: {
                        format = "yyyy'Q'q";
                        break;
                    }
                    case DATE_YM: {
                        format = Messages.getLangMessage(i18nCtx, "formatYM", "yyyy\u5e74M\u6708");
                        break;
                    }
                    case DATE_YMD: {
                        format = Messages.getLangMessage(i18nCtx, "formatYMD", "yyyy\u5e74M\u6708d\u65e5");
                        break;
                    }
                    default: {
                        format = "yyyy-MM-dd";
                    }
                }
            }
        }
        return format;
    }

    public String getUsableFormat(II18nContext i18nCtx) {
        if (this.isFormatingAsDate()) {
            return this.getUsableDateFormat(i18nCtx);
        }
        return this.getUsableNumberFormat();
    }

    public boolean isFormatingAsDate() {
        return this.getDataType() == DataType.DATE && (this.isDimension() || this.isMeasure() && this.getAggregation() != Aggregation.CNT && this.getAggregation() != Aggregation.CNTD);
    }

    public ContinuousColor getContinuousColor() {
        return this.continuousColor;
    }

    public void setContinuousColor(ContinuousColor continuousColor) {
        this.continuousColor = continuousColor;
    }

    public PartValue getPartValue() {
        return this.partValue;
    }

    public void setPartValue(PartValue partValue) {
        this.partValue = partValue;
    }

    public DataType getDataType() {
        return this._metaField.getDataType();
    }

    public int getFiscalYearStart() {
        return this._metaField.getFiscalYearStart();
    }

    public boolean isSame(AnalyticalField another) {
        if (another == null) {
            return false;
        }
        return this.name.equals(another.name) && this.role.equals(another.role) && this.isContinuous == another.isContinuous && (this.aggregation == null && another.aggregation == null || this.aggregation != null && this.aggregation == another.aggregation) && this.partValue == another.partValue && this.quickSetup == another.quickSetup && this.totalUsing == another.totalUsing;
    }

    public String getTitle(II18nContext i18nCtx) {
        boolean isWithAgg = this.aggregation != null && this.aggregation != Aggregation.SUM;
        return this.getTitle(i18nCtx, this.isMeasure() && isWithAgg);
    }

    private String getTitle(II18nContext i18nCtx, boolean isWithAggregation) {
        String pv;
        if (this.displayName != null && this.displayName.trim() != "") {
            return this.displayName;
        }
        StringBuilder text = new StringBuilder(this.getUsableDisplayName());
        if (isWithAggregation) {
            String aggText = this.aggregation.getText(i18nCtx);
            if (aggText != null) {
                text.append(aggText);
            }
        } else if (this.partValue != null && (pv = this.partValue.getText(i18nCtx)) != null && !"".equals(pv)) {
            text.append("(");
            text.append(pv);
            text.append(")");
        }
        if (this.quickSetup != null) {
            text.append(Messages.getLangMessage(i18nCtx, "of", "\u7684"));
            text.append(this.quickSetup.getText(i18nCtx));
        }
        return text.toString();
    }

    public Order getSort() {
        return this.sort;
    }

    public void setSort(Order sort) {
        this.sort = sort;
    }

    public QuickSetup getQuickSetup() {
        return this.quickSetup;
    }

    public void setQuickSetup(QuickSetup quickSetup) {
        this.quickSetup = quickSetup;
    }

    private void dealQuickSetup() {
        if (this.quickSetup == null || !this.isMeasure()) {
            return;
        }
        MetaField mf = new MetaField();
        mf.setPureName("qing_sys_" + System.currentTimeMillis() + "_" + Math.round(Math.random() * 10000.0));
        mf.setPureDisplayName(this.displayName == null ? this._metaField.getPureDisplayName() : this.displayName);
        mf.setDataType(DataType.NUMBER);
        mf.setFormatString(this._metaField.getFormatString());
        mf.setFormula(this.quickSetup.createFormula(this._metaField.getFullName(), this.aggregation));
        mf.setFormulaAggStatus(this.quickSetup.getFormulaAggStatus());
        try {
            mf.setExpr(MetaFieldFormulaParser.parse(mf.getFormula(), new ContextRelativedExprConfirmer()));
        }
        catch (ParserException e) {
            mf.setInvalid(true);
        }
        mf.setMetaTable(this._metaField.getMetaTable());
        Set<String> dependence = this._metaField.getAllDependence();
        if (dependence == null) {
            dependence = new HashSet<String>();
            dependence.add(this._metaField.getFullName());
        }
        mf.setAllDependence(dependence);
        this._metaField = mf;
    }

    public void toXml(Element node) {
        XmlUtil.writeAttrWhenExist((Element)node, (String)"id", (String)this.id);
        XmlUtil.writeAttrNotNull((Element)node, (String)"name", (String)this.name);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"displayName", (String)this.displayName);
        XmlUtil.writeAttrNotNull((Element)node, (String)"role", (String)this.role);
        if (this.isDimension()) {
            XmlUtil.writeAttrDefaultFalse((Element)node, (String)"showSubtotal", (boolean)this.isShowSubtotal);
            if (this.sort != null) {
                XmlUtil.writeAttrNotNull((Element)node, (String)"sort", (String)this.sort.toPersistance());
            }
        } else if (this.isMeasure()) {
            XmlUtil.writeAttrNotNull((Element)node, (String)"aggregation", (String)this.aggregation.toPersistance());
            XmlUtil.writeAttrDefaultTrue((Element)node, (String)"totalDisplay", (boolean)this.isTotalDisplay);
            if (this.totalUsing != null) {
                XmlUtil.writeAttrNotNull((Element)node, (String)"totalUsing", (String)this.totalUsing.toPersistance());
            }
            if (this.quickSetup != null) {
                XmlUtil.writeAttrNotNull((Element)node, (String)"quickSetup", (String)this.quickSetup.toPersistance());
            }
        } else {
            throw new RuntimeException("Modify here");
        }
        XmlUtil.writeAttrDefaultFalse((Element)node, (String)"continue", (boolean)this.isContinuous);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"numberFormat", (String)this.numberFormat);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"dateFormat", (String)this.dateFormat);
        if (this.continuousColor != null) {
            Element nodeContinuousColor = new Element("ContinuousColor");
            this.continuousColor.toXml(nodeContinuousColor);
            node.addContent((Content)nodeContinuousColor);
        }
        if (this.partValue != null) {
            XmlUtil.writeAttrNotNull((Element)node, (String)"partValue", (String)this.partValue.toPersistance());
        }
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        block16: {
            this.id = XmlUtil.readAttrWhenExist((Element)node, (String)"id");
            try {
                this.name = XmlUtil.readAttrNotNull((Element)node, (String)"name");
                this.displayName = XmlUtil.readAttrWhenExist((Element)node, (String)"displayName");
                this.role = XmlUtil.readAttrNotNull((Element)node, (String)"role");
                if (this.isDimension()) {
                    this.isShowSubtotal = XmlUtil.readAttrDefaultFalse((Element)node, (String)"showSubtotal");
                    String sort = XmlUtil.readAttrWhenExist((Element)node, (String)"sort");
                    try {
                        this.sort = sort == null ? null : Order.fromPersistance(sort);
                    }
                    catch (PersistentModelParseException ex) {
                        this.sort = Order.ASC;
                    }
                    break block16;
                }
                if (this.isMeasure()) {
                    String aggr = XmlUtil.readAttrNotNull((Element)node, (String)"aggregation");
                    try {
                        this.aggregation = Aggregation.fromPersistance(aggr);
                    }
                    catch (PersistentModelParseException ex) {
                        this.aggregation = Aggregation.CNT;
                    }
                    this.isTotalDisplay = XmlUtil.readAttrDefaultTrue((Element)node, (String)"totalDisplay");
                    aggr = XmlUtil.readAttrWhenExist((Element)node, (String)"totalUsing");
                    try {
                        this.totalUsing = aggr == null ? null : Aggregation.fromPersistance(aggr);
                    }
                    catch (PersistentModelParseException ex) {
                        this.totalUsing = null;
                    }
                    String qs = XmlUtil.readAttrWhenExist((Element)node, (String)"quickSetup");
                    this.quickSetup = qs == null ? null : QuickSetup.fromPersistance(qs);
                    break block16;
                }
                throw new PersistentModelParseException("Invalid attribute 'role': " + this.role);
            }
            catch (XmlUtil.NullException ex) {
                throw new PersistentModelParseException(ex);
            }
        }
        this.isContinuous = XmlUtil.readAttrDefaultFalse((Element)node, (String)"continue");
        this.numberFormat = XmlUtil.readAttrWhenExist((Element)node, (String)"numberFormat");
        this.dateFormat = XmlUtil.readAttrWhenExist((Element)node, (String)"dateFormat");
        this.continuousColor = null;
        Element nodeContinuousColor = XmlUtil.getChild((Element)node, (String)"ContinuousColor");
        if (nodeContinuousColor != null) {
            this.continuousColor = new ContinuousColor();
            this.continuousColor.fromXml(nodeContinuousColor);
        }
        this.partValue = null;
        String partValue = XmlUtil.readAttrWhenExist((Element)node, (String)"partValue");
        if (partValue == null) {
            if (this.numberFormat == null) {
                this.numberFormat = XmlUtil.readAttrWhenExist((Element)node, (String)"format");
            }
        } else {
            try {
                this.partValue = PartValue.fromPersistance(partValue);
            }
            catch (PersistentModelParseException ex) {
                this.partValue = PartValue.DATE_YEAR;
            }
        }
    }

    private void bindParentChildDimensionMetaField(MetaField idMf, MetaField parentIdMf, MetaField sortAccordingMf) {
        this._pcdIdMetaField = idMf;
        this._pcdParentIdMetaField = parentIdMf;
        this._sortAccordingMetaField = sortAccordingMf;
    }

    public MetaField getParentChildDimensionIdField() {
        return this._pcdIdMetaField;
    }

    public MetaField getParentChildDimensionParentIdField() {
        return this._pcdParentIdMetaField;
    }

    private void bindSortAccordingField(MetaField sortAccordingMetafield) {
        this._sortAccordingMetaField = sortAccordingMetafield;
    }

    public MetaField getSortAccordingField() {
        return this._sortAccordingMetaField;
    }

    public boolean isOrderDefined() {
        return this.getMetaField().isOrderCustomized() || this._sortAccordingMetaField != null;
    }

    public boolean isParentChildDimension() {
        return this._pcdIdMetaField != null && this._pcdParentIdMetaField != null;
    }

    public void fixMetaFieldBinding(Map<String, MetaField> metaFields) {
        MetaField mf = MetaField.getNotNullInstance(metaFields, this.getName());
        this.bindMetaField(mf);
        if (this.isDimension()) {
            String sortAccordingFieldFullName;
            MetaTable mt;
            List<ParentChildDimension> pcds;
            if (mf.getGroupName() != null && (pcds = (mt = mf.getMetaTable()).getParentChildDimensions()) != null) {
                String tableName = mt.getName();
                for (ParentChildDimension pcd : pcds) {
                    if (!mf.getGroupName().equals(pcd.getName())) continue;
                    MetaField idMf = metaFields.get(NameUtil.encodeFullName((String)tableName, (String)pcd.getIdFieldName()));
                    MetaField parentIdMf = metaFields.get(NameUtil.encodeFullName((String)tableName, (String)pcd.getParentIdFieldName()));
                    MetaField sortAccordingMf = null;
                    if (pcd.getSortAccordingFieldName() != null && !mf.isOrderCustomized()) {
                        sortAccordingMf = metaFields.get(NameUtil.encodeFullName((String)tableName, (String)pcd.getSortAccordingFieldName()));
                    }
                    this.bindParentChildDimensionMetaField(idMf, parentIdMf, sortAccordingMf);
                    break;
                }
            }
            if ((sortAccordingFieldFullName = mf.getSortAccordingFieldFullName()) != null && !mf.isOrderCustomized()) {
                MetaField sortAccordingMetaField = MetaField.getNotNullInstance(metaFields, sortAccordingFieldFullName);
                this.bindSortAccordingField(sortAccordingMetaField);
            }
        }
    }

    public boolean isCanPullDown() {
        return this.isDimension() && !this.getMetaField().isCalculation() && (this._sortAccordingMetaField == null || !this._sortAccordingMetaField.isCalculation());
    }

    private static class ContextRelativedExprConfirmer
    implements IContextRelativedExprConfirmer {
        private ContextRelativedExprConfirmer() {
        }

        public void checkRefExpr(RefExpr expr) throws ParserException {
            expr.setReturnDataType(2);
        }

        public void checkVariantExpr(VariantExpr expr) throws ParserException {
        }
    }
}

