/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.common;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.i18n.Messages;

public enum PartValue {
    DATE_EXACT("empty", ""),
    DATE_YEAR("year", "\u5e74"),
    DATE_QUARTER("quarter", "\u5b63\u5ea6"),
    DATE_MONTH("month", "\u6708"),
    DATE_DAY("day", "\u65e5"),
    DATE_YQ("yq", "\u5e74\u5b63"),
    DATE_YM("ym", "\u5e74\u6708"),
    DATE_YMD("ymd", "\u5e74\u6708\u65e5");

    private String _rsKey;
    private String _text;

    private PartValue(String rsKey, String text) {
        this._rsKey = rsKey;
        this._text = text;
    }

    public String getText(II18nContext i18nCtx) {
        if ("".equals(this._text)) {
            return this._text;
        }
        return Messages.getLangMessage(i18nCtx, this._rsKey, this._text);
    }

    public String toPersistance() {
        return this.name();
    }

    public static PartValue fromPersistance(String name) throws PersistentModelParseException {
        try {
            return PartValue.valueOf(name);
        }
        catch (Exception ex) {
            throw new PersistentModelParseException("Unknown PartValue: " + name);
        }
    }

    public static int constraintFormating(PartValue partValue) {
        int formatingPart;
        if (partValue == null) {
            return 0;
        }
        switch (partValue) {
            case DATE_YEAR: {
                formatingPart = 1;
                break;
            }
            case DATE_QUARTER: {
                formatingPart = 2;
                break;
            }
            case DATE_MONTH: {
                formatingPart = 4;
                break;
            }
            case DATE_DAY: {
                formatingPart = 8;
                break;
            }
            case DATE_YQ: {
                formatingPart = 3;
                break;
            }
            case DATE_YM: {
                formatingPart = 5;
                break;
            }
            default: {
                formatingPart = 0;
            }
        }
        return formatingPart;
    }
}

