/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.common;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.util.XmlUtil;
import org.jdom2.Element;

public class Refline {
    private int measure = 0;
    private ReflineType type = ReflineType.AVG;
    private String value;
    private String label;

    public void setMeasureIndex(int measure) {
        this.measure = measure;
    }

    public int getMeasureIndex() {
        return this.measure;
    }

    public void setType(ReflineType type) {
        this.type = type;
    }

    public ReflineType getType() {
        return this.type;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setLabel(String text) {
        this.label = text;
    }

    public String getLabel() {
        return this.label;
    }

    public Element toXml() {
        Element node = new Element("Refline");
        XmlUtil.writeAttrIntWhenExist((Element)node, (String)"measure", (Integer)this.measure);
        XmlUtil.writeAttrNotNull((Element)node, (String)"type", (String)this.type.toPersistance());
        XmlUtil.writeAttrWhenExist((Element)node, (String)"value", (String)this.value);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"label", (String)this.label);
        return node;
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        Integer measure = XmlUtil.readAttrIntWhenExist((Element)node, (String)"measure");
        this.measure = measure == null ? 0 : measure;
        try {
            String type = XmlUtil.readAttrNotNull((Element)node, (String)"type");
            this.type = ReflineType.fromPersistance(type);
        }
        catch (XmlUtil.NullException e) {
            this.type = ReflineType.AVG;
        }
        this.value = XmlUtil.readAttrWhenExist((Element)node, (String)"value");
        this.label = XmlUtil.readAttrWhenExist((Element)node, (String)"label");
    }

    public static enum ReflineType {
        AVG,
        MEDIAN,
        CONST;


        public String toPersistance() {
            return this.name();
        }

        public static ReflineType fromPersistance(String name) {
            try {
                return ReflineType.valueOf(name);
            }
            catch (Exception ex) {
                return AVG;
            }
        }
    }
}

