/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.common.brief;

import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class BriefOutputDefinition {
    private String name;
    private String description;
    private List<AbstractPicker> dimensionPickers;
    private List<AbstractPicker> measurePickers;
    private String postScript;
    private transient IExpr _postScriptExpr;

    public String getName() {
        return this.name;
    }

    public List<AbstractPicker> getDimensionPickers() {
        return this.dimensionPickers;
    }

    public void setDimensionPickers(List<AbstractPicker> pickers) {
        this.dimensionPickers = pickers;
    }

    public List<AbstractPicker> getMeasurePickers() {
        return this.measurePickers;
    }

    public void setMeasurePickers(List<AbstractPicker> pickers) {
        this.measurePickers = pickers;
    }

    public String getPostScript() {
        return this.postScript;
    }

    public void setPostScriptExpr(IExpr expr) {
        this._postScriptExpr = expr;
    }

    public IExpr getPostScriptExpr() {
        return this._postScriptExpr;
    }

    public void toXml(Element node) {
        XmlUtil.writeAttrNotNull((Element)node, (String)"name", (String)this.name);
        if (this.description != null) {
            Element nodeDescription = new Element("Description");
            XmlUtil.addCDATA((Element)nodeDescription, (String)this.description);
            node.addContent((Content)nodeDescription);
        }
        Element nodePickers = new Element("Pickers");
        for (AbstractPicker dp : this.dimensionPickers) {
            Element nodeDimensionPicker = new Element("Dimension");
            dp.toXml(nodeDimensionPicker);
            nodePickers.addContent((Content)nodeDimensionPicker);
        }
        for (AbstractPicker mp : this.measurePickers) {
            Element nodeMeasurePicker = new Element("Measure");
            mp.toXml(nodeMeasurePicker);
            nodePickers.addContent((Content)nodeMeasurePicker);
        }
        node.addContent((Content)nodePickers);
        if (this.postScript != null) {
            Element nodePostScript = new Element("PostScript");
            XmlUtil.addCDATA((Element)nodePostScript, (String)this.postScript);
            node.addContent((Content)nodePostScript);
        }
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        Element nodePickers;
        try {
            this.name = XmlUtil.readAttrNotNull((Element)node, (String)"name");
        }
        catch (XmlUtil.NullException e) {
            throw new PersistentModelParseException("The name is not specified in BriefOutputDefinition.");
        }
        Element nodeDescription = XmlUtil.getChild((Element)node, (String)"Description");
        if (nodeDescription != null) {
            this.description = nodeDescription.getTextTrim();
        }
        try {
            nodePickers = XmlUtil.getChildNotNull((Element)node, (String)"Pickers");
        }
        catch (XmlUtil.NullException e) {
            throw new PersistentModelParseException("The <Pickers> node is missing.");
        }
        List dimensionPickerNodes = XmlUtil.getChildren((Element)nodePickers, (String)"Dimension");
        this.dimensionPickers = new ArrayList<AbstractPicker>(dimensionPickerNodes.size());
        for (Object nodeDimensionPicker : dimensionPickerNodes) {
            AbstractPicker dp = this.createPicker((Element)nodeDimensionPicker);
            dp.fromXml((Element)nodeDimensionPicker);
            this.dimensionPickers.add(dp);
        }
        List measurePickerNodes = XmlUtil.getChildren((Element)nodePickers, (String)"Measure");
        this.measurePickers = new ArrayList<AbstractPicker>(measurePickerNodes.size());
        for (Element nodeMeasurePicker : measurePickerNodes) {
            AbstractPicker mp = this.createPicker(nodeMeasurePicker);
            mp.fromXml(nodeMeasurePicker);
            this.measurePickers.add(mp);
        }
        Element nodePostScript = XmlUtil.getChild((Element)node, (String)"PostScript");
        this.postScript = nodePostScript == null ? null : nodePostScript.getTextTrim();
    }

    private AbstractPicker createPicker(Element nodePicker) throws PersistentModelParseException {
        PickerType type = AbstractPicker.readType(nodePicker);
        switch (type) {
            case FULL: {
                return new FullPicker();
            }
            case CONDITION: {
                return new ConditionPicker();
            }
            case MAX: {
                return new MaxPicker();
            }
            case MIN: {
                return new MinPicker();
            }
        }
        throw new PersistentModelParseException("Unknown type: " + type.name());
    }

    public static class MinPicker
    extends AbstractComparingPicker {
        @Override
        public PickerType getType() {
            return PickerType.MIN;
        }
    }

    public static class MaxPicker
    extends AbstractComparingPicker {
        @Override
        public PickerType getType() {
            return PickerType.MAX;
        }
    }

    public static abstract class AbstractComparingPicker
    extends AbstractPicker {
        private int topN = 1;

        public int getTopN() {
            return this.topN;
        }

        @Override
        protected void toXmlImpl(Element node) {
            XmlUtil.writeAttrInt((Element)node, (String)"topN", (int)this.topN);
        }

        @Override
        protected void fromXmlImpl(Element node) {
            try {
                this.topN = XmlUtil.readAttrInt((Element)node, (String)"topN");
            }
            catch (XmlUtil.NullException ex) {
                this.topN = 1;
            }
        }
    }

    public static class ConditionPicker
    extends AbstractPicker {
        private String conditionScript;
        private transient IExpr _conditionExpr;

        @Override
        public PickerType getType() {
            return PickerType.CONDITION;
        }

        public String getConditionScript() {
            return this.conditionScript;
        }

        public IExpr getConditionExpr() {
            return this._conditionExpr;
        }

        public void setConditionExpr(IExpr expr) {
            this._conditionExpr = expr;
        }

        @Override
        protected void toXmlImpl(Element node) {
            Element nodeCondition = new Element("Condition");
            XmlUtil.addCDATA((Element)nodeCondition, (String)this.conditionScript);
            node.addContent((Content)nodeCondition);
        }

        @Override
        protected void fromXmlImpl(Element node) {
            Element nodeCondition = XmlUtil.getChild((Element)node, (String)"Condition");
            this.conditionScript = nodeCondition == null ? null : nodeCondition.getTextTrim();
        }
    }

    public static class FullPicker
    extends AbstractPicker {
        @Override
        public PickerType getType() {
            return PickerType.FULL;
        }

        @Override
        protected void toXmlImpl(Element node) {
        }

        @Override
        protected void fromXmlImpl(Element node) {
        }
    }

    public static abstract class AbstractPicker {
        private String fieldId;
        private Boolean sortAsc;
        private Integer outputTarget;
        private PickerType type = this.getType();

        public abstract PickerType getType();

        public String getFieldId() {
            return this.fieldId;
        }

        public boolean isSortAccording() {
            return this.sortAsc != null;
        }

        public boolean isSortAsc() {
            return this.isSortAccording() && this.sortAsc != false;
        }

        public boolean isOutputTarget() {
            return this.outputTarget != null;
        }

        public int getOutputTargetIndex() {
            return this.outputTarget;
        }

        public final void toXml(Element node) {
            XmlUtil.writeAttrNotNull((Element)node, (String)"fieldId", (String)this.fieldId);
            XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"sortAsc", (Boolean)this.sortAsc);
            XmlUtil.writeAttrIntWhenExist((Element)node, (String)"outputTarget", (Integer)this.outputTarget);
            XmlUtil.writeAttrNotNull((Element)node, (String)"type", (String)this.type.toPersistance());
            this.toXmlImpl(node);
        }

        protected abstract void toXmlImpl(Element var1);

        public final void fromXml(Element node) throws PersistentModelParseException {
            try {
                this.fieldId = XmlUtil.readAttrNotNull((Element)node, (String)"fieldId");
            }
            catch (XmlUtil.NullException e) {
                throw new PersistentModelParseException("The 'fieldId' attribute of Picker is missing.");
            }
            this.sortAsc = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"sortAsc");
            this.outputTarget = XmlUtil.readAttrIntWhenExist((Element)node, (String)"outputTarget");
            this.fromXmlImpl(node);
        }

        protected abstract void fromXmlImpl(Element var1);

        public static PickerType readType(Element node) throws PersistentModelParseException {
            String type;
            try {
                type = XmlUtil.readAttrNotNull((Element)node, (String)"type");
            }
            catch (XmlUtil.NullException e) {
                throw new PersistentModelParseException("The 'type' attribute of Picker is missing.");
            }
            return PickerType.fromPersistance(type);
        }
    }

    public static enum PickerType {
        FULL,
        CONDITION,
        MAX,
        MIN;


        public String toPersistance() {
            return this.name();
        }

        public static PickerType fromPersistance(String name) throws PersistentModelParseException {
            try {
                return PickerType.valueOf(name);
            }
            catch (Exception ex) {
                throw new PersistentModelParseException("Unknown PickerType: " + name);
            }
        }
    }

    public static class JsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractPicker> {
        protected AbstractPicker decode(JsonUtil.AbstractJsonDecoder.Json json) {
            String type = json.getAttrValue("type");
            switch (PickerType.valueOf(type)) {
                case FULL: {
                    return (AbstractPicker)this.fromJson(json, FullPicker.class);
                }
                case CONDITION: {
                    return (AbstractPicker)this.fromJson(json, ConditionPicker.class);
                }
                case MAX: {
                    return (AbstractPicker)this.fromJson(json, MaxPicker.class);
                }
                case MIN: {
                    return (AbstractPicker)this.fromJson(json, MinPicker.class);
                }
            }
            throw new RuntimeException("Unknown type: " + type);
        }
    }
}

