/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.common.brief;

import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class WarningRuleDefinition {
    private String name;
    private String description;
    private List<ConditionItem> items;
    private String postScript;
    private transient IExpr _postScriptExpr;

    public String getName() {
        return this.name;
    }

    public List<ConditionItem> getConditionItems() {
        return this.items;
    }

    public String getPostScript() {
        return this.postScript;
    }

    public void setPostScriptExpr(IExpr expr) {
        this._postScriptExpr = expr;
    }

    public IExpr getPostScriptExpr() {
        return this._postScriptExpr;
    }

    public void toXml(Element node) {
        XmlUtil.writeAttrNotNull((Element)node, (String)"name", (String)this.name);
        if (this.description != null) {
            Element nodeDescription = new Element("Description");
            XmlUtil.addCDATA((Element)nodeDescription, (String)this.description);
            node.addContent((Content)nodeDescription);
        }
        Element nodeConditions = new Element("Conditions");
        for (ConditionItem item : this.items) {
            Element nodeItem = new Element("Item");
            item.toXml(nodeItem);
            nodeConditions.addContent((Content)nodeItem);
        }
        node.addContent((Content)nodeConditions);
        if (this.postScript != null) {
            Element nodePostScript = new Element("PostScript");
            XmlUtil.addCDATA((Element)nodePostScript, (String)this.postScript);
            node.addContent((Content)nodePostScript);
        }
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        Element nodeConditions;
        try {
            this.name = XmlUtil.readAttrNotNull((Element)node, (String)"name");
        }
        catch (XmlUtil.NullException e) {
            throw new PersistentModelParseException("The name is not specified in WarningRuleDefinition.");
        }
        Element nodeDescription = XmlUtil.getChild((Element)node, (String)"Description");
        if (nodeDescription != null) {
            this.description = nodeDescription.getTextTrim();
        }
        try {
            nodeConditions = XmlUtil.getChildNotNull((Element)node, (String)"Conditions");
        }
        catch (XmlUtil.NullException e) {
            throw new PersistentModelParseException("The <Conditions> node is missing.");
        }
        List itemNodes = XmlUtil.getChildren((Element)nodeConditions, (String)"Item");
        this.items = new ArrayList<ConditionItem>(itemNodes.size());
        for (Element nodeItem : itemNodes) {
            ConditionItem item = new ConditionItem();
            item.fromXml(nodeItem);
            this.items.add(item);
        }
        Element nodePostScript = XmlUtil.getChild((Element)node, (String)"PostScript");
        this.postScript = nodePostScript == null ? null : nodePostScript.getTextTrim();
    }

    public static class CustomCondition
    extends AbstractCondition {
        private String conditionScript;
        private transient IExpr _conditionExpr;

        @Override
        public ConditionType getType() {
            return ConditionType.CUSTOM;
        }

        public String getConditionScript() {
            return this.conditionScript;
        }

        public IExpr getConditionExpr() {
            return this._conditionExpr;
        }

        public void setConditionExpr(IExpr expr) {
            this._conditionExpr = expr;
        }

        @Override
        protected void toXmlImpl(Element node) {
            Element nodeCustom = new Element("Custom");
            XmlUtil.addCDATA((Element)nodeCustom, (String)this.conditionScript);
            node.addContent((Content)nodeCustom);
        }

        @Override
        protected void fromXmlImpl(Element node) {
            Element nodeCustom = XmlUtil.getChild((Element)node, (String)"Custom");
            this.conditionScript = nodeCustom == null ? null : nodeCustom.getTextTrim();
        }
    }

    public static class NormalCondition
    extends AbstractCondition {
        private Operation op;
        private String comparing;

        public Operation getOperation() {
            return this.op;
        }

        public String getComparing() {
            return this.comparing;
        }

        @Override
        public ConditionType getType() {
            return ConditionType.NORMAL;
        }

        @Override
        protected void toXmlImpl(Element node) {
            Element nodeNormal = new Element("Normal");
            XmlUtil.writeAttrNotNull((Element)nodeNormal, (String)"op", (String)this.op.toPersistance());
            XmlUtil.writeAttrWhenExist((Element)nodeNormal, (String)"value", (String)this.comparing);
            node.addContent((Content)nodeNormal);
        }

        @Override
        protected void fromXmlImpl(Element node) throws PersistentModelParseException {
            Element nodeNormal = XmlUtil.getChild((Element)node, (String)"Normal");
            String opStr = XmlUtil.readAttrWhenExist((Element)nodeNormal, (String)"op");
            this.op = opStr == null ? Operation.E : Operation.fromPersistance(opStr);
            this.comparing = XmlUtil.readAttrWhenExist((Element)nodeNormal, (String)"value");
        }
    }

    public static enum Operation {
        E,
        NOT_E,
        N,
        NOT_N,
        G,
        GE,
        L,
        LE;


        public String toPersistance() {
            return this.name();
        }

        public static Operation fromPersistance(String name) throws PersistentModelParseException {
            try {
                return Operation.valueOf(name);
            }
            catch (Exception ex) {
                throw new PersistentModelParseException("Unknown Operation: " + name);
            }
        }
    }

    public static abstract class AbstractCondition {
        private String fieldId;
        private ConditionType type = this.getType();

        public abstract ConditionType getType();

        public String getFieldId() {
            return this.fieldId;
        }

        public final void toXml(Element node) {
            XmlUtil.writeAttrNotNull((Element)node, (String)"fieldId", (String)this.fieldId);
            XmlUtil.writeAttrNotNull((Element)node, (String)"type", (String)this.type.toPersistance());
            this.toXmlImpl(node);
        }

        protected abstract void toXmlImpl(Element var1);

        public final void fromXml(Element node) throws PersistentModelParseException {
            try {
                this.fieldId = XmlUtil.readAttrNotNull((Element)node, (String)"fieldId");
            }
            catch (XmlUtil.NullException e) {
                throw new PersistentModelParseException("The 'fieldId' attribute of Condition is missing.");
            }
            this.fromXmlImpl(node);
        }

        protected abstract void fromXmlImpl(Element var1) throws PersistentModelParseException;

        public static ConditionType readType(Element node) throws PersistentModelParseException {
            String type;
            try {
                type = XmlUtil.readAttrNotNull((Element)node, (String)"type");
            }
            catch (XmlUtil.NullException e) {
                throw new PersistentModelParseException("The 'type' attribute of Condition is missing.");
            }
            return ConditionType.fromPersistance(type);
        }
    }

    public static enum ConditionType {
        NORMAL,
        CUSTOM;


        public String toPersistance() {
            return this.name();
        }

        public static ConditionType fromPersistance(String name) throws PersistentModelParseException {
            try {
                return ConditionType.valueOf(name);
            }
            catch (Exception ex) {
                throw new PersistentModelParseException("Unknown ConditionType: " + name);
            }
        }
    }

    public static class JsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractCondition> {
        protected AbstractCondition decode(JsonUtil.AbstractJsonDecoder.Json json) {
            String type = json.getAttrValue("type");
            switch (ConditionType.valueOf(type)) {
                case NORMAL: {
                    return (AbstractCondition)this.fromJson(json, NormalCondition.class);
                }
                case CUSTOM: {
                    return (AbstractCondition)this.fromJson(json, CustomCondition.class);
                }
            }
            throw new RuntimeException("Unknown type: " + type);
        }
    }

    public static enum Logic {
        AND(0),
        OR(0);

        private transient int _priority;

        private Logic(int priority) {
            this._priority = priority;
        }

        public int getPriority() {
            return this._priority;
        }

        public String toPersistance() {
            return this.name();
        }

        public static Logic fromPersistance(String name) throws PersistentModelParseException {
            try {
                return Logic.valueOf(name);
            }
            catch (Exception ex) {
                throw new PersistentModelParseException("Unknown Logic: " + name);
            }
        }
    }

    public static class ConditionItem {
        private Integer leftBrackets;
        private AbstractCondition condition;
        private Integer rightBrackets;
        private Logic logic;

        public int getLeftBrackets() {
            return this.leftBrackets == null ? 0 : this.leftBrackets;
        }

        public int getRightBrackets() {
            return this.rightBrackets == null ? 0 : this.rightBrackets;
        }

        public Logic getLogic() {
            return this.logic;
        }

        public AbstractCondition getCondition() {
            return this.condition;
        }

        public void toXml(Element node) {
            XmlUtil.writeAttrIntWhenExist((Element)node, (String)"lb", (Integer)this.leftBrackets);
            XmlUtil.writeAttrIntWhenExist((Element)node, (String)"rb", (Integer)this.rightBrackets);
            if (this.logic != null) {
                XmlUtil.writeAttrNotNull((Element)node, (String)"logic", (String)this.logic.toPersistance());
            }
            if (this.condition != null) {
                Element nodeCondition = new Element("Condition");
                this.condition.toXml(nodeCondition);
                node.addContent((Content)nodeCondition);
            }
        }

        public void fromXml(Element node) throws PersistentModelParseException {
            this.leftBrackets = XmlUtil.readAttrIntWhenExist((Element)node, (String)"lb");
            this.rightBrackets = XmlUtil.readAttrIntWhenExist((Element)node, (String)"rb");
            String logicStr = XmlUtil.readAttrWhenExist((Element)node, (String)"logic");
            this.logic = logicStr == null ? null : Logic.fromPersistance(logicStr);
            this.condition = null;
            Element nodeCondition = XmlUtil.getChild((Element)node, (String)"Condition");
            if (nodeCondition != null) {
                this.condition = this.createCondition(nodeCondition);
                this.condition.fromXml(nodeCondition);
            }
        }

        private AbstractCondition createCondition(Element nodeCondition) throws PersistentModelParseException {
            ConditionType type = AbstractCondition.readType(nodeCondition);
            switch (type) {
                case NORMAL: {
                    return new NormalCondition();
                }
                case CUSTOM: {
                    return new CustomCondition();
                }
            }
            throw new PersistentModelParseException("Unknown type: " + type.name());
        }
    }
}

