/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.common.filter;

import com.kingdee.bos.qing.common.daterange.RelativeDateRange;
import com.kingdee.bos.qing.common.daterange.RuntimeRelativeDateRange;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractScopeLimitedSelectedValues;
import com.kingdee.bos.qing.util.XmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class ContinuousDateFilter
extends AbstractAnalyticalFilter {
    public static final String PERSISTENT_FILTER_NAME = "continuousDate";
    private Boolean containNull;
    private Long dateFrom;
    private Long dateTo;
    private RelativeDateRange relative;

    public ContinuousDateFilter() {
        super(PERSISTENT_FILTER_NAME);
    }

    public boolean isContainNull() {
        return this.containNull != null && this.containNull != false;
    }

    public void setContainNull(boolean isContainNull) {
        this.containNull = isContainNull;
    }

    public long getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(long dateFrom) {
        this.dateFrom = dateFrom;
    }

    public long getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(long dateTo) {
        this.dateTo = dateTo;
    }

    public RelativeDateRange getRelativeDateRange() {
        return this.relative;
    }

    public void setRelativeDateRange(RelativeDateRange relative) {
        this.relative = relative;
    }

    @Override
    public void safety() {
    }

    @Override
    public void parseForBeforeRun() {
        if (this.relative != null) {
            RuntimeRelativeDateRange rt = new RuntimeRelativeDateRange(this.relative);
            rt.parseRange();
            this.dateFrom = rt.getDateStart();
            this.dateTo = rt.getDateEnd();
        }
    }

    @Override
    public AbstractScopeLimitedSelectedValues getSlicedSelectValuesWithinScope(AbstractPreparedValue scope) {
        return null;
    }

    @Override
    protected void toXmlImpl(Element node) {
        if (this.relative != null) {
            Element nodeRelative = new Element("Relative");
            this.relative.toXml(nodeRelative);
            node.addContent((Content)nodeRelative);
        }
        XmlUtil.writeAttrLongWhenExist((Element)node, (String)"from", (Long)this.dateFrom);
        XmlUtil.writeAttrLongWhenExist((Element)node, (String)"to", (Long)this.dateTo);
        XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"containNull", (Boolean)this.containNull);
    }

    @Override
    protected void fromXmlImpl(Element node) throws PersistentModelParseException {
        this.dateFrom = XmlUtil.readAttrLongWhenExist((Element)node, (String)"from");
        this.dateTo = XmlUtil.readAttrLongWhenExist((Element)node, (String)"to");
        this.containNull = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"containNull");
        Element nodeRelative = node.getChild("Relative");
        if (nodeRelative != null) {
            this.relative = new RelativeDateRange();
            this.relative.fromXml(nodeRelative);
            RuntimeRelativeDateRange rt = new RuntimeRelativeDateRange(this.relative);
            rt.parseRange();
            this.dateFrom = rt.getDateStart();
            this.dateTo = rt.getDateEnd();
        }
    }

    @Override
    protected AbstractAnalyticalFilter doCopy() {
        ContinuousDateFilter filter = new ContinuousDateFilter();
        filter.containNull = this.containNull;
        filter.dateFrom = this.dateFrom;
        filter.dateTo = this.dateTo;
        filter.relative = this.relative;
        return filter;
    }
}

