/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.common.filter;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractScopeLimitedSelectedValues;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.ContinuousChoosableModel;
import com.kingdee.bos.qing.util.XmlUtil;
import java.math.BigDecimal;
import org.jdom2.Element;

public class ContinuousFilter
extends AbstractAnalyticalFilter {
    public static final String PERSISTENT_FILTER_NAME = "continuous";
    private BigDecimal floor;
    private BigDecimal ceiling;
    private Boolean containNull;

    public ContinuousFilter() {
        super(PERSISTENT_FILTER_NAME);
    }

    public boolean isContainNull() {
        return this.containNull != null && this.containNull != false;
    }

    public void setContainNull(boolean containNull) {
        this.containNull = containNull;
    }

    public void setFloor(BigDecimal floor) {
        this.floor = floor;
    }

    public BigDecimal getFloor() {
        return this.floor;
    }

    public void setCeiling(BigDecimal ceiling) {
        this.ceiling = ceiling;
    }

    public BigDecimal getCeiling() {
        return this.ceiling;
    }

    @Override
    public void safety() {
        this.floor = BigDecimal.ZERO;
        this.ceiling = BigDecimal.ZERO;
        this.setFullValue(true);
    }

    @Override
    public void parseForBeforeRun() {
    }

    @Override
    public AbstractScopeLimitedSelectedValues.ContinuousScopeLimitedSelectedValues getSlicedSelectValuesWithinScope(AbstractPreparedValue scope) {
        ContinuousChoosableModel choosableModel = (ContinuousChoosableModel)scope;
        BigDecimal max = choosableModel.getMax();
        BigDecimal min = choosableModel.getMin();
        boolean sliced = false;
        if (this.floor.compareTo(min) < 0) {
            this.setFloor(min);
            sliced = true;
        }
        if (this.ceiling.compareTo(max) > 0) {
            this.setCeiling(max);
            sliced = true;
        }
        if (sliced) {
            return new AbstractScopeLimitedSelectedValues.ContinuousScopeLimitedSelectedValues(this.floor, this.ceiling);
        }
        return null;
    }

    @Override
    protected void toXmlImpl(Element node) {
        XmlUtil.writeAttrNotNull((Element)node, (String)"floor", (String)this.floor.toString());
        XmlUtil.writeAttrNotNull((Element)node, (String)"ceiling", (String)this.ceiling.toString());
        XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"containNull", (Boolean)this.containNull);
    }

    @Override
    protected void fromXmlImpl(Element node) throws PersistentModelParseException {
        String ceilingStr;
        String floorStr;
        try {
            floorStr = XmlUtil.readAttrNotNull((Element)node, (String)"floor");
            ceilingStr = XmlUtil.readAttrNotNull((Element)node, (String)"ceiling");
        }
        catch (XmlUtil.NullException e) {
            throw new PersistentModelParseException(e);
        }
        this.floor = new BigDecimal(floorStr);
        this.ceiling = new BigDecimal(ceilingStr);
        this.containNull = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"containNull");
        if (this.isFullValue()) {
            this.containNull = Boolean.TRUE;
        }
    }

    @Override
    protected ContinuousFilter doCopy() {
        ContinuousFilter continuousFilter = new ContinuousFilter();
        continuousFilter.floor = this.floor;
        continuousFilter.ceiling = this.ceiling;
        continuousFilter.containNull = this.containNull;
        return continuousFilter;
    }
}

