/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.longer.preferences;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.analysis.longer.ParallelMeasureLayout;
import com.kingdee.bos.qing.util.XmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class ChartConfig {
    private Boolean showLabel;
    private Boolean showLegend;
    private TableConfig table;
    private PieChartConfig pie;
    private RectTreeChartConfig rectTree;

    public boolean isShowLabel() {
        return this.showLabel == Boolean.TRUE;
    }

    public boolean isShowLegend() {
        return this.showLegend != Boolean.FALSE;
    }

    public TableConfig getTableConfig() {
        return this.table;
    }

    public PieChartConfig getPieChartConfig() {
        return this.pie;
    }

    public RectTreeChartConfig getRectTreeChartConfig() {
        return this.rectTree;
    }

    public void toXml(Element node) {
        if (this.table != null) {
            Element xmlTable = new Element("Table");
            this.table.toXml(xmlTable);
            node.addContent((Content)xmlTable);
        }
        XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"showLabel", (Boolean)this.showLabel);
        XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"showLegend", (Boolean)this.showLegend);
        if (this.pie != null) {
            Element xmlPie = new Element("Pie");
            this.pie.toXml(xmlPie);
            node.addContent((Content)xmlPie);
        }
        if (this.rectTree != null) {
            Element xmlRectTree = new Element("RectTree");
            this.rectTree.toXml(xmlRectTree);
            node.addContent((Content)xmlRectTree);
        }
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        Element xmlRectTree;
        Element xmlTable = node.getChild("Table");
        if (xmlTable != null) {
            this.table = new TableConfig();
            this.table.fromXml(xmlTable);
        }
        this.showLabel = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"showLabel");
        this.showLegend = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"showLegend");
        Element xmlPie = node.getChild("Pie");
        if (xmlPie != null) {
            this.pie = new PieChartConfig();
            this.pie.fromXml(xmlPie);
        }
        if ((xmlRectTree = node.getChild("RectTree")) != null) {
            this.rectTree = new RectTreeChartConfig();
            this.rectTree.fromXml(xmlRectTree);
        }
    }

    public static class RectTreeChartConfig {
        private Boolean hideNegative;

        public boolean isHideNegative() {
            return this.hideNegative == Boolean.TRUE;
        }

        public void toXml(Element node) {
            XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"hideNegative", (Boolean)this.hideNegative);
        }

        public void fromXml(Element node) throws PersistentModelParseException {
            this.hideNegative = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"hideNegative");
        }
    }

    public static class PieChartConfig {
        private Integer topN;
        private Integer labelType;
        private Boolean hideNegative;

        public int getTopN() {
            return this.topN == null ? -1 : this.topN;
        }

        public boolean isHideNegative() {
            return this.hideNegative == Boolean.TRUE;
        }

        public Integer getLabelType() {
            return this.labelType;
        }

        public void toXml(Element node) {
            XmlUtil.writeAttrIntWhenExist((Element)node, (String)"topN", (Integer)this.topN);
            XmlUtil.writeAttrIntWhenExist((Element)node, (String)"labelType", (Integer)this.labelType);
            XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"hideNegative", (Boolean)this.hideNegative);
        }

        public void fromXml(Element node) throws PersistentModelParseException {
            this.topN = XmlUtil.readAttrIntWhenExist((Element)node, (String)"topN");
            this.labelType = XmlUtil.readAttrIntWhenExist((Element)node, (String)"labelType");
            this.hideNegative = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"hideNegative");
        }
    }

    public static class TableConfig {
        private Boolean totalAhead;
        private ParallelMeasureLayout parallelMeasureLayout = ParallelMeasureLayout.AtColumn;
        private Boolean frozenTop;
        private Boolean frozenLeft;

        public boolean isTotalAhead() {
            return this.totalAhead == Boolean.TRUE;
        }

        public void setTotalAhead(boolean isTotalAhead) {
            this.totalAhead = isTotalAhead;
        }

        public ParallelMeasureLayout getParallelMeasureLayout() {
            return this.parallelMeasureLayout;
        }

        public void setParallelMeasureLayout(ParallelMeasureLayout parallelMeasureLayout) {
            this.parallelMeasureLayout = parallelMeasureLayout;
        }

        public void toXml(Element node) {
            XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"totalAhead", (Boolean)this.totalAhead);
            if (this.parallelMeasureLayout != ParallelMeasureLayout.AtColumn) {
                XmlUtil.writeAttrWhenExist((Element)node, (String)"parallelMeasureLayout", (String)this.parallelMeasureLayout.toPersistance());
            }
            XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"frozenTop", (Boolean)this.frozenTop);
            XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"frozenLeft", (Boolean)this.frozenLeft);
        }

        public void fromXml(Element node) throws PersistentModelParseException {
            this.totalAhead = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"totalAhead");
            String pml = XmlUtil.readAttrWhenExist((Element)node, (String)"parallelMeasureLayout");
            this.parallelMeasureLayout = pml == null ? ParallelMeasureLayout.AtColumn : ParallelMeasureLayout.fromPersistance(pml);
            this.frozenTop = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"frozenTop");
            this.frozenLeft = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"frozenLeft");
        }
    }
}

