/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.longer.preferences;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class ExhibitionStatus {
    private int[] row;
    private int[] column;
    private int[] height;
    private int[] width;
    private List<TreeExpandState> treeExpandState;

    public int[] getPaintableRowHeight() {
        return this.height;
    }

    public int[] getPaintableColumnWidth() {
        return this.width;
    }

    public List<TreeExpandState> getTreeExpandStates() {
        return this.treeExpandState;
    }

    public void toXml(Element node) {
        if (this.row != null && this.row.length > 0) {
            node.setAttribute("row", this.array2String(this.row));
        }
        if (this.height != null && this.height.length > 0) {
            node.setAttribute("height", this.array2String(this.height));
        }
        if (this.column != null && this.column.length > 0) {
            node.setAttribute("column", this.array2String(this.column));
        }
        if (this.width != null && this.width.length > 0) {
            node.setAttribute("width", this.array2String(this.width));
        }
        if (this.treeExpandState != null && this.treeExpandState.size() > 0) {
            Element nodeTreeExpandState = new Element("TreeExpandState");
            for (TreeExpandState state : this.treeExpandState) {
                Element nodeItem = new Element("Item");
                XmlUtil.writeAttrDefaultTrue((Element)nodeItem, (String)"expanded", (boolean)state.isExpanded());
                XmlUtil.writeAttrWhenExist((Element)nodeItem, (String)"keys", (String)state.getEncodedKeys());
                XmlUtil.writeAttrDefaultFalse((Element)nodeItem, (String)"horizontal", (boolean)state.isHorizontal());
                nodeTreeExpandState.addContent((Content)nodeItem);
            }
            node.addContent((Content)nodeTreeExpandState);
        }
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        this.row = this.string2Array(node.getAttributeValue("row"));
        this.column = this.string2Array(node.getAttributeValue("column"));
        this.height = this.string2Array(node.getAttributeValue("height"));
        this.width = this.string2Array(node.getAttributeValue("width"));
        Element nodeTreeExpandState = node.getChild("TreeExpandState");
        if (nodeTreeExpandState != null) {
            List itemNodes = nodeTreeExpandState.getChildren("Item");
            this.treeExpandState = new ArrayList<TreeExpandState>(itemNodes.size());
            for (Element nodeItem : itemNodes) {
                TreeExpandState state = new TreeExpandState();
                state.setExpanded(XmlUtil.readAttrDefaultTrue((Element)nodeItem, (String)"expanded"));
                state.setEncodedKeys(XmlUtil.readAttrWhenExist((Element)nodeItem, (String)"keys"));
                state.setHorizontal(XmlUtil.readAttrDefaultFalse((Element)nodeItem, (String)"horizontal"));
                this.treeExpandState.add(state);
            }
        }
    }

    private String array2String(int[] array) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(Integer.toString(array[i]));
        }
        return sb.toString();
    }

    private int[] string2Array(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        String[] items = str.split(",");
        int[] array = new int[items.length];
        for (int i = 0; i < items.length; ++i) {
            array[i] = Integer.parseInt(items[i]);
        }
        return array;
    }

    public static class TreeExpandState {
        private Boolean expanded;
        private String keys;
        private Boolean horizontal;

        public void setExpanded(boolean isExpanded) {
            this.expanded = isExpanded;
        }

        public boolean isExpanded() {
            return this.expanded == null ? false : this.expanded;
        }

        public void setEncodedKeys(String keys) {
            this.keys = keys;
        }

        public String getEncodedKeys() {
            return this.keys;
        }

        public String[] getKeys() {
            String[] decodedKeys = this.keys.split("_\\|_");
            return decodedKeys;
        }

        public void setHorizontal(boolean isHorizontal) {
            this.horizontal = isHorizontal;
        }

        public boolean isHorizontal() {
            return this.horizontal == null ? false : this.horizontal;
        }
    }
}

