/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.meta;

import com.kingdee.bos.qing.common.grammar.expr.AbstractOpExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.core.engine.func.AbstractInterlineFunction;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.meta.CustomPeriod;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.DimensionNecessity;
import com.kingdee.bos.qing.core.model.meta.MetaTable;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;

public class MetaField {
    private transient MetaTable _table;
    private transient String _fullName;
    private transient String _fullDisplayName;
    private String name;
    private String displayName;
    private DataType dataType;
    private String formatString;
    private Integer fiscalYearStart;
    private String sortAccording;
    private List<String> customOrder;
    private transient Map<String, Integer> _runtimeCustomOrder;
    private String formula;
    private transient IExpr _expr;
    private Set<String> dependence;
    private String invalid;
    private FormulaAggStatus formulaAggStaus;
    private String userCreated;
    private String group;
    private String hide;
    private DimensionNecessity necessary;
    private CustomPeriod customPeriod;
    private Boolean lost;

    public void setLost(boolean lost) {
        this.lost = lost ? Boolean.TRUE : null;
    }

    public boolean isLost() {
        return this.lost == Boolean.TRUE;
    }

    public MetaTable getMetaTable() {
        return this._table;
    }

    public void setMetaTable(MetaTable table) {
        this._table = table;
        this._fullName = null;
        this._fullDisplayName = null;
    }

    public String getFullName() {
        if (this._fullName == null) {
            String tableName = this._table == null ? null : this._table.getName();
            this._fullName = MetaField.encodeFullName(tableName, this.name);
        }
        return this._fullName;
    }

    public String getFullDisplayName() {
        if (this._fullDisplayName == null) {
            String tableDisplayName = this._table == null ? null : this._table.getDisplayName();
            this._fullDisplayName = MetaField.encodeFullName(tableDisplayName, this.displayName == null ? "" : this.displayName);
        }
        return this._fullDisplayName;
    }

    public String getPureName() {
        return this.name;
    }

    public void setPureName(String name) {
        this.name = name;
        this._fullName = null;
    }

    public String getPureDisplayName() {
        return this.displayName;
    }

    public void setPureDisplayName(String displayName) {
        this.displayName = displayName;
        this._fullDisplayName = null;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public int getFiscalYearStart() {
        return this.fiscalYearStart == null ? 0 : this.fiscalYearStart;
    }

    public void setFiscalYearStart(int month) {
        this.fiscalYearStart = month;
    }

    public String getSortAccordingFieldFullName() {
        return this.sortAccording;
    }

    public void setSortAccordingFieldFullName(String fullName) {
        this.sortAccording = fullName;
    }

    public List<String> getCustomOrder() {
        return this.customOrder;
    }

    public void setCustomOrder(List<String> customOrder) {
        this.customOrder = customOrder;
    }

    public boolean isOrderCustomized() {
        return this.customOrder != null && !this.customOrder.isEmpty();
    }

    public Integer getCustomOrderIndex(Object member) {
        if (this._runtimeCustomOrder == null) {
            List<String> members = this.getCustomOrder();
            this._runtimeCustomOrder = new HashMap<String, Integer>(members.size());
            int c = members.size();
            for (int i = 0; i < c; ++i) {
                String key = members.get(i);
                this._runtimeCustomOrder.put(key, i);
            }
        }
        return this._runtimeCustomOrder.get(member);
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public IExpr getExpr() {
        return this._expr;
    }

    public void setExpr(IExpr expr) {
        this._expr = expr;
    }

    public boolean isInvalid() {
        return "true".equalsIgnoreCase(this.invalid);
    }

    public void setInvalid(boolean isInvalid) {
        this.invalid = isInvalid ? "true" : null;
    }

    public boolean isCalculation() {
        return this.formula != null;
    }

    public boolean isValidCalculation() {
        return this._expr != null && !this.isInvalid();
    }

    public Set<String> getAllDependence() {
        return this.dependence;
    }

    public void setAllDependence(Set<String> primitiveFieldNames) {
        this.dependence = primitiveFieldNames;
    }

    public FormulaAggStatus getFormulaAggStatus() {
        return this.formulaAggStaus;
    }

    public void setFormulaAggStatus(FormulaAggStatus status) {
        this.formulaAggStaus = status;
    }

    public boolean isUserCreated() {
        return "true".equalsIgnoreCase(this.userCreated);
    }

    public void setUserCreated(boolean isUserCreated) {
        this.userCreated = isUserCreated ? "true" : null;
    }

    public String getGroupName() {
        return this.group;
    }

    public void setGaoupName(String group) {
        this.group = group;
    }

    public boolean isHide() {
        return "true".equalsIgnoreCase(this.hide);
    }

    public void setHide(boolean isHide) {
        this.hide = isHide ? "true" : null;
    }

    public DimensionNecessity getDimensionNecessity() {
        return this.necessary;
    }

    public void setDimensionNecessity(DimensionNecessity necessary) {
        this.necessary = necessary;
    }

    public CustomPeriod getCustomPeriod() {
        return this.customPeriod;
    }

    public void setCustomPeriod(CustomPeriod customPeriod) {
        this.customPeriod = customPeriod;
    }

    public boolean isCubeInterlineCalculation() {
        if (this.isValidCalculation()) {
            IExpr root = this.getExpr();
            ArrayList<IExpr> queue = new ArrayList<IExpr>();
            queue.add(root);
            while (!queue.isEmpty()) {
                IExpr[] subs;
                IExpr node = (IExpr)queue.remove(0);
                if (node instanceof AbstractInterlineFunction) {
                    return true;
                }
                if (!(node instanceof AbstractOpExpr)) continue;
                for (IExpr sub : subs = ((AbstractOpExpr)node).getSubExprs()) {
                    queue.add(sub);
                }
            }
        }
        return false;
    }

    public Element toXml() {
        Element node = new Element("Field");
        XmlUtil.writeAttrNotNull((Element)node, (String)"name", (String)this.name);
        XmlUtil.writeAttrNotNull((Element)node, (String)"alias", (String)this.displayName);
        XmlUtil.writeAttrNotNull((Element)node, (String)"dataType", (String)this.dataType.toPersistance());
        XmlUtil.writeAttrWhenExist((Element)node, (String)"format", (String)this.formatString);
        XmlUtil.writeAttrIntWhenExist((Element)node, (String)"fiscalYearStart", (Integer)this.fiscalYearStart);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"sortAccording", (String)this.sortAccording);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"formula", (String)this.formula);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"userCreated", (String)this.userCreated);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"group", (String)this.group);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"hide", (String)this.hide);
        if (this.customPeriod != null) {
            Element nodeCustomPeriod = this.customPeriod.toXml();
            nodeCustomPeriod.setName("CustomPeriod");
            node.addContent((Content)nodeCustomPeriod);
        }
        if (this.customOrder != null && !this.customOrder.isEmpty()) {
            Element nodeCustomOrder = new Element("CustomOrder");
            int c = this.customOrder.size();
            for (int i = 0; i < c; ++i) {
                String member = this.customOrder.get(i);
                Element nodeMember = new Element("Member");
                XmlUtil.addCDATA((Element)nodeMember, (String)member);
                nodeCustomOrder.addContent((Content)nodeMember);
            }
            node.addContent((Content)nodeCustomOrder);
        }
        return node;
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        Element nodeCustomOrder;
        try {
            this.name = XmlUtil.readAttrNotNull((Element)node, (String)"name");
            this.displayName = XmlUtil.readAttrNotNull((Element)node, (String)"alias");
            String dataType = XmlUtil.readAttrNotNull((Element)node, (String)"dataType");
            try {
                this.dataType = DataType.fromPersistance(dataType);
            }
            catch (Exception ex) {
                throw new PersistentModelParseException("Unknown data type: " + dataType);
            }
        }
        catch (XmlUtil.NullException ex) {
            throw new PersistentModelParseException(ex);
        }
        this.formatString = XmlUtil.readAttrWhenExist((Element)node, (String)"format");
        this.fiscalYearStart = XmlUtil.readAttrIntWhenExist((Element)node, (String)"fiscalYearStart");
        this.sortAccording = XmlUtil.readAttrWhenExist((Element)node, (String)"sortAccording");
        this.formula = XmlUtil.readAttrWhenExist((Element)node, (String)"formula");
        this.userCreated = XmlUtil.readAttrWhenExist((Element)node, (String)"userCreated");
        this.group = XmlUtil.readAttrWhenExist((Element)node, (String)"group");
        this.hide = XmlUtil.readAttrWhenExist((Element)node, (String)"hide");
        Element nodeCustomPeriod = node.getChild("CustomPeriod");
        if (nodeCustomPeriod != null) {
            this.customPeriod = new CustomPeriod();
            this.customPeriod.fromXml(nodeCustomPeriod);
        }
        if ((nodeCustomOrder = node.getChild("CustomOrder")) != null) {
            List memberNodes = nodeCustomOrder.getChildren("Member");
            this.customOrder = new ArrayList<String>(memberNodes.size());
            int c = memberNodes.size();
            for (int i = 0; i < c; ++i) {
                Element nodeMember = (Element)memberNodes.get(i);
                String member = nodeMember.getText();
                if (member.length() == 0) {
                    member = null;
                }
                this.customOrder.add(member);
            }
        }
    }

    public static String encodeFullName(String tableName, String fieldPureName) {
        if (tableName == null || tableName.isEmpty()) {
            return fieldPureName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tableName);
        sb.append(".");
        sb.append(fieldPureName);
        return sb.toString();
    }

    public static String[] decodeFullName(String fullName) {
        String fieldPureName;
        String tableName;
        int dotIdx = fullName.indexOf(".");
        if (dotIdx == -1) {
            tableName = null;
            fieldPureName = fullName;
        } else {
            tableName = fullName.substring(0, dotIdx);
            fieldPureName = fullName.substring(dotIdx + 1);
        }
        return new String[]{tableName, fieldPureName};
    }

    public static MetaField getNotNullInstance(Map<String, MetaField> metaFields, String fullName) {
        MetaField mf = metaFields.get(fullName);
        if (mf == null) {
            String[] parts = MetaField.decodeFullName(fullName);
            String tableName = parts[0];
            String fieldPureName = parts[1];
            mf = new MetaField();
            mf.setLost(true);
            mf.setPureName(fieldPureName);
            MetaTable mt = new MetaTable();
            mt.setName(tableName == null ? "" : tableName);
            mf.setMetaTable(mt);
        }
        return mf;
    }

    public static enum FormulaAggStatus {
        Ref,
        Agg,
        Interline,
        WithTotal;


        public static boolean isRelativeAggregation(FormulaAggStatus inst) {
            return inst == Agg || inst == Interline || inst == WithTotal;
        }

        public int getLevel() {
            return this.ordinal();
        }
    }
}

