/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.model;

import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.IReference;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.model.cosmetic.CosmeticModel;
import com.kingdee.bos.qing.dashboard.model.style.Style;
import com.kingdee.bos.qing.dashboard.model.widget.AbstractContainer;
import com.kingdee.bos.qing.dashboard.model.widget.AbstractWidget;
import com.kingdee.bos.qing.dashboard.model.widget.Page;
import com.kingdee.bos.qing.dashboard.model.widget.WidgetTypeName;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class DashboardModel {
    private static final String VERSION = "20230101";
    private Boolean isTooModern;
    private Page page;
    private List<Style> styles;
    private CosmeticModel cosmetic;

    public String searchWidgetReferenceUid(final String widgetName) {
        final ArrayList referenceUidWrap = new ArrayList();
        this.page.visitAllWidgets(new Page.IWidgetVisitor(){

            @Override
            public boolean visiting(AbstractWidget widget) {
                if (widget instanceof IReference && widgetName.equals(widget.getName())) {
                    String uid = ((IReference)((Object)widget)).getRef().getUid();
                    referenceUidWrap.add(uid);
                    return true;
                }
                return false;
            }
        });
        return referenceUidWrap.isEmpty() ? null : (String)referenceUidWrap.get(0);
    }

    public String searchReferenceWidgetDisplayName(final String referenceUid) {
        final ArrayList displayNameWrap = new ArrayList();
        this.page.visitAllWidgets(new Page.IWidgetVisitor(){

            @Override
            public boolean visiting(AbstractWidget widget) {
                if (widget instanceof IReference && referenceUid.equals(((IReference)((Object)widget)).getRef().getUid())) {
                    displayNameWrap.add(widget.getDisplayName());
                    return true;
                }
                return false;
            }
        });
        return displayNameWrap.isEmpty() ? null : (String)displayNameWrap.get(0);
    }

    public void fixReferences(List<ReferenceMap> refItems) {
        HashMap<String, ReferenceMap> searching = new HashMap<String, ReferenceMap>(refItems.size());
        int c = refItems.size();
        for (int i = 0; i < c; ++i) {
            ReferenceMap item = refItems.get(i);
            searching.put(item.getUid(), item);
        }
        LinkedList<AbstractWidget> queue = new LinkedList<AbstractWidget>();
        queue.addLast(this.page);
        Page.Background background = this.page.getBackgroundPicture();
        if (background != null) {
            queue.addLast(background);
        }
        while (!queue.isEmpty()) {
            IReference widget;
            ReferenceMap ref;
            AbstractWidget each = (AbstractWidget)queue.removeFirst();
            if (each instanceof IReference && (ref = (ReferenceMap)searching.get((widget = (IReference)((Object)each)).getRef().getUid())) != null) {
                widget.setRef(ref);
            }
            if (!(each instanceof AbstractContainer)) continue;
            AbstractContainer container = (AbstractContainer)each;
            int c2 = container.getChildrenCount();
            for (int i = 0; i < c2; ++i) {
                queue.addLast(container.getChild(i));
            }
        }
    }

    public List<ReferenceMap> pickReferences() {
        ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>();
        LinkedList<AbstractWidget> queue = new LinkedList<AbstractWidget>();
        queue.addLast(this.page);
        Page.Background background = this.page.getBackgroundPicture();
        if (background != null) {
            queue.addLast(background);
        }
        while (!queue.isEmpty()) {
            AbstractWidget each = (AbstractWidget)queue.removeFirst();
            if (each instanceof IReference) {
                IReference widget = (IReference)((Object)each);
                refItems.add(widget.getRef());
            }
            if (!(each instanceof AbstractContainer)) continue;
            AbstractContainer container = (AbstractContainer)each;
            int c = container.getChildrenCount();
            for (int i = 0; i < c; ++i) {
                queue.addLast(container.getChild(i));
            }
        }
        return refItems;
    }

    public Element toXml() {
        Element root = new Element("QingDashboard");
        root.setAttribute("version", VERSION);
        Element nodePage = this.page.toXml();
        root.addContent((Content)nodePage);
        if (this.styles != null) {
            Element nodeStyles = new Element("Styles");
            for (int i = 0; i < this.styles.size(); ++i) {
                Style style = this.styles.get(i);
                Element nodeStyle = new Element("Style");
                style.toXml(nodeStyle);
                nodeStyles.addContent((Content)nodeStyle);
            }
            root.addContent((Content)nodeStyles);
        }
        if (this.cosmetic != null) {
            Element nodeCosmetic = new Element("Cosmetic");
            this.cosmetic.toXml(nodeCosmetic);
            root.addContent((Content)nodeCosmetic);
        }
        return root;
    }

    public void fromXml(Element root) throws PersistentModelParseException {
        Element nodeCosmetic;
        int modelVersion = this.checkVersion(root);
        Element nodePage = null;
        try {
            nodePage = XmlUtil.getChildNotNull((Element)root, (String)WidgetTypeName.Page.toXmlNodeName());
        }
        catch (XmlUtil.NullException e) {
            throw PersistentModelParseException.createParseError("<Page> not found.");
        }
        this.page = new Page();
        try {
            this.page.fromXml(nodePage);
        }
        catch (PersistentModelParseException ex) {
            if (this.isTooModern == Boolean.TRUE) {
                String msg = "Runtime env(20230101) is older than persistent model(" + modelVersion + ").";
                throw PersistentModelParseException.createTooModern((Throwable)((Object)ex), msg);
            }
            throw ex;
        }
        Element nodeStyles = XmlUtil.getChild((Element)root, (String)"Styles");
        if (nodeStyles != null) {
            List styleNodes = XmlUtil.getChildren((Element)nodeStyles, (String)"Style");
            this.styles = new ArrayList<Style>(styleNodes.size());
            for (Element nodeStyle : styleNodes) {
                Style style = new Style();
                style.fromXml(nodeStyle);
                this.styles.add(style);
            }
        }
        if ((nodeCosmetic = XmlUtil.getChild((Element)root, (String)"Cosmetic")) != null) {
            this.cosmetic = new CosmeticModel();
            this.cosmetic.fromXml(nodeCosmetic);
        }
        this.upgradeModel(modelVersion);
    }

    private int checkVersion(Element root) throws PersistentModelParseException {
        int modelVersion;
        String version;
        try {
            version = XmlUtil.readAttrNotNull((Element)root, (String)"version");
        }
        catch (XmlUtil.NullException e) {
            throw PersistentModelParseException.createParseError("The attribute 'version' is missing.");
        }
        int runtimeVersion = Integer.parseInt(VERSION);
        try {
            modelVersion = Integer.parseInt(version);
        }
        catch (NumberFormatException ex) {
            throw PersistentModelParseException.createParseError("Invalid version: " + version);
        }
        if (modelVersion > runtimeVersion) {
            this.isTooModern = Boolean.TRUE;
        } else if (modelVersion < 20200525) {
            try {
                this.upgradeXmlTo20200525(root);
            }
            catch (Exception ex) {
                LogUtil.error((String)"Exception in upgradeXmlTo20200525()", (Throwable)ex);
            }
        }
        return modelVersion;
    }

    private void upgradeXmlTo20200525(Element root) {
        Element nodeStyles = new Element("Styles");
        int count = 0;
        Element nodePage = XmlUtil.getChild((Element)root, (String)"Page");
        Element nodePageChildren = XmlUtil.getChild((Element)nodePage, (String)"Children");
        List widgetNodes = XmlUtil.getChildren((Element)nodePageChildren);
        for (Element nodeWidget : widgetNodes) {
            if ("Label".equals(nodeWidget.getName())) {
                count += this.upgrageLabelXmlTo20200525(nodeWidget, nodeStyles, count);
                continue;
            }
            if (!"Panel".equals(nodeWidget.getName())) continue;
            Element nodePanelChildren = XmlUtil.getChild((Element)nodeWidget, (String)"Children");
            List subWidgetNodes = XmlUtil.getChildren((Element)nodePanelChildren);
            for (Element nodeSubWidget : subWidgetNodes) {
                if (!"Label".equals(nodeSubWidget.getName())) continue;
                count += this.upgrageLabelXmlTo20200525(nodeWidget, nodeStyles, count);
            }
        }
        if (count > 0) {
            root.addContent((Content)nodeStyles);
        }
    }

    private int upgrageLabelXmlTo20200525(Element nodeLabel, Element nodeStyles, int count) {
        String fontSize = XmlUtil.readAttrWhenExist((Element)nodeLabel, (String)"fontSize");
        String align = XmlUtil.readAttrWhenExist((Element)nodeLabel, (String)"textAlign");
        if (fontSize == null && align == null) {
            return 0;
        }
        Element nodeStyle = new Element("Style");
        XmlUtil.writeAttrWhenExist((Element)nodeStyle, (String)"fontSize", (String)fontSize);
        XmlUtil.writeAttrWhenExist((Element)nodeStyle, (String)"align", (String)align);
        nodeStyles.addContent((Content)nodeStyle);
        nodeLabel.setAttribute("styleId", Integer.toString(count));
        return 1;
    }

    private void upgradeModel(int modelVersion) throws PersistentModelParseException {
        if (modelVersion == 20210406) {
            this.upgradeCosmeticPalette();
        }
        if (modelVersion < 20211225) {
            this.upgradeCosmeticWaterfallPalette();
        }
    }

    private void upgradeCosmeticPalette() throws PersistentModelParseException {
        if (this.cosmetic != null) {
            try {
                String key = "chartPalette";
                CosmeticModel preset = CosmeticModel.loadPresetCosmetic("white");
                List<CosmeticModel.Item> items = preset.getGroup(key);
                if (items != null) {
                    this.cosmetic.upgrade(key, items);
                }
            }
            catch (PersistentModelParseException ex) {
                throw PersistentModelParseException.createParseError((Throwable)((Object)ex), "Load preset skin to upgrade persistent model(v20210406) error.");
            }
        }
    }

    private void upgradeCosmeticWaterfallPalette() throws PersistentModelParseException {
        if (this.cosmetic != null) {
            try {
                String key = "chartWaterfall";
                CosmeticModel preset = CosmeticModel.loadPresetCosmetic("white");
                List<CosmeticModel.Item> items = preset.getGroup(key);
                if (items != null) {
                    this.cosmetic.upgrade(key, items);
                }
            }
            catch (PersistentModelParseException ex) {
                throw PersistentModelParseException.createParseError((Throwable)((Object)ex), "Load preset skin to upgrade persistent model(v<20211225) error.");
            }
        }
    }
}

