/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.model.cosmetic;

import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class CosmeticModel {
    public static final String SKIN_WHITE = "white";
    public static final String SKIN_DARKBLUE = "darkBlue";
    private Map<String, List<Item>> groups;

    public List<Item> getGroup(String groupId) {
        return this.groups.get(groupId);
    }

    public void upgrade(String groupId, List<Item> items) {
        this.groups.put(groupId, items);
    }

    public void toXml(Element node) {
        for (String key : this.groups.keySet()) {
            Element nodeGroup = new Element("Group");
            XmlUtil.writeAttrNotNull((Element)nodeGroup, (String)"id", (String)key);
            List<Item> items = this.groups.get(key);
            for (Item item : items) {
                Element nodeItem = new Element("Item");
                item.toXml(nodeItem);
                nodeGroup.addContent((Content)nodeItem);
            }
            node.addContent((Content)nodeGroup);
        }
    }

    public void fromXml(Element node) {
        this.groups = new HashMap<String, List<Item>>();
        List groupNodes = XmlUtil.getChildren((Element)node, (String)"Group");
        for (Element nodeGroup : groupNodes) {
            String key;
            try {
                key = XmlUtil.readAttrNotNull((Element)nodeGroup, (String)"id");
            }
            catch (XmlUtil.NullException ex) {
                LogUtil.error((String)"CosmeticModel.fromXml: group without id.");
                continue;
            }
            List itemNodes = XmlUtil.getChildren((Element)nodeGroup, (String)"Item");
            ArrayList<Item> items = new ArrayList<Item>();
            for (Element nodeItem : itemNodes) {
                Item item = new Item();
                try {
                    item.fromXml(nodeItem);
                }
                catch (PersistentModelParseException ex) {
                    LogUtil.error((String)("CosmeticModel.fromXml: parseItem error. " + XmlUtil.toString((Element)nodeItem)));
                    continue;
                }
                items.add(item);
            }
            this.groups.put(key, items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CosmeticModel loadPresetCosmetic(String skin) throws PersistentModelParseException {
        String fileName = SKIN_DARKBLUE.equalsIgnoreCase(skin) ? "dark_blue.xml" : "white.xml";
        InputStream inStm = null;
        Element root = null;
        try {
            inStm = CosmeticModel.class.getResourceAsStream(fileName);
            try {
                root = XmlUtil.loadRootElement((InputStream)inStm);
            }
            catch (JDOMException ex) {
                throw PersistentModelParseException.createParseError(ex);
            }
            catch (IOException ex) {
                throw PersistentModelParseException.createParseError(ex);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{inStm});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{inStm});
        CosmeticModel model = new CosmeticModel();
        model.fromXml(root);
        return model;
    }

    public static class Item {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void toXml(Element node) {
            XmlUtil.writeAttrNotNull((Element)node, (String)"key", (String)this.key);
            XmlUtil.writeAttrNotNull((Element)node, (String)"value", (String)this.value);
        }

        public void fromXml(Element node) throws PersistentModelParseException {
            try {
                this.key = XmlUtil.readAttrNotNull((Element)node, (String)"key");
                this.value = XmlUtil.readAttrNotNull((Element)node, (String)"value");
            }
            catch (XmlUtil.NullException ex) {
                throw PersistentModelParseException.createParseError(ex);
            }
        }
    }
}

