/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.model.filter.source;

import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.filter.source.AbstractFilterSource;
import com.kingdee.bos.qing.dashboard.model.filter.source.FilterSourceType;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class FilterSourceFromCustomList
extends AbstractFilterSource {
    private List<Item> items;

    @Override
    protected FilterSourceType getType() {
        return FilterSourceType.CustomList;
    }

    @Override
    protected void toXmlMore(Element node) {
        for (Item item : this.items) {
            Element nodeItem = new Element("Item");
            nodeItem.setAttribute("value", item.getValue());
            nodeItem.setAttribute("text", item.getText());
            node.addContent((Content)nodeItem);
        }
    }

    @Override
    protected void fromXmlMore(Element node) throws PersistentModelParseException {
        List itemNodes = node.getChildren("Item");
        this.items = new ArrayList<Item>(itemNodes.size());
        for (Element nodeItem : itemNodes) {
            Item item = new Item();
            item.setValueText(nodeItem.getAttributeValue("value"), nodeItem.getAttributeValue("text"));
            this.items.add(item);
        }
    }

    public static class Item {
        private String value;
        private String text;

        public void setValueText(String value, String text) {
            this.value = value;
            this.text = text;
        }

        public String getValue() {
            return this.value;
        }

        public String getText() {
            return this.text;
        }
    }
}

