/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.model.rich;

import com.kingdee.bos.qing.dashboard.model.rich.Chapter;
import com.kingdee.bos.qing.dashboard.model.rich.Content;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

public class Paragraph {
    private List<Content> contents;
    private String align;
    private Integer indent;
    private int lineHeight;
    private Integer marginBefore;
    private Integer marginAfter;

    public void setContents(List<Content> contents) {
        this.contents = contents;
    }

    public int getContentCount() {
        return this.contents.size();
    }

    public Content getContent(int idx) {
        return this.contents.get(idx);
    }

    public String getAlign() {
        return this.align;
    }

    public float getIndent() {
        return this.indent == null ? 0.0f : (float)this.indent.intValue() * 0.01f;
    }

    public float getLineHeight() {
        return (float)this.lineHeight * 0.01f;
    }

    public int getMarginBefore() {
        return this.marginBefore == null ? 0 : this.marginBefore;
    }

    public int getMarginAfter() {
        return this.marginAfter == null ? 0 : this.marginAfter;
    }

    public void voteLineHeight(Chapter.FamiliarIntegerVoter voter) {
        voter.vote(this.lineHeight);
    }

    public void toXml(Element node, Chapter.FamiliarValueManager fvm) {
        if (this.lineHeight != fvm.getFamiliarLineHeight()) {
            XmlUtil.writeAttrInt((Element)node, (String)"lineHeight", (int)this.lineHeight);
        }
        XmlUtil.writeAttrWhenExist((Element)node, (String)"align", (String)this.align);
        XmlUtil.writeAttrIntWhenExist((Element)node, (String)"indent", (Integer)this.indent);
        XmlUtil.writeAttrIntWhenExist((Element)node, (String)"marginBefore", (Integer)this.marginBefore);
        XmlUtil.writeAttrIntWhenExist((Element)node, (String)"marginAfter", (Integer)this.marginAfter);
        for (Content content : this.contents) {
            Element nodeContent = new Element("Content");
            content.toXml(nodeContent, fvm);
            node.addContent((org.jdom2.Content)nodeContent);
        }
    }

    public void fromXml(Element node, Chapter.FamiliarValueManager fvm) {
        Integer lineHeight = XmlUtil.readAttrIntWhenExist((Element)node, (String)"lineHeight");
        this.lineHeight = lineHeight == null ? fvm.getFamiliarLineHeight() : lineHeight.intValue();
        this.align = XmlUtil.readAttrWhenExist((Element)node, (String)"align");
        this.indent = XmlUtil.readAttrIntWhenExist((Element)node, (String)"indent");
        this.marginBefore = XmlUtil.readAttrIntWhenExist((Element)node, (String)"marginBefore");
        this.marginAfter = XmlUtil.readAttrIntWhenExist((Element)node, (String)"marginAfter");
        List subNodes = XmlUtil.getChildren((Element)node, (String)"Content");
        this.contents = new ArrayList<Content>(subNodes.size());
        for (Element nodeContent : subNodes) {
            Content content = new Content("");
            content.fromXml(nodeContent, fvm);
            this.contents.add(content);
        }
    }
}

