/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.common.daterange.RuntimeRelativeDateRange;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.runner.longer.EngineRunnerForFilterPreparedValue;
import com.kingdee.bos.qing.core.engine.runner.longer.EngineRunnerForRelativedFilterPreparedValue;
import com.kingdee.bos.qing.core.engine.runner.longer.MdEngineRunner;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.ContinuousDateFilter;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.FilterFieldSet;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.AbstractFilterDomain;
import com.kingdee.bos.qing.monitor.ICorrespondent;

public class FilterDomain
extends AbstractFilterDomain {
    public FilterDomain(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        super(dataSourceCreator);
    }

    public AbstractPreparedValue getFilterPreparedValue(AnalyticalModel model, AnalyticalField field) throws AnalysisException {
        boolean isFilteredByOthers = false;
        boolean isAffected = false;
        FilterFieldSet filterFieldSet = model.getFilterFieldSet();
        AbstractAnalyticalFilter myFilter = null;
        for (int i = 0; i < filterFieldSet.getFieldCount(); ++i) {
            AnalyticalField analyticalField = filterFieldSet.getFields().get(i);
            AbstractAnalyticalFilter filter = filterFieldSet.getFilters().get(i);
            if (analyticalField.isSame(field)) {
                isAffected = filter.isAffected();
                myFilter = filter;
                continue;
            }
            if (filter.isFullValue()) continue;
            isFilteredByOthers = true;
        }
        return super.getFilterPreparedValue(model, field, myFilter, isFilteredByOthers, isAffected);
    }

    @Override
    protected FilterPreparedValueGainer.IPreparedValueFruit getAllPreparedValueByEngine(IQingModel model, AnalyticalField field, ICorrespondent correspondent) throws AnalysisException {
        AnalyticalModel mo = (AnalyticalModel)model;
        IDataSourceVisitor dataSourceVisitor = this.createDataSourceVisitor();
        FilterPreparedValueGainer.IPreparedValueFruit pvfAll = null;
        if (model.getMeta().getSrcMode() == Meta.Src.MD) {
            MdEngineRunner runnerForAll = new MdEngineRunner(dataSourceVisitor, mo);
            runnerForAll.addPreparedValueTargetField(field);
            runnerForAll.setContext(this.getI18nContext());
            runnerForAll.run(correspondent);
            pvfAll = runnerForAll.getPreparedValueFruits().get(0);
        } else {
            EngineRunnerForFilterPreparedValue runnerForAll = new EngineRunnerForFilterPreparedValue(dataSourceVisitor, mo, field);
            runnerForAll.setContext(this.getI18nContext());
            runnerForAll.run(correspondent);
            pvfAll = runnerForAll.getPreparedValueFruits().get(0);
        }
        return pvfAll;
    }

    @Override
    protected FilterPreparedValueGainer.IPreparedValueFruit getRelativedPreparedValue(IQingModel model, AnalyticalField field, ICorrespondent correspondent) throws AnalysisException {
        AnalyticalModel mo = (AnalyticalModel)model;
        IDataSourceVisitor dataSourceVisitor = this.createDataSourceVisitor();
        EngineRunnerForRelativedFilterPreparedValue runnerForRelatived = new EngineRunnerForRelativedFilterPreparedValue(dataSourceVisitor, mo, field);
        runnerForRelatived.setContext(this.getI18nContext());
        runnerForRelatived.setTargetFilterField(field);
        runnerForRelatived.run(correspondent);
        FilterPreparedValueGainer.IPreparedValueFruit pvfRelatived = runnerForRelatived.getPreparedValueFruits().get(0);
        return pvfRelatived;
    }

    public ContinuousDateFilter parseRelativeDateRange(ContinuousDateFilter dateFilter) {
        RuntimeRelativeDateRange rt = new RuntimeRelativeDateRange(dateFilter.getRelativeDateRange());
        rt.parseRange();
        ContinuousDateFilter result = new ContinuousDateFilter();
        result.setDateFrom(rt.getDateStart());
        result.setDateTo(rt.getDateEnd());
        return result;
    }
}

