/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.AbstractChart;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.analysis.square.chart.Map;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.IDiscretePreparedValue;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.SquareFilterDomain;
import com.kingdee.bos.qing.map.MapLoader;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MapDomain
extends AbstractDomain {
    public MapDomain(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        super(dataSourceCreator);
    }

    public MapTemplate loadMapTemplate(String refToId, String refToFullPath) {
        MapLoader.Reference ref = new MapLoader.Reference(refToId, refToFullPath);
        String content = null;
        MapLoader.BackImage backImage = null;
        try {
            content = MapLoader.loadTemplateContent(ref);
            backImage = MapLoader.loadBackImageDescription(ref);
        }
        catch (MapLoader.MapNotFoundException ex) {
            LogUtil.error((String)"", (Throwable)ex);
        }
        catch (MapLoader.MapLoaderException ex) {
            LogUtil.error((String)"", (Throwable)ex);
        }
        MapTemplate inst = new MapTemplate();
        inst.setContent(content);
        inst.setBackImage(backImage);
        return inst;
    }

    public RegionMappingSupport getRegionMappingSupport(String refToId, String refToFullPath, SquareModel squareModel) {
        MapLoader.Reference ref = new MapLoader.Reference(refToId, refToFullPath);
        RegionMappingSupport rms = new RegionMappingSupport();
        rms.setRegions(this.loadMapRegions(ref));
        rms.setData(this.getDimensionMembers(squareModel));
        return rms;
    }

    private List<String> getDimensionMembers(SquareModel model) {
        Map chart = (Map)model.getChartModel();
        ArrayList<AnalyticalField> fields = new ArrayList<AnalyticalField>();
        AbstractChart.AbstractFieldVisitor visitor = AbstractChart.createDimensionSearcher(fields, 1);
        visitor.visit(chart.getDimensionSet());
        if (fields.size() == 0) {
            return null;
        }
        AnalyticalField field = (AnalyticalField)fields.get(0);
        SquareFilterDomain domain = new SquareFilterDomain(this.getDataSourceCreator());
        ArrayList<String> members = new ArrayList<String>();
        int maxCount = 1024;
        AbstractPreparedValue apv = null;
        try {
            apv = domain.getFilterPreparedValue(model, field);
        }
        catch (AnalysisException ex) {
            LogUtil.error((String)"", (Throwable)((Object)ex));
            return null;
        }
        if (apv instanceof IDiscretePreparedValue) {
            IDiscretePreparedValue pv = (IDiscretePreparedValue)((Object)apv);
            List<? extends IDiscretePreparedValue.IDiscreteItem> items = pv.getValues();
            int c = Math.min(maxCount, items.size());
            for (int i = 0; i < c; ++i) {
                IDiscretePreparedValue.IDiscreteItem item = items.get(i);
                String text = item.getText();
                members.add(text == null ? item.getValue() : text);
            }
            if (items.size() > maxCount) {
                members.add("...");
            }
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Region> loadMapRegions(MapLoader.Reference reference) {
        List<Region> list;
        InputStream instm;
        try {
            instm = MapLoader.loadTemplate(reference);
        }
        catch (MapLoader.MapNotFoundException ex) {
            LogUtil.error((String)"", (Throwable)ex);
            return null;
        }
        catch (MapLoader.MapLoaderException ex) {
            LogUtil.error((String)"", (Throwable)ex);
            return null;
        }
        XmlHandler handler = new XmlHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(instm));
            list = handler.getResult();
        }
        catch (Exception ex) {
            try {
                LogUtil.error((String)"", (Throwable)ex);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{instm});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{instm});
            return null;
        }
        CloseUtil.close((Closeable[])new Closeable[]{instm});
        return list;
    }

    public static class RegionMappingSupport {
        private List<Region> regions;
        private List<String> data;

        public void setRegions(List<Region> regions) {
            this.regions = regions;
        }

        public List<Region> getRegions() {
            return this.regions;
        }

        public void setData(List<String> data) {
            this.data = data;
        }

        public List<String> getData() {
            return this.data;
        }
    }

    public static class Region {
        private String name;
        private String display;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setDisplayName(String text) {
            this.display = text;
        }

        public String getDisplayName() {
            return this.display;
        }
    }

    public static class MapTemplate {
        private String content;
        private MapLoader.BackImage backImage;

        public void setContent(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        public void setBackImage(MapLoader.BackImage backImage) {
            this.backImage = backImage;
        }

        public MapLoader.BackImage getBackImage() {
            return this.backImage;
        }
    }

    private static class XmlHandler
    extends DefaultHandler {
        private List<Region> _regions = new ArrayList<Region>();

        private XmlHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("path".equals(qName)) {
                Region region = new Region();
                region.setName(attributes.getValue("name"));
                region.setDisplayName(attributes.getValue("title"));
                this._regions.add(region);
            }
        }

        public List<Region> getResult() {
            return this._regions;
        }
    }
}

