/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.core.engine.DataSourceGreenChannel;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.sort.CommonComparator;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.DataTraversalException;
import com.kingdee.bos.qing.core.flattening.common.ContinuousColorConfirmer;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.ContinuousColor;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.ChartType;
import com.kingdee.bos.qing.core.model.analysis.longer.FilterFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.MarkFieldSet;
import com.kingdee.bos.qing.core.model.exhibition.common.Legends;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.DiscreteSelectableValues;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceNoDataException;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.FilterDomain;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SharedDomain
extends AbstractDomain {
    private static final int CustomOrder_LimitedItems = 100;

    public SharedDomain(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        super(dataSourceCreator);
    }

    public List<String> getCustomizedOrderDimensionMembers(String fieldFullName, List<String> oriCustomOrder, Meta meta) throws AnalysisException {
        MetaField metaField;
        MetaField metaField2 = metaField = meta == null ? null : meta.createSearchingMap().get(fieldFullName);
        Set<String> members = metaField != null && metaField.isValidCalculation() ? (DataType.STRING == metaField.getDataType() ? this.getMembersByEngine(meta, metaField) : new HashSet<String>()) : this.getMembersByPullDown(fieldFullName);
        if (members == null) {
            return null;
        }
        return this.merge(oriCustomOrder, members);
    }

    private List<String> merge(List<String> oriCustomOrder, Set<String> members) {
        List<String> customOrder = oriCustomOrder;
        if (customOrder == null) {
            customOrder = new ArrayList<String>();
        } else {
            Iterator<String> it = customOrder.iterator();
            while (it.hasNext()) {
                String value = it.next();
                if (members.contains(value)) {
                    members.remove(value);
                    continue;
                }
                it.remove();
            }
        }
        if (!members.isEmpty()) {
            String[] ary = members.toArray(new String[0]);
            Arrays.sort(ary, new CommonComparator(this.getI18nContext().getLanManager().getLocale()));
            for (int i = 0; i < ary.length; ++i) {
                customOrder.add(ary[i]);
            }
        }
        return customOrder;
    }

    private AnalyticalModel createEmptyAnalyticalModel() {
        AnalyticalModel model = new AnalyticalModel();
        model.setChartType(ChartType.Table);
        model.setFilterFieldSet(new FilterFieldSet());
        model.setRow(new AnalyticalFieldSet());
        model.setColumn(new AnalyticalFieldSet());
        model.setMarkFieldSet(new MarkFieldSet());
        model.getFilterFieldSet().setFields(new ArrayList<AnalyticalField>());
        model.getRow().setFields(new ArrayList<AnalyticalField>());
        model.getColumn().setFields(new ArrayList<AnalyticalField>());
        model.getMarkFieldSet().setFields(new ArrayList<AnalyticalField>());
        return model;
    }

    private Set<String> getMembersByEngine(Meta meta, MetaField metaField) throws AnalysisException {
        AnalyticalField field = new AnalyticalField();
        field.setName(metaField.getFullName());
        field.setRole("dimension");
        field.bindMetaField(metaField);
        AnalyticalModel model = this.createEmptyAnalyticalModel();
        model.bindMeta(meta);
        FilterDomain domain = new FilterDomain(this.getDataSourceCreator());
        FilterPreparedValueGainer.IPreparedValueFruit fruit = domain.getAllPreparedValueByEngine(model, field);
        DiscreteSelectableValues dsv = (DiscreteSelectableValues)fruit.getPreparedValue();
        List<DiscreteSelectableValues.Item> items = dsv.getValues();
        if (items.size() > 100) {
            return null;
        }
        HashSet<String> members = new HashSet<String>(items.size());
        for (DiscreteSelectableValues.Item item : items) {
            members.add(item.getValue());
        }
        return members;
    }

    private Set<String> getMembersByPullDown(final String fieldFullName) throws AnalysisException {
        final HashSet<String> members = new HashSet<String>();
        DataSourceGreenChannel.AbstractValueCollecter collecter = new DataSourceGreenChannel.AbstractValueCollecter(){
            private boolean isBreak;

            @Override
            public void accept(Map<String, Object> values) {
                Object value = values.get(fieldFullName);
                members.add(value == null ? null : value.toString());
                if (members.size() > 100) {
                    this.isBreak = true;
                }
            }

            @Override
            public boolean isBreak() {
                return this.isBreak;
            }
        };
        DataSourceGreenChannel greenChannel = new DataSourceGreenChannel(this.createDataSourceVisitor());
        try {
            greenChannel.getDistinctValue(fieldFullName, collecter);
        }
        catch (DataSourceNoDataException dataSourceNoDataException) {
        }
        catch (AbstractDataSourceException ex) {
            throw DataTraversalException.createGetDistinctError((Exception)((Object)ex));
        }
        return collecter.isBreak() ? null : members;
    }

    public Legends.ContinuousColorLegend previewContinuousColor(ContinuousColor model) {
        BigDecimal distance;
        BigDecimal max;
        BigDecimal min;
        if (model.getMin() == null && model.getMax() == null) {
            min = new BigDecimal(-100);
            max = new BigDecimal(100);
            if (model.getMiddle() != null) {
                BigDecimal middle = new BigDecimal(model.getMiddle());
                min = middle.add(min);
                max = middle.add(max);
            }
        } else if (model.getMin() == null) {
            max = new BigDecimal(model.getMax());
            min = model.getMiddle() == null ? max.subtract(BigDecimal.ONE) : ((distance = max.subtract(new BigDecimal(model.getMiddle()))).signum() < 0 ? max.subtract(BigDecimal.ONE) : max.subtract(distance).subtract(distance));
        } else if (model.getMax() == null) {
            min = new BigDecimal(model.getMin());
            max = model.getMiddle() == null ? min.add(BigDecimal.ONE) : ((distance = new BigDecimal(model.getMiddle()).subtract(min)).signum() < 0 ? min.add(BigDecimal.ONE) : min.add(distance).add(distance));
        } else {
            min = new BigDecimal(model.getMin());
            max = new BigDecimal(model.getMax());
        }
        ContinuousColorConfirmer confirmer = new ContinuousColorConfirmer(min, max);
        confirmer.setDefinition(model);
        confirmer.getColor(BigDecimal.ZERO);
        return confirmer.createLegend("", "");
    }
}

