/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.core.engine.EngineOfSquare;
import com.kingdee.bos.qing.core.engine.runner.square.EngineRunner;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.flattening.square.SquareViewMakerFactory;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.SquareResultWrapper;
import com.kingdee.bos.qing.core.model.analysis.common.CustomPalette;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.AbstractChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.square.SquareView;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.AdditionalFilterDomain;
import com.kingdee.bos.qing.domain.MetaDomain;
import com.kingdee.bos.qing.monitor.ICorrespondent;
import java.util.List;

public class SquareExecuteDomain
extends AbstractDomain {
    public SquareExecuteDomain(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        super(dataSourceCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SquareResultWrapper execute(SquareModel model) throws AnalysisException {
        IDataSourceVisitor dsVisitor = this.createDataSourceVisitor();
        MetaDomain.verifyMetaFieldsExist(model.getMeta(), dsVisitor.getMeta());
        model.parseConditionStyleExprs();
        EngineRunner engineRunner = new EngineRunner(dsVisitor, model, this.getI18nContext());
        ICorrespondent correspondent = null;
        try {
            correspondent = SquareExecuteDomain.createExecutingCorrespondent();
            EngineOfSquare engine = engineRunner.run(correspondent);
            SquareView sv = this.flat(engineRunner, engine, correspondent, dsVisitor);
            SquareResultWrapper wrapper = new SquareResultWrapper();
            wrapper.setSquareView(sv);
            SquareResultWrapper squareResultWrapper = wrapper;
            return squareResultWrapper;
        }
        finally {
            SquareExecuteDomain.destroyExecutingCorrespondent(correspondent);
        }
    }

    public SquareResultWrapper execute(SquareModel model, AdditionalFilterDomain.AdditionalFilters additionalFilters, CustomPalette paletteFitSkin) throws AnalysisException {
        AbstractChartProperty property;
        if (additionalFilters != null) {
            AdditionalFilterDomain afd = new AdditionalFilterDomain(this.getDataSourceCreator());
            afd.mergeIntoSquare(model, additionalFilters);
        }
        if (paletteFitSkin != null && (property = model.getChartModel().getChartProperty()).getCustomPalette() == null) {
            property.setCustomPalette(paletteFitSkin);
        }
        return this.execute(model);
    }

    private SquareView flat(EngineRunner engineRunner, EngineOfSquare engine, ICorrespondent correspondent, IDataSourceVisitor dsVisitor) throws AnalysisException {
        SquareModel model = engineRunner.getModel();
        AbstractSquareViewMaker maker = SquareViewMakerFactory.createMaker(model.getChartModel().getChartType());
        maker.setAddendumDataVisitor(new AbstractSquareViewMaker.AddendumDataVisitor(dsVisitor));
        maker.setQingContext(this.getI18nContext(), this.getSkinName());
        maker.setModel(model);
        maker.setEngineOutputer(engine);
        maker.setCorrespondent(correspondent);
        maker.make();
        SquareView squareView = maker.getSquareView();
        List<String> lostMetaFields = engineRunner.getMultiInfoWrapper().getLostMetaFields();
        List<String> invalidMetaFields = engineRunner.getMultiInfoWrapper().getInvalidMetaFields();
        if (!lostMetaFields.isEmpty()) {
            String warning = Messages.getLangMessage(this.getI18nContext(), "fieldNotExist", "\u5b57\u6bb5\u201c#1\u201d\u4e0d\u5b58\u5728\u3002").replace("#1", lostMetaFields.get(0));
            squareView.setWarning(warning);
        } else if (!invalidMetaFields.isEmpty()) {
            String warning = Messages.getLangMessage(this.getI18nContext(), "fieldInvalid", "\u65e0\u6548\u7684\u8ba1\u7b97\u5b57\u6bb5\u201c#1\u201d\u3002").replace("#1", invalidMetaFields.get(0));
            squareView.setWarning(warning);
        }
        return squareView;
    }
}

