/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart;

import com.kingdee.bos.qing.export.chart.ByteArrayOutputStreamAdapter;
import com.kingdee.bos.qing.util.CloseUtil;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PNGEncoder {
    private ByteBuffer data = ByteBuffer.allocate(640000);
    private CRC32 crc = new CRC32();

    private void write(int i) throws IOException {
        byte[] b = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        this.write(b);
    }

    private void write(byte[] b) throws IOException {
        this.data.put(b);
        this.crc.update(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(BufferedImage image) throws IOException {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        byte[] id = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13};
        this.write(id);
        this.crc.reset();
        this.write("IHDR".getBytes());
        this.write(width);
        this.write(height);
        byte[] head = null;
        head = new byte[]{8, 6, 0, 0, 0};
        this.write(head);
        this.write((int)this.crc.getValue());
        ByteArrayOutputStreamAdapter compressed = new ByteArrayOutputStreamAdapter(65536);
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new DeflaterOutputStream((OutputStream)compressed, new Deflater(2)));
            for (int y = 0; y < height; ++y) {
                bos.write(0);
                for (int x = 0; x < width; ++x) {
                    int pixel = image.getRGB(x, y);
                    bos.write((byte)(pixel >> 16 & 0xFF));
                    bos.write((byte)(pixel >> 8 & 0xFF));
                    bos.write((byte)(pixel & 0xFF));
                    bos.write((byte)(pixel >> 24 & 0xFF));
                }
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{bos});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{bos});
        this.write(compressed.size());
        this.crc.reset();
        this.write("IDAT".getBytes());
        this.write(compressed.toByteArray());
        this.write((int)this.crc.getValue());
        this.write(0);
        this.crc.reset();
        this.write("IEND".getBytes());
        this.write((int)this.crc.getValue());
    }

    public byte[] getData() {
        return this.data.array();
    }
}

